/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.viewer.option.ViewerOption;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * ΥǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public class Loader {
    private ViewerOption  option;
    private RequestBroker broker;

    /**
     * Υޤ
     */
    protected Loader() {
    }

    /**
     * ӥ塼Υȥåץ᥽åɤǤ
     *
     * @param  args 
     */
    public static void main(String[] args) {
        (new Loader()).start(args);
    }

    /** ӥ塼򳫻Ϥ */
    private void start(String[] args) {
        int exitCode = -1;

        try {
            option = new ViewerOption();
            broker = new RequestBroker(option);

            HawkViewer viewer = null;
            if (broker.isServerMode()) {
                HawkViewer.addDefaultWindowListener(new ViewerWindowListener());
                viewer = new HawkViewer(option);
                viewer.show();
            }

            // URL 򥪡ץʤΤȤ㳰̵뤷Ʒ³
            try {
                int index = HawkViewer.CURRENT_TAB;
                for (int i = 0; i < args.length; i++) {
                    if (viewer != null) {
                        if (i > 0) {
                            index = viewer.createTab(HawkViewer.LAST_TAB, false);
                        }
                        viewer.open(index, args[i]);
                    } else {
                        broker.send(args[i]);
                    }
                }
            } catch (RuntimeException e) {
                e.printStackTrace(Debug.err);
            }
        } catch (RuntimeException e) {
            exitCode = 1;
            e.printStackTrace(Debug.err);
        } finally {
            try {
                if (broker != null) {
                    // 饤ȥ⡼ɤξϤ˽λ
                    if (!broker.isServerMode()) {
                        exitCode = 0;
                        broker.stop();
                    }
                }
            } catch (RuntimeException e) {
                exitCode = 2;
                e.printStackTrace(Debug.err);
            } finally {
                if (exitCode >= 0) {
                    System.exit(exitCode);
                }
            }
        }
    }

//### ViewerWindowListener
    /** ɥϥɥ */
    private final class ViewerWindowListener extends WindowAdapter {
        int count = 0;

        /** 󥹥󥹤 */
        private ViewerWindowListener() {
        }

        /** ɥ줿Ȥ */
        public synchronized void windowOpened(WindowEvent e) {
            count++;
        }

        /** ɥĤ줿Ȥ */
        public synchronized void windowClosed(WindowEvent e) {
            if (--count == 0) {
                option.save();
                broker.stop();
                System.exit(0);
            }
        }
    }
}
