/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.viewer.event.ContextListener;
import net.hizlab.kagetaka.viewer.event.ContextFocusEvent;
import net.hizlab.kagetaka.viewer.event.ContextFocusListener;
import net.hizlab.kagetaka.viewer.event.ContextHistoryEvent;
import net.hizlab.kagetaka.viewer.event.ContextHistoryListener;
import net.hizlab.kagetaka.viewer.event.ContextInformationEvent;
import net.hizlab.kagetaka.viewer.event.ContextInformationListener;
import net.hizlab.kagetaka.viewer.event.ContextRequestEvent;
import net.hizlab.kagetaka.viewer.event.ContextRequestListener;

/**
 * ӥ塼ѤΥƥȥꥹʤΥޥ㥹ȤԤ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
class ContextEventMulticaster
        implements ContextFocusListener,
                   ContextHistoryListener,
                   ContextInformationListener,
                   ContextRequestListener {

    /** ꥹ a */
    protected final ContextListener a;
    /** ꥹ b */
    protected final ContextListener b;

    /**
     * ꥹ <code>a</code> ȥꥹ <code>b</code> Ĥʤ
     * ٥ȡޥ㥹ȡ󥹥󥹤ޤ
     *
     * @param  a ꥹ <code>a</code>
     * @param  b ꥹ <code>b</code>
     */
    ContextEventMulticaster(ContextListener a, ContextListener b) {
        this.a = a;
        this.b = b;
    }

//### ContextFocusListener
    /** {@inheritDoc} */
    public void focusGained(ContextFocusEvent e) {
        ((ContextFocusListener) a).focusGained(e);
        ((ContextFocusListener) b).focusGained(e);
    }

    /** {@inheritDoc} */
    public void focusLost(ContextFocusEvent e) {
        ((ContextFocusListener) a).focusLost(e);
        ((ContextFocusListener) b).focusLost(e);
    }

//### ContextHistoryListener
    /** {@inheritDoc} */
    public void historyChanged(ContextHistoryEvent e) {
        ((ContextHistoryListener) a).historyChanged(e);
        ((ContextHistoryListener) b).historyChanged(e);
    }

//### ContextInformationListener
    /** {@inheritDoc} */
    public void addressChanged(ContextInformationEvent e) {
        ((ContextInformationListener) a).addressChanged(e);
        ((ContextInformationListener) b).addressChanged(e);
    }

    /** {@inheritDoc} */
    public void titleChanged(ContextInformationEvent e) {
        ((ContextInformationListener) a).titleChanged(e);
        ((ContextInformationListener) b).titleChanged(e);
    }

    /** {@inheritDoc} */
    public void statusChanged(ContextInformationEvent e) {
        ((ContextInformationListener) a).statusChanged(e);
        ((ContextInformationListener) b).statusChanged(e);
    }

//### ContextRequestListener
    /** {@inheritDoc} */
    public void requestAccepted(ContextRequestEvent e) {
        ((ContextRequestListener) a).requestAccepted(e);
        ((ContextRequestListener) b).requestAccepted(e);
    }

    /** {@inheritDoc} */
    public void requestDone(ContextRequestEvent e) {
        ((ContextRequestListener) a).requestDone(e);
        ((ContextRequestListener) b).requestDone(e);
    }

    /**
     * ƥȥեꥹ a 
     * ƥȥեꥹ b äơ
     * η̤Ȥޥ㥹ȥꥹʤ֤ޤ
     *
     * @param     a ƥȥեꥹ
     * @param     b ƥȥեꥹ
     *
     * @return    ޥ㥹ȥꥹ
     */
    public static ContextFocusListener add(ContextFocusListener a,
                                           ContextFocusListener b) {
        return (ContextFocusListener) addInternal(a, b);
    }

    /**
     * ƥȥեꥹ l 
     * Ťƥȥեꥹʤơ
     * η̤Ȥޥ㥹ȥꥹʤ֤ޤ
     *
     * @param     l    ƥȥեꥹ
     * @param     oldl 륳ƥȥեꥹ
     *
     * @return    ޥ㥹ȥꥹ
     */
    public static ContextFocusListener remove(ContextFocusListener l,
                                              ContextFocusListener oldl) {
        return (ContextFocusListener) removeInternal(l, oldl);
    }

    /**
     * ƥȥҥȥꥹ a 
     * ƥȥҥȥꥹ b äơ
     * η̤Ȥޥ㥹ȥꥹʤ֤ޤ
     *
     * @param     a ƥȥҥȥꥹ
     * @param     b ƥȥҥȥꥹ
     *
     * @return    ޥ㥹ȥꥹ
     */
    public static ContextHistoryListener add(ContextHistoryListener a,
                                             ContextHistoryListener b) {
        return (ContextHistoryListener) addInternal(a, b);
    }

    /**
     * ƥȥҥȥꥹ l 
     * Ťƥȥҥȥꥹʤơ
     * η̤Ȥޥ㥹ȥꥹʤ֤ޤ
     *
     * @param     l    ƥȥҥȥꥹ
     * @param     oldl 륳ƥȥҥȥꥹ
     *
     * @return    ޥ㥹ȥꥹ
     */
    public static ContextHistoryListener remove(ContextHistoryListener l,
                                                ContextHistoryListener oldl) {
        return (ContextHistoryListener) removeInternal(l, oldl);
    }

    /**
     * ƥȥե᡼ꥹ a 
     * ƥȥե᡼ꥹ b äơ
     * η̤Ȥޥ㥹ȥꥹʤ֤ޤ
     *
     * @param     a ƥȥե᡼ꥹ
     * @param     b ƥȥե᡼ꥹ
     *
     * @return    ޥ㥹ȥꥹ
     */
    public static ContextInformationListener add(ContextInformationListener a,
                                                 ContextInformationListener b) {
        return (ContextInformationListener) addInternal(a, b);
    }

    /**
     * ƥȥե᡼ꥹ l 
     * Ťƥȥե᡼ꥹʤơ
     * η̤Ȥޥ㥹ȥꥹʤ֤ޤ
     *
     * @param     l    ƥȥե᡼ꥹ
     * @param     oldl 륳ƥȥե᡼ꥹ
     *
     * @return    ޥ㥹ȥꥹ
     */
    public static ContextInformationListener remove(ContextInformationListener l,
                                                    ContextInformationListener oldl) {
        return (ContextInformationListener) removeInternal(l, oldl);
    }

    /**
     * ƥȥꥯȥꥹ a 
     * ƥȥꥯȥꥹ b äơ
     * η̤Ȥޥ㥹ȥꥹʤ֤ޤ
     *
     * @param     a ƥȥꥯȥꥹ
     * @param     b ƥȥꥯȥꥹ
     *
     * @return    ޥ㥹ȥꥹ
     */
    public static ContextRequestListener add(ContextRequestListener a,
                                             ContextRequestListener b) {
        return (ContextRequestListener) addInternal(a, b);
    }

    /**
     * ƥȥꥯȥꥹ l 
     * Ťƥȥꥯȥꥹʤơ
     * η̤Ȥޥ㥹ȥꥹʤ֤ޤ
     *
     * @param     l    ƥȥꥯȥꥹ
     * @param     oldl 륳ƥȥꥯȥꥹ
     *
     * @return    ޥ㥹ȥꥹ
     */
    public static ContextRequestListener remove(ContextRequestListener l,
                                                ContextRequestListener oldl) {
        return (ContextRequestListener) removeInternal(l, oldl);
    }

    /** ꥹʤä */
    private static ContextListener addInternal(ContextListener a, ContextListener b) {
        if (a == null) { return b; }
        if (b == null) { return a; }

        return new ContextEventMulticaster(a, b);
    }

    /** ꥹʤ */
    private static ContextListener removeInternal(ContextListener l, ContextListener oldl) {
        if (l == oldl || l == null) {
            return null;
        } else if (l instanceof ContextEventMulticaster) {
            return ((ContextEventMulticaster) l).remove(oldl);
        } else {
            return l;
        }
    }

    /** ꥹʤ */
    private ContextListener remove(ContextListener oldl) {
        if (oldl == a) { return b; }
        if (oldl == b) { return a; }

        ContextListener a2 = removeInternal(a, oldl);
        ContextListener b2 = removeInternal(b, oldl);

        if (a2 == a && b2 == b) {
            return this;
        }

        return addInternal(a2, b2);
    }
}
