/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.viewer.event.ContextEvent;

import net.fclabs.util.Queue;

/**
 * ƥȥ٥Ȥޥ͡󶡤ޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
final class ContextEventManager {
    private int       windowNumber;
    private Deliverer deliverer;
    private Queue     queue;

    /**
     * ӥ塼Ф륳ƥȥ٥ȥޥ͡ޤ
     *
     * @param  wn ɥֹ
     */
    ContextEventManager(int wn) {
        this.windowNumber = wn;
        this.queue        = new Queue();
        this.deliverer    = new Deliverer();

        // 
        deliverer.start();
    }

    /**
     * ƥȥ٥Ȥۿޤ
     *
     * @param  e ٥
     */
    void dispatch(ContextEvent e) {
        queue.put(e);
    }

    /**
     * ٥Ƚߤޤ
     */
    void dispose() {
        deliverer.interrupt();
    }

//### Deliverer
    /** ٥ã */
    private final class Deliverer extends Thread {
        /** 󥹥󥹤 */
        private Deliverer() {
            setDaemon(true);
            setName  ("ContextEventDeliverer-" + windowNumber);
        }

        /** ¹ */
        public void run() {
            try {
                while (!isInterrupted()) {
                    ContextEvent event = (ContextEvent) queue.waitObject();
                    try {
                        event.getContext().processContextEvent(event);
                    } catch (RuntimeException e) {
                        //### ERROR
Debug.err.println("### ERROR ### ContextEventManager.Deliverer.run : " + e);
e.printStackTrace(Debug.err);
                    }
                }
            } catch (InterruptedException e) { }
Debug.out.println(getName() + " died");
        }
    }
}
