/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.protocol.CacheSupported;
import net.hizlab.kagetaka.protocol.URLConnectionCache;
import net.hizlab.kagetaka.rendering.PostData;

import java.io.InputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

/**
 * å򥵥ݡȤ <code>http</code> ץȥΥͥɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class CachedURLConnection extends URLConnection implements CacheSupported {
    private InputStream is;
    private CacheManager cacheManager;
    private CacheEntry   cacheEntry;

    /**
     * 󥹥󥹤ޤ
     *
     * @param  cacheManager åޥ͡
     * @param  url          ꥯȤ줿 URL
     * @param  cacheEntry   å奨ȥ
     *
     * @throws IOException IO 顼ȯ
     */
    CachedURLConnection(CacheManager cacheManager, URL url, CacheEntry cacheEntry)
            throws IOException {
        super(url);

        this.is           = cacheEntry.file.getInputStream();
        this.cacheManager = cacheManager;
        this.cacheEntry   = cacheEntry;

        connected = true;
        URLConnectionCache.getEntry(url).setCacheFile(cacheEntry.file);
    }

//### URLConnection
    /**
     * ƥĤΥ֤ޤ
     *
     * @return ƥĤΥ
     */
    public int getContentLength() {
        return (int) cacheEntry.file.length();
    }

    /**
     * ƥĥפ֤ޤ
     *
     * @return ƥĥ
     */
    public String getContentType() {
        return cacheEntry.contentType;
    }

    /**
     * ƥĥ󥳡ǥ󥰤֤ޤ
     *
     * @return ƥĥ󥳡ǥ
     */
    public String getContentEncoding() {
        return null;
    }

    /**
     * ͭ¤֤ޤ
     *
     * @return ͭ
     */
    public long getExpiration() {
        return cacheEntry.expiration;
    }

    /**
     * ƥĤμ֤ޤ
     *
     * @return 
     */
    public long getDate() {
        return cacheEntry.date;
    }

    /**
     * ƥĤκǽ֤ޤ
     *
     * @return ǽ
     */
    public long getLastModified() {
        return cacheEntry.lastModified;
    }

    /**
     * ꤵ줿̾Υإå֤ͤޤ
     *
     * @param  name ء̾
     *
     * @return إå
     */
    public String getHeaderField(String name) {
        if (name.toLowerCase().compareTo("etag") == 0) {
            return cacheEntry.eTag;
        }

        return null;
    }

    /**
     * ³Ԥޤ
     */
    public void connect() {
    }

    /**
     * 쥹ݥ󥹤ɤ߹ϥȥ꡼ᤷޤ
     *
     * @return ϥȥ꡼
     */
    public InputStream getInputStream() {
        return is;
    }

//### CacheSupported
    /** {@inheritDoc} */
    public void setupCache(net.hizlab.kagetaka.protocol.CacheManager cm, PostData pd) {
    }

    /** {@inheritDoc} */
    public void removeCache() {
        cacheManager.removeEntry(cacheEntry);
    }

    /** {@inheritDoc} */
    public String getCachePath() {
        return cacheEntry.file.getPath();
    }
}
