/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.protocol.CacheFile;

import java.io.PrintWriter;
import java.io.FileNotFoundException;
import java.io.InvalidObjectException;
import java.net.URL;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * åݻ륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
class CacheEntry {
    final String           key;
    final boolean          memoryOnly;
    final CacheFile        file;
    final URL              url;
    final String           contentType;
    final long             expiration;
    final long             date;
    final long             lastModified;
    final String           eTag;
    final long             length;
    final SSLCertification sslCertification;

    private int    useTimes;
    private String stringEntry;
    CacheEntry next;
    CacheEntry prev;

    /**
     * åޤ
     *
     * @param  key              åΥ
     * @param  memoryOnly       ꡼Τߤɤ
     * @param  file             ե
     * @param  url              URL
     * @param  contentType      ƥĥ
     * @param  expiration       ͭ
     * @param  date             
     * @param  lastModified     ǽ
     * @param  eTag             ETag
     * @param  sslCertification SSL 
     */
    CacheEntry(String key, boolean memoryOnly, CacheFile file, URL url,
               String contentType, long expiration,
               long date, long lastModified, String eTag,
               SSLCertification sslCertification) {
        this.key              = key;
        this.memoryOnly       = (memoryOnly || sslCertification != null);
        this.file             = file;
        this.url              = url;
        this.contentType      = contentType;
        this.expiration       = expiration;
        this.date             = date;
        this.lastModified     = lastModified;
        this.eTag             = eTag;
        this.length           = file.length();
        this.sslCertification = sslCertification;
    }

    /**
     * å奤ǥå󤫤ޤ
     *
     * @param  cacheDir åǥ쥯ȥ
     * @param  line     ǥåι
     *
     * @throws InvalidObjectException Ԥʾ
     * @throws FileNotFoundException  åե뤬¸ߤʤ
     */
    CacheEntry(String cacheDir, String line)
            throws InvalidObjectException, FileNotFoundException {
        int p1 = 0, p2, length = line.length();
        String[] s = new String[7];
        for (int i = 0; i < 7; i++) {
            if ((p2 = line.indexOf('\t', p1)) == -1) {
                p2 = length;
            }

            s[i] = line.substring(p1, p2);
            if ((p1 = p2 + 1) >= length) {
                break;
            }
        }

        if (s[5] == null) {
            throw new InvalidObjectException("invalid format");
        }

        try {
            this.file = new CacheFile(cacheDir, s[0]);
            if (!file.exists()) {
                throw new FileNotFoundException(file.getPath());
            }

            this.key              = s[1];
            this.memoryOnly       = false;
            this.url              = new URL(key);
            this.contentType      = s[2];
            this.expiration       = Long.parseLong(s[3]);
            this.date             = Long.parseLong(s[4]);
            this.lastModified     = Long.parseLong(s[5]);
            this.eTag             = s[6];
            this.length           = file.length();
            this.sslCertification = null;
        } catch (NumberFormatException e) {
            throw new InvalidObjectException("invalid number format");
        } catch (MalformedURLException e) {
            throw new InvalidObjectException("invalid url format");
        }
    }

    /**
     * ꥽ޤ
     */
    void dispose() {
        file.delete();
    }

    /**
     * Ƥ񤭽Фޤ
     *
     * @param  pw 饤
     *
     * @return ¸ <code>true</code>
     *         ¸ʤä <code>false</code>
     */
    boolean save(PrintWriter pw) {
        if (/*---*/memoryOnly
                || (expiration > 0 && expiration <= System.currentTimeMillis())) {
            return false;
        }

        pw.print(file.getName());
        pw.print('\t'); pw.print(key         ); // URL ˤ #ref ޤޤΤ key Ȥ
        pw.print('\t'); pw.print(contentType );
        pw.print('\t'); pw.print(expiration  );
        pw.print('\t'); pw.print(date        );
        pw.print('\t'); pw.print(lastModified);
        pw.print('\t'); if (eTag != null) { pw.print(eTag); }
        pw.println();

        return true;
    }

    /**
     * Ѳ򥤥󥯥ȤߤλѲ֤ޤ
     *
     * @return Ѳ
     */
    int incrementTimes() {
        return useTimes++;
    }

    /**
     * åλѲꥻåȤޤ
     */
    void resetTimes() {
        useTimes = 1;
    }

    /**
     * ʸɽ֤ޤ
     *
     * @return ʸɽ
     */
    public String toString() {
        if (stringEntry != null) {
            return stringEntry;
        }

        StringBuffer sb = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

        sb.append(this.getClass().getName());
        sb.append('[');
        sb.append(file.getName());
        sb.append(',');
        sb.append(url);
        sb.append(',');
        sb.append(contentType);
        sb.append(',');
        if (expiration > 0) {
            sb.append(sdf.format(new Date(expiration  )));
        }
        sb.append(',');
        if (date > 0) {
            sb.append(sdf.format(new Date(date        )));
        }
        sb.append(',');
        if (lastModified > 0) {
            sb.append(sdf.format(new Date(lastModified)));
        }
        if (eTag != null) {
            sb.append(',');
            sb.append(eTag);
        }
        sb.append(']');

        return (stringEntry = sb.toString());
    }
}
