/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DialogBox;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;

/**
 * ǧھϤ뤿ΥǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public class AuthorizationDialog extends DialogBox {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.Resources";
    private static final int    MARGIN   = 3;

    /**  */
    public static final int SERVER = 0;
    /** ץ */
    public static final int PROXY  = 1;

    /** @serial ̾ */
    private Label     site;
    /** @serial ΰ */
    private Label     realm;
    /** @serial  */
    private int       type;
    /** @serial 桼̾ */
    private TextField username;
    /** @serial ѥ */
    private TextField password;

    /**
     * ǧڥܥåɽη̤֤ޤ
     *
     * @param  owner ʡ
     * @param  site  
     * @param  realm ΰ
     * @param  atype ǧڥ
     * @param  type  ǧΥ
     *
     * @return Ϥ줿桼̾ȥѥɡ
     *         󥻥뤵줿 <code>null</code>
     */
    public static AuthenticationInfo show(Frame owner, String site, String realm, char atype, int type) {
        AuthorizationDialog dialog = new AuthorizationDialog(owner);

        dialog.setSite (site );
        dialog.setRealm(realm);
        dialog.setType (type );
        dialog.show();

        if (dialog.getResult() != RESULT_OK) {
            return null;
        }

        return new AuthenticationInfo(realm,
                                      atype,
                                      dialog.getUsername(),
                                      dialog.getPassword());
    }

    /**
     * ǧڥܥåޤ
     *
     * @param  owner ʡ
     */
    public AuthorizationDialog(Frame owner) {
        super(owner, BUTTON_OKCANCEL);
        setTitle    (getMessage("title." + type));
        setResizable(false);
        setModal    (true );

        // ᥤѥͥ
        GridBagLayout gbl    = new GridBagLayout();
        Insets        insets = new Insets(MARGIN, MARGIN, MARGIN, MARGIN);
        mainPanel.setLayout(gbl);

        addToPanel(           new Label    (getMessage("message"       )), gbl, 0, 0, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(           new Label    (getMessage("label.site"    )), gbl, 0, 1, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(site     = new Label    (getMessage(null            )), gbl, 1, 1, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(           new Label    (getMessage("label.realm"   )), gbl, 0, 2, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(realm    = new Label    (getMessage(null            )), gbl, 1, 2, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(           new Label    (getMessage("label.username")), gbl, 0, 3, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(username = new TextField(40                          ), gbl, 1, 3, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(           new Label    (getMessage("label.password")), gbl, 0, 4, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
        addToPanel(password = new TextField(40                          ), gbl, 1, 4, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);

        // ƥȥΥǥեȤ
        password.setEchoChar('*');

        // 礭
        pack();
    }

    /** ꥽ʸ */
    private String getMessage(String key) {
        if (key == null) {
            return "";
        }

        return Resource.getMessage(RESOURCE, "authorizationdialog." + key, null);
    }

    /**
     * ꤵƤ륵Ȥ֤ޤ
     *
     * @return 
     */
    public String getSite() {
        return site.getText();
    }

    /**
     * Ȥꤷޤ
     *
     * @param  value 
     */
    public void setSite(String value) {
        site.setText(value);
    }

    /**
     * ꤵƤΰ֤ޤ
     *
     * @return ΰ
     */
    public String getRealm() {
        return realm.getText();
    }

    /**
     * ΰꤷޤ
     *
     * @param  value ΰ
     */
    public void setRealm(String value) {
        realm.setText(value);
    }

    /**
     * ꤵƤǧΥפ֤ޤ
     *
     * @return ǧ西
     */
    public int getType() {
        return type;
    }

    /**
     * ǧΥפꤷޤ
     *
     * @param  type ǧ西
     */
    public void setType(int type) {
        this.type = type;
        setTitle(getMessage("title." + type));
    }

    /**
     * Ϥ줿桼֤̾ޤ
     *
     * @return 桼̾
     */
    public String getUsername() {
        return username.getText();
    }

    /**
     * 桼̾ꤷޤ
     *
     * @param  value 桼̾
     */
    public void setUsername(String value) {
        username.setText(value);
    }

    /**
     * Ϥ줿ѥɤ֤ޤ
     *
     * @return ѥ
     */
    public String getPassword() {
        return password.getText();
    }

    /**
     * ѥɤꤷޤ
     *
     * @param  value ѥ
     */
    public void setPassword(String value) {
        password.setText(value);
    }
}
