/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.fclabs.util.Base64;

import java.awt.Frame;
import java.net.URL;
import java.util.Hashtable;

/**
 * ǧھϤ뤿ΥǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
class AuthenticationInfo {
    /** Сå */
    static final char SERVER = 's';
    /** ץå */
    static final char PROXY  = 'p';

    /** <code>Basic</code> ǧ */
    static final char BASIC  = 'b';
    /** <code>Digest</code> ǧ */
    static final char DIGEST = 'd';
    /** <code>NTLM</code> ǧ */
    static final char NTLM   = 'n';

    private static Hashtable realmCache = new Hashtable();
    private static Hashtable urlCache   = new Hashtable();

    private char    atype;
    private String  realm;
    private String  username;
    private String  password;
    private String  value;
    private boolean hasCache;

    /**
     * ǧھޤ
     *
     * @param  realm    ΰ
     * @param  atype    ǧڥ
     * @param  username 桼̾
     * @param  password ѥ
     */
    AuthenticationInfo(String realm, char atype, String username, String password) {
        this.atype    = atype;
        this.realm    = realm;
        this.username = username;
        this.password = password;

        // Basic Τ
        if (atype == BASIC) {
            this.value = "Basic " + new String(Base64.encode((username + ":" + password).getBytes()));
        }
    }

    /**
     * ǧ֤ͤޤ
     *
     * @return ǧڤ
     */
    String getValue() {
        return value;
    }

    /**
     * ʸɽ֤ޤ
     *
     * @return ʸɽ
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append('{');
        sb.append("realm=");
        sb.append(realm);
        sb.append(", user=");
        sb.append(username);
        sb.append('}');
        return sb.toString();
    }

    /**
     * URL 򸵤ˡǧھ֤ޤ
     *
     * @param  target å
     * @param  url    URL
     *
     * @return ǧھ
     *         ¸ߤʤ <code>null</code>
     */
    static AuthenticationInfo get(char target, URL url) {
        return get(target, url, null, (char) 0);
    }

    /**
     * URL ΰ򸵤ˡǧھ֤ޤ
     *
     * @param  target å
     * @param  url    URL
     * @param  realm  ΰ
     * @param  atype  ǧڥ
     *
     * @return ǧھ
     *         ¸ߤʤ <code>null</code>
     */
    static AuthenticationInfo get(char target, URL url, String realm, char atype) {
        StringBuffer sb = getKey(target, url);

        // realm 鸡
        if (realm != null) {
            sb.append(':'  );
            sb.append(realm);
            return (AuthenticationInfo) realmCache.get(sb.toString());
        }

        // Υå夫ѥɤ򸡺
        Host host = (Host) urlCache.get(sb.toString());
        if (host == null) {
            return null;
        }

        return host.find(getPath(url), atype);
    }

    /**
     * URL ΰ򸵤ˡǧھ֤ޤ
     *
     * @param  useCache åѤ <code>true</code>
     *                  Ѥʤ <code>false</code>
     * @param  owner    ʡ
     * @param  target   å
     * @param  url      URL
     * @param  realm    ΰ
     * @param  atype    ǧڥ
     *
     * @return ǧھ
     *         ¸ߤʤ <code>null</code>
     */
    static AuthenticationInfo get(boolean useCache, Frame owner,
                                  char target, URL url, String realm, char atype) {
        synchronized (urlCache) {
            AuthenticationInfo auth = get(target, url, realm, atype);
            if (auth != null) {
                return auth;
            }

            // 桼˼
            auth = AuthorizationDialog.show(owner, url.getHost(), realm, atype,
                                            (target == SERVER ? AuthorizationDialog.SERVER : AuthorizationDialog.PROXY));
            if (auth != null) {
                put(target, auth, url);
                return auth;
            } else if (!useCache && realm != null) {
                // realm å夫
                StringBuffer sb = getKey(target, url);
                sb.append(':'  );
                sb.append(realm);
                realmCache.remove(sb.toString());
            }

            return null;
        }
    }

    /**
     * ǧھꤷޤ
     *
     * @param  target å
     * @param  auth   ǧھ
     * @param  url    URL
     */
    static void put(char target, AuthenticationInfo auth, URL url) {
        StringBuffer sb = getKey(target, url);
        String key = sb.toString();

        // Realm åɲ
        if (!auth.hasCache) {
            sb.append(':'       );
            sb.append(auth.realm);
            realmCache.put(sb.toString(), auth);

            auth.hasCache = true;
        }

        // URL åɲ
        synchronized (urlCache) {
            Path path = new Path(getPath(url), auth);
            Host host = (Host) urlCache.get(key);
            if (host != null) {
                host.add(path);
            } else {
                host = new Host(path);
                urlCache.put(key, host);
            }
        }
    }

    /**  */
    private static StringBuffer getKey(char target, URL url) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(target                         ); sb.append(':');
        sb.append(url.getProtocol().toLowerCase()); sb.append(':');
        sb.append(url.getHost    ().toLowerCase()); sb.append(':');
        sb.append(url.getPort    ()              );
        return sb;
    }

    /** URL κѥ */
    private static String getPath(URL url) {
        String path = url.getFile();
        if (path == null || path.length() == 0) {
            return "/";
        }

        int p = path.indexOf('?');

        return cutPath(path, (p == -1 ? path.length() : p));
    }

    /** ѥû */
    private static String cutPath(String path, int p) {
        if (/*---*/p <= 0
                || (p = path.lastIndexOf('/', p - 1)) < 0) {
            return null;
        }

        return path.substring(0, p + 1);
    }

//### Host
    /** Ʊ URL Υꥹ */
    private static final class Host {
        private Path top;
        private Path last;

        /** 󥹥󥹤 */
        private Host(Path add) {
            top = last = add;
        }

        /**  */
        private synchronized AuthenticationInfo find(String key, char atype) {
            Path path = top;

            while (path != null) {
                if (/*---*/key.startsWith(path.path)
                        && (atype == 0
                         || atype == path.auth.atype)) {
                    return path.auth;
                }

                path = path.next;
            }

            return null;
        }

        /** Ŭڤʰ֤ɲ */
        private synchronized void add(Path add) {
            Path path  = top;
            int  depth = add.depth;

            for (;;) {
                // ʬѥ̵ϺǸɲ
                if (path == null) {
                    if (top == null) {
                        top = last = add;
                    } else {
                        last.next = add;
                        add.prev  = last;
                        last = add;
                    }
                    return;
                }

                // ʬѥξϡμɲ
                if (path.depth <= depth) {
                    break;
                }
                path = path.next;
            }

            // path μɲ
            if (path.prev == null) {
                path.prev = add;
                add.next  = path;
                top = add;
            } else {
                add.prev = path.prev;
                add.next = path;
                path.prev.next = add;
                path.prev      = add;
            }
        }
    }

//### Path
    /** ѥ */
    private static final class Path {
        private String             path;
        private int                depth;
        private AuthenticationInfo auth;
        private Path next;
        private Path prev;

        /** 󥹥󥹤 */
        private Path(String path, AuthenticationInfo auth) {
            this.path = path;
            this.auth = auth;

            int p     = -1;
            int depth = 0;
            while ((p = path.indexOf('/', p + 1)) != -1) {
                depth++;
            }
            this.depth = depth;
        }
    }
}
