/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;

/**
 * ʸФԤ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public final class StringUtils {
    private static final char[] FILENAME_LAST = {';', '?', '#'};

    /** ߡ */
    private StringUtils() {
    }

    /**
     * ꤷʸ URL Ѵޤ
     *
     * @param  text ʸ
     *
     * @return URLѴǤʤä <code>null</code>
     *
     * @throws MalformedURLException URL ѴǤʤä
     */
    public static URL toURL(String text)
            throws MalformedURLException {
        String path = null;

        // Ϥ줿 URL 
        if (text.startsWith(".")) {
            path = text;
        } else if (text.startsWith("file:")) {
            path = text.substring(5);
        } else {
            if (Environment.isWindows) {
                if (/*---*/(text.length() >= 3 && text.charAt(1) == ':')
                        || text.startsWith("\\\\")) {
                    path = text;
                }
            } else {
                if (text.startsWith("/")) {
                    path = text;
                }
            }
        }

        if (path != null) {
            // Ƭ;ʬ / 
            int p = 0;
            while (p < path.length() && path.charAt(p) == '/') {
                p++;
            }
            if (p > (Environment.isWindows ? 2 : 1)) {
                if (Environment.isWindows && p >= 5) { // Windows ͥåȥѥ
                    p -= 2;
                }
                path = path.substring(p);
            }

            if (Environment.isWindows && path.length() >= 2 && path.charAt(1) == '|') {
                path = path.charAt(0) + ":" + path.substring(2);
            }

            int p1 = path.indexOf('?');
            int p2 = path.indexOf('#');
            String option = null;
            if ((p = (p1 != -1 && p2 != -1 ? Math.min(p1, p2) : Math.max(p1, p2))) != -1) {
                option = path.substring(p);
                path   = path.substring(0, p);
            }

            File file = new File(path);
            try {
                path = file.getCanonicalPath().replace('\\', '/');
            } catch (IOException e) { }

            if (path.startsWith("/")) {           // UNIX  Windows ͥåȥѥ
                text = "file:" + path;
            } else {
                text = "file:/" + path;
            }
            if (option != null) {
                text += option;
            }
        } else if (text.indexOf(':') == -1) {
            text = "http://" + text;
        }

        URL url = new URL(text);

        if (/*---*/"http".compareTo(url.getProtocol()) == 0
                && (url.getFile() == null || url.getFile().length() == 0)) {
            url = new URL(url, "/");
        }

        return url;
    }

    /**
     * URL Υѥե̾ȴФޤ
     *
     * @param  path URL ΥѥХѥġ
     *
     * @return ե̾
     */
    public static String getFile(String path) {
        int p;
        int pq = path.length();
        int ps = 0;

        for (int i = 0; i < FILENAME_LAST.length; i++) {
            if ((p = path.indexOf(FILENAME_LAST[i])) != -1) {
                if (p < pq) {
                    pq = p;
                }
            }
        }

        if ((ps = path.lastIndexOf('/' , pq)) == -1) {
            ps = path.lastIndexOf('\\', pq);
        }

        if (ps != -1 || pq != path.length()) {
            return path.substring(ps + 1, pq);
        }

        return path;
    }

    /**
     * URL ե̾ȴФޤ
     *
     * @param  url URL
     *
     * @return ե̾
     */
    public static String getFile(URL url) {
        return getFile(url.getFile());
    }

    /**
     * URL ƱեɽƤ뤫ɤӤޤ
     * <p>
     * {@link URL#sameFile(URL)}  DNS ΥååפԤᡢ
     * ץĶǤϻ֤ΤǡΥ᥽åɤȤޤ
     *
     * @param  url1 URL
     * @param  url2 URL
     *
     * @return Ʊ <code>true</code>
     *         㤦 <code>false</code>
     */
    public static boolean sameFile(URL url1, URL url2) {
        String urlString1 = url1.toExternalForm();
        String urlString2 = url2.toExternalForm();

        int p = 0;

        if ((p = urlString1.indexOf('#')) != -1) {
            urlString1 = urlString1.substring(0, p);
        }
        if ((p = urlString2.indexOf('#')) != -1) {
            urlString2 = urlString2.substring(0, p);
        }

        return (urlString1.compareTo(urlString2) == 0);
    }

    /**
     * ʸʸ֤ޤ
     *
     * @param  value     Ѵоݤʸ
     * @param  oldString ʸ
     * @param  newString ʸ
     *
     * @return Ѵ줿ʸ
     */
    public static String replace(String value, String oldString, String newString) {
        int startPoint = 0, endPoint = 0;

        if ((endPoint = value.indexOf(oldString, startPoint)) == -1) {
            return value;
        }

        int length = oldString.length();
        StringBuffer sb = new StringBuffer();

        do {
            sb.append(value.substring(startPoint, endPoint));
            sb.append(newString);
            startPoint = endPoint + length;
        } while ((endPoint = value.indexOf(oldString, startPoint)) >= 0);

        if (value.length() > endPoint) {
            sb.append(value.substring(startPoint));
        }

        return sb.toString();
    }
}
