/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.util;

/**
 * int Хåե󥰤륯饹Ǥ
 * Υ饹®٤ͥ褵뤿ˡƱԤޤ
 * ޤ{@link #getInts()} ᥽åɤϡΥХåեΰ
 * ֤ᡢդɬפǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public final class IntBuffer {
    private int[] buffer;
    private int   length;
    private int   capacity;

    /**
     * ̤ 16 Ĥ int Хåեޤ
     */
    public IntBuffer() {
        this(16);
    }

    /**
     * ꤵ줿̤ int Хåեޤ
     *
     * @param  size 
     */
    public IntBuffer(int size) {
        buffer   = new int[size];
        capacity = size;
    }

    /**
     * int ͤɲäޤ
     *
     * @param  n ɲä
     */
    public void append(int n) {
        if (length == capacity) {
            // ĥ
            int newCapacity = (int) ((capacity + 1) * (capacity < 1024 ? 2.0 : 1.5));
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }

            int[] newBuffer = new int[newCapacity];
            System.arraycopy(buffer, 0, newBuffer, 0, length);
            buffer   = newBuffer;
            capacity = newCapacity;
        }

        buffer[length++] = n;
    }

    /**
     * ꤵ줿ǥåͤѹޤ
     *
     * @param  index ǥå
     * @param  n     
     */
    public void replace(int index, int n) {
        if (index >= length) {
            throw new IndexOutOfBoundsException(index + " >= " + length);
        }

        buffer[index] = n;
    }

    /**
     * ꤵ줿ǥå֤ͤޤ
     *
     * @param  index ǥå
     *
     * @return 
     */
    public int get(int index) {
        if (index >= length) {
            throw new IndexOutOfBoundsException(index + " >= " + length);
        }

        return buffer[index];
    }

    /**
     * ХåեΤΤ֤ޤ
     * ХåեͭϰϤϡ{@link #length()} ᥽åɤͤޤǤǤ
     * ΥХåեϡIntBuffer Ѥ줤Хåեľܤ
     * 󥹥󥹤ʤΤǡ{@link #replace(int, int)} ᥽åɤθƤӽФˤ
     * ѹ줿ꡢХåեγĥˤͭǤϤʤʤäꤹΤ
     * դɬפǤ
     *
     * @return ǼƤĿ
     */
    public int[] getInts() {
        return buffer;
    }

    /**
     * ΥХåե˳ǼƤ int θĿ֤ޤ
     *
     * @return ǼƤĿ
     */
    public int length() {
        return length;
    }

    /**
     * Хåեˤޤ
     */
    public void clear() {
        length = 0;
    }
}
