/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.util;

import net.hizlab.kagetaka.Resource;

import java.text.ParseException;
import java.util.Hashtable;

/**
 * Content-Type ƱʸϤ륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public final class ContentHeaderParser {
    /** ߡ */
    private ContentHeaderParser() {
    }

    /**
     * ꤵ줿ʸ򸵤ˡContent-Type Ʊ
     * ѡԤޤ
     *
     * @param  value Content-Type Ʊν񼰤Υǡ
     *
     * @return ѡ줿ǡ
     *
     * @throws ParseException ϤǤ줿
     */
    public static Data parse(String value)
            throws ParseException {
        String    type       = null;
        Hashtable parameters = new Hashtable();
        int       semicolon  = value.indexOf(';');

        if (semicolon == -1) {
            type = value.trim();
        } else {
            type = value.substring(0, semicolon).trim();
            // ѥ᡼ʬ򤹤
            int p = semicolon + 1;
            int start = p, end = value.length();
            char c;
            String key = null;
            ALL:
            while (p < end) {
                // ɤФ
                while (value.charAt(p) <= 0x20) {
                    if (++p >= end) {
                        break ALL;
                    }
                }

                start = p;
                p--;
                for (;;) {
                    if (++p >= end) {
                        break ALL;
                    }
                    // 
                    c = value.charAt(p);
                    if (c <= 0x20) {
                        key = value.substring(start, p).toLowerCase();
                        // ɤФ(϶򤬤ƤϤʤ)
                        while (value.charAt(p) <= 0x20) {
                            if (++p >= end) {
                                break ALL;
                            }
                        }
                        // μˤʸå
                        c = value.charAt(p);
                        if (c == '=') {                 // 
                            break;
                        }
                        if (c == ';') {                 // ۥȤϤ
                            parameters.put(key, "");
                            continue ALL;
                        }
                        throw new ParseException(Resource.getMessage("contenttype.error.parameter",
                                                                     new String[]{value}), p);
                    } else if (c == '=') {
                        key = value.substring(start, p).toLowerCase();
                        if (++p >= end) {
                            break ALL;
                        }
                        break;
                    } else if (c == ';') {            // ۥȤϤ
                        parameters.put(value.substring(start, p).toLowerCase(), "");
                        continue ALL;
                    }
                }

                // ɤФ(ɬפʤ)
                while (value.charAt(p) <= 0x20) {
                    if (++p >= end) {
                        break ALL;
                    }
                }

                start = p;
                // 
                if (value.charAt(p) == '"') {
                    // " ǻϤޤäƤ硢\ ϥʸ
                    boolean escape = false;
                    StringBuffer sb = new StringBuffer();
                    start++;
                    for (;;) {
                        if (++p >= end) {
                            break ALL;
                        }
                        if (escape) {
                            sb.append(value.charAt(p));
                            escape = false;
                            continue;
                        }
                        if (value.charAt(p) == '"') {
                            break;
                        }
                        if (value.charAt(p) == '\\') {
                            escape = true;
                            continue;
                        }
                        sb.append(value.charAt(p));
                    }
                    parameters.put(key, sb.toString());
                    if (++p >= end) {
                        break ALL;
                    }
                } else {
                    p--;
                    while (++p < end) {
                        c = value.charAt(p);
                        if (c <= 0x20 || c == ';') {
                            break;
                        }
                    }
                    parameters.put(key, value.substring(start, p));
                    if (p >= end) {
                        break ALL;
                    }
                }

                // ɤФ
                while (value.charAt(p) <= 0x20) {
                    if (++p >= end) {
                        break ALL;
                    }
                }

                // ; ɤФ
                if (value.charAt(p) == ';') {
                    if (++p >= end) {
                        break ALL;
                    }
                    continue;
                }

                // Ϥ
            }
        }

        return new Data(type, parameters);
    }

//### Data
    /**
     * Ϥǡݻ륯饹
     */
    public static final class Data {
        /**  */
        public String    type;
        /** ѥ᡼ */
        public Hashtable parameters;

        /** 󥹥󥹤 */
        private Data(String type, Hashtable parameters) {
            this.type       = type;
            this.parameters = parameters;
        }
    }
}
