/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.util;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.Resource;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

/**
 * 饯åȤJavaΥ󥳡ǥ̾ѴԤޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public final class Charset {
    private static final String RESOURCE = "net.hizlab.kagetaka.util.resources.Charset";
    private static final String DEFAULT_ENCODING_KEY = "DEFAULT";
//    private static final byte[] TEST_BYTES  = {(byte) 0x20};
    private static final byte[] TEST_BYTES  = {}; // for jdk 1.5 beta bugs

    /** ǥեȥ󥳡ǥ */
    private static String    defaultEncoding;
    private static Hashtable supportedEncoding = new Hashtable();
    private static Hashtable encodingTable     = new Hashtable();
    static {
        String encoding = Resource.getMessage(RESOURCE, DEFAULT_ENCODING_KEY, null, null);
        if (encoding != null) {
            if (!isSupported(encoding)) {
                encoding = null;
            }
        }
        defaultEncoding = encoding;
    }

    /**
     * ͣΥ󥹥ȥ饯Ǥ󥹥󥹤κϽޤ
     */
    private Charset() { }

    /**
     * 饯åȤ Java Υ󥳡ǥ̾Ѵޤ
     *
     * @param  charset 饯å
     *
     * @return 󥳡ǥ̾ѴǤʤäꡢ
     *         ݡȤƤʤ <code>null</code>
     */
    public static String toEncoding(String charset) {
        if (isSupported(charset)) {
            return charset;
        }

        String encoding = (String) encodingTable.get(charset);
        if (encoding == null) {
            String key = charset;
            if (key.indexOf('_') != -1) {
                key = key.replace('_', '-');
            }
            encoding = Resource.getMessage(RESOURCE, key.toLowerCase(), null, null);
            if (encoding == null || !isSupported(encoding)) {
                return null;
            }
            encodingTable.put(charset, encoding);
        }
        return encoding;
    }

    /** ꤵ줿󥳡ǥ󥰤ݡȤƤ뤫Ĵ٤ */
    private static boolean isSupported(String encoding) {
        Boolean check = (Boolean) supportedEncoding.get(encoding);
        if (check != null) {
            return check.booleanValue();
        }

        try {
            new String(TEST_BYTES, encoding); // UnsupportedEncodingException å뤿θƤӽФ
            supportedEncoding.put(encoding, Boolean.TRUE);
            return true;
        } catch (UnsupportedEncodingException e) {
        } catch (IllegalArgumentException e) {  // NN ξ
        }
        Debug.out.println("### WARNING ### Charset.isSupported : unknown encoding : [" + encoding + "]");
        supportedEncoding.put(encoding, Boolean.FALSE);
        return false;
    }

    /**
     * ǥեȤΥ󥳡ǥ֤̾ޤ
     *
     * @return ǥեȥ󥳡ǥ̾
     *         <code>null</code> βǽ⤢
     */
    public static String getDefaultEncoding() {
        return defaultEncoding;
    }
}
