/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.util;

/**
 * char Хåե󥰤륯饹Ǥ
 * Υ饹®٤ͥ褵뤿ˡƱԤޤ
 * ޤ{@link #getChars()} ᥽åɤϡΥХåեΰ
 * ֤ᡢդɬפǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public final class CharBuffer {
    private char[] buffer;
    private int    length;
    private int    capacity;

    /**
     * ̤ 16 Ĥ char Хåեޤ
     */
    public CharBuffer() {
        this(16);
    }

    /**
     * ꤵ줿̤ char Хåեޤ
     *
     * @param  size 
     */
    public CharBuffer(int size) {
        buffer   = new char[size];
        capacity = size;
    }

    /**
     * char ͤɲäޤ
     *
     * @param  c ɲäʸ
     */
    public void append(char c) {
        if (length == capacity) {
            // ĥ
            int newCapacity = (int) ((capacity + 1) * (capacity < 1024 ? 2.0 : 1.5));
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }

            char[] newBuffer = new char[newCapacity];
            System.arraycopy(buffer, 0, newBuffer, 0, length);
            buffer   = newBuffer;
            capacity = newCapacity;
        }

        buffer[length++] = c;
    }

    /**
     * ꤵ줿ǥåͤѹޤ
     *
     * @param  index ǥå
     * @param  c     
     */
    public void replace(int index, char c) {
        if (index >= length) {
            throw new IndexOutOfBoundsException(index + " >= " + length);
        }

        buffer[index] = c;
    }

    /**
     * ꤵ줿ǥå֤ͤޤ
     *
     * @param  index ǥå
     *
     * @return 
     */
    public char get(int index) {
        if (index >= length) {
            throw new IndexOutOfBoundsException(index + " >= " + length);
        }

        return buffer[index];
    }

    /**
     * ХåեΤΤ֤ޤ
     * ХåեͭϰϤϡ{@link #length()} ᥽åɤͤޤǤǤ
     * ΥХåեϡCharBuffer Ѥ줤Хåեľܤ
     * 󥹥󥹤ʤΤǡ{@link #replace(int, char)} ᥽åɤθƤӽФˤ
     * ѹ줿ꡢХåեγĥˤͭǤϤʤʤäꤹΤ
     * դɬפǤ
     *
     * @return ǼƤĿ
     */
    public char[] getChars() {
        return buffer;
    }

    /**
     * ΥХåե˳ǼƤ char θĿ֤ޤ
     *
     * @return ǼƤĿ
     */
    public int length() {
        return length;
    }

    /**
     * Хåեˤޤ
     */
    public void clear() {
        length = 0;
    }
}
