/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token.table;

import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Reporter;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.AttributeConverter;
import net.hizlab.kagetaka.token.Value;

import java.awt.Color;

/**
 * TABLE °ɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public class TableAttribute extends Attribute {
    private String  attributeSummary     = null;
    private Value   attributeWidth       = null;
    private Integer attributeBorder      = null;
    private int     attributeAlign       = Value.NONE;
    private Value   attributeCellspacing = null;
    private Value   attributeCellpadding = null;
    private Integer attributeHspace      = null;
    private Integer attributeVspace      = null;
    private Color   attributeBgcolor     = null;

    /**
     * TABLE °ǥեͤǺޤ
     *
     * @param  content  ƥ
     * @param  line     ֹ (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  column    (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  reporter 顼ݡ
     */
    protected TableAttribute(Content content, int line, int column, Reporter reporter) {
        super(content, line, column, reporter);
    }

    /** {@inheritDoc} */
    public boolean setAttribute(String key, String value)
            throws IllegalArgumentException {
        if ("summary"    .compareTo(key) == 0) { attributeSummary     = value; return true; }
        if ("width"      .compareTo(key) == 0) { attributeWidth       = AttributeConverter.convertToPercent(value); return true; }
        if ("border"     .compareTo(key) == 0) { attributeBorder      = AttributeConverter.convertToInteger(value); return true; }
        if ("align"      .compareTo(key) == 0) { attributeAlign       = AttributeConverter.convertToAlign  (value); return true; }
        if ("cellspacing".compareTo(key) == 0) { attributeCellspacing = AttributeConverter.convertToPercent(value); return true; }
        if ("cellpadding".compareTo(key) == 0) { attributeCellpadding = AttributeConverter.convertToPercent(value); return true; }
        if ("hspace"     .compareTo(key) == 0) { attributeHspace      = AttributeConverter.convertToInteger(value); return true; }
        if ("vspace"     .compareTo(key) == 0) { attributeVspace      = AttributeConverter.convertToInteger(value); return true; }
        if ("bgcolor"    .compareTo(key) == 0) { attributeBgcolor     = AttributeConverter.convertToColor  (value); return true; }

        return setBaseAttribute(key, value);
    }

//### Original Method

    /**
     * ֤ޤ
     *
     * @return ꤵƤʤ <code>null</code>
     */
    public Value getWidth() {
        return attributeWidth;
    }

    /**
     * ܡ֤ޤ
     *
     * @return ܡꤵƤʤ <code>null</code>
     */
    public Integer getBorder() {
        return attributeBorder;
    }

    /**
     * ֤֤ޤ
     *
     * @return 
     */
    public int getAlign() {
        return attributeAlign;
    }

    /**
     * ֤;֤ޤ
     *
     * @return ֤;ꤵƤʤ <code>null</code>
     */
    public Value getCellspacing() {
        return attributeCellspacing;
    }

    /**
     * ;֤ޤ
     *
     * @return ;ꤵƤʤ <code>null</code>
     */
    public Value getCellpadding() {
        return attributeCellpadding;
    }

    /**
     * ơ֥β;֤ޤ
     *
     * @return ơ֥β;ꤵƤʤ <code>null</code>
     */
    public Integer getHspace() {
        return attributeHspace;
    }

    /**
     * ơ֥ν;֤ޤ
     *
     * @return ơ֥ν;ꤵƤʤ <code>null</code>
     */
    public Integer getVspace() {
        return attributeVspace;
    }

    /**
     * طʿ֤ޤ
     *
     * @return طʿꤵƤʤ <code>null</code>
     */
    public Color getBgcolor() {
        return attributeBgcolor;
    }
}
