/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token.frame;

import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Reporter;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.AttributeConverter;
import net.hizlab.kagetaka.token.Value;

/**
 * FRAME °ɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public class FrameAttribute extends Attribute {
    private String  attributeName         = null;
    private String  attributeSrc          = null;
    private boolean attributeNoresize     = false;
    private int     attributeScrolling    = Value.SCROLLING_AUTO;
    private int     attributeFrameborder  = 1;
    private Integer attributeMarginwidth  = null;
    private Integer attributeMarginheight = null;

    /**
     * FRAME °ǥեͤǺޤ
     *
     * @param  content  ƥ
     * @param  line     ֹ (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  column    (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  reporter 顼ݡ
     */
    protected FrameAttribute(Content content, int line, int column, Reporter reporter) {
        super(content, line, column, reporter);
    }

    /** {@inheritDoc} */
    public boolean setAttribute(String key, String value)
            throws IllegalArgumentException {
        if ("name"        .compareTo(key) == 0) { attributeName         = value; return true; }
        if ("src"         .compareTo(key) == 0) { attributeSrc          = value; return true; }
        if ("noresize"    .compareTo(key) == 0) { attributeNoresize     = (value.toLowerCase().compareTo("noresize") == 0); return true; }
        if ("scrolling"   .compareTo(key) == 0) { attributeScrolling    = convertToScrolling  (value); return true; }
        if ("frameborder" .compareTo(key) == 0) { attributeFrameborder  = convertToFrameborder(value); return true; }
        if ("marginwidth" .compareTo(key) == 0) { attributeMarginwidth  = AttributeConverter.convertToInteger(value); return true; }
        if ("marginheight".compareTo(key) == 0) { attributeMarginheight = AttributeConverter.convertToInteger(value); return true; }

        return setBaseAttribute(key, value);
    }

//### Original Method
    /**
     * NAME ֤ͤޤ
     *
     * @return NAMEꤵƤʤ <code>null</code>
     */
    public String getName() {
        return attributeName;
    }

    /**
     * SRC ֤ͤޤ
     *
     * @return SRCꤵƤʤ <code>null</code>
     */
    public String getSrc() {
        return attributeSrc;
    }

    /**
     * NORESIZE ֤ͤޤ
     *
     * @return NORESIZEꤵƤʤ <code>false</code>
     */
    public boolean getNoresize() {
        return attributeNoresize;
    }

    /**
     * SCROLLING ֤ͤޤ
     *
     * @return SCROLLINGꤵƤʤ {@link Value#SCROLLING_AUTO}
     */
    public int getScrolling() {
        return attributeScrolling;
    }

    /**
     * FRAMEBORDER ֤ͤޤ
     *
     * @return FRAMEBORDERꤵƤʤ <code>1</code>
     */
    public int getFrameborder() {
        return attributeFrameborder;
    }

    /**
     * MARGINWIDTH ֤ͤޤ
     *
     * @return MARGINWIDTHꤵƤʤ <code>null</code>
     */
    public Integer getMarginwidth() {
        return attributeMarginwidth;
    }

    /**
     * MARGINHEIGHT ֤ͤޤ
     *
     * @return MARGINHEIGHTꤵƤʤ <code>null</code>
     */
    public Integer getMarginheight() {
        return attributeMarginheight;
    }

//### private
    /** Сɽ⡼ɤ֤ */
    private int convertToScrolling(String value)
            throws IllegalArgumentException {
        value = value.toLowerCase();
        if (value.compareTo("yes" ) == 0) { return Value.SCROLLING_YES ; }
        if (value.compareTo("auto") == 0) { return Value.SCROLLING_AUTO; }
        if (value.compareTo("no"  ) == 0) { return Value.SCROLLING_NO  ; }

        throw new IllegalArgumentException();
    }

    /** ڤȤɽ⡼ɤ֤ */
    private int convertToFrameborder(String value)
            throws IllegalArgumentException {
        value = value.toLowerCase();

        //### TODO value  1 or 0 Υå

        if (value.startsWith("1")) { return 1; }
        return 0;
    }
}
