/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token.form;

import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Reporter;
import net.hizlab.kagetaka.token.Attribute;

/**
 * OPTION °ɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public class OptionAttribute extends Attribute {
    private boolean attributeSelected  = false;      // Ѥ
    private String  attributeValue     = null;       // 
    private String  attributeLabel     = null;       // ٥
    private boolean attributeDisabled  = false;      // ̵

    /**
     * OPTION °ǥեͤǺޤ
     *
     * @param  content  ƥ
     * @param  line     ֹ (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  column    (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  reporter 顼ݡ
     */
    protected OptionAttribute(Content content, int line, int column, Reporter reporter) {
        super(content, line, column, reporter);
    }

    /** {@inheritDoc} */
    public boolean setAttribute(String key, String value)
            throws IllegalArgumentException {
        if ("selected" .compareTo(key) == 0) { attributeSelected  = (value.toLowerCase().compareTo(key) == 0 ); return true; }
        if ("value"    .compareTo(key) == 0) { attributeValue     = value; return true; }
        if ("label"    .compareTo(key) == 0) { attributeLabel     = value; return true; }
        if ("disabled" .compareTo(key) == 0) { attributeDisabled  = (value.toLowerCase().compareTo(key) == 0 ); return true; }

        return setBaseAttribute(key, value);
    }

//### Original Method
    /**
     * Ѥߤ֤ޤ
     *
     * @return SELECTEDꤵƤʤ <code>false</code>
     */
    public boolean getSelected() {
        return attributeSelected;
    }

    /**
     * ֤ͤޤ
     *
     * @return VALUEꤵƤʤ <code>null</code>
     */
    public String getValue() {
        return attributeValue;
    }

    /**
     * ٥֤ޤ
     *
     * @return LABELꤵƤʤ <code>null</code>
     */
    public String getLabel() {
        return attributeLabel;
    }

    /**
     * ̵֤ޤ
     *
     * @return DISABLEDꤵƤʤ <code>false</code>
     */
    public boolean getDisabled() {
        return attributeDisabled;
    }
}
