/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token.form;

import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Reporter;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.AttributeConverter;
import net.hizlab.kagetaka.token.Value;

/**
 * INPUT °ɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public class InputAttribute extends Attribute {
    private String  attributeType      = null;       // 
    private String  attributeName      = null;       // ̾
    private String  attributeValue     = null;       // 
    private boolean attributeChecked   = false;      // å
    private boolean attributeDisabled  = false;      // ̵
    private boolean attributeReadonly  = false;      // ɤ߹
    private Integer attributeSize      = null;       // 
    private Integer attributeMaxlength = null;       // 祵
    private String  attributeSrc       = null;       // 
    private String  attributeAlt       = null;       // ʸ
    private Integer attributeTabindex  = null;       // ֥ǥå
    private String  attributeAccesskey = null;       // 
    private String  attributeAccept    = null;       // MIME 
    private int     attributeAlign     = Value.NONE; // ·

    /**
     * INPUT °ǥեͤǺޤ
     *
     * @param  content  ƥ
     * @param  line     ֹ (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  column    (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  reporter 顼ݡ
     */
    protected InputAttribute(Content content, int line, int column, Reporter reporter) {
        super(content, line, column, reporter);
    }

    /** {@inheritDoc} */
    public boolean setAttribute(String key, String value)
            throws IllegalArgumentException {
        if ("type"     .compareTo(key) == 0) { attributeType      = value; return true; }
        if ("name"     .compareTo(key) == 0) { attributeName      = value; return true; }
        if ("value"    .compareTo(key) == 0) { attributeValue     = value; return true; }
        if ("checked"  .compareTo(key) == 0) { attributeChecked   = (value.toLowerCase().compareTo(key) == 0 ); return true; }
        if ("disabled" .compareTo(key) == 0) { attributeDisabled  = (value.toLowerCase().compareTo(key) == 0 ); return true; }
        if ("readonly" .compareTo(key) == 0) { attributeReadonly  = (value.toLowerCase().compareTo(key) == 0 ); return true; }
        if ("size"     .compareTo(key) == 0) { attributeSize      = AttributeConverter.convertToInteger(value); return true; }
        if ("maxlength".compareTo(key) == 0) { attributeMaxlength = AttributeConverter.convertToInteger(value); return true; }
        if ("src"      .compareTo(key) == 0) { attributeSrc       = value; return true; }
        if ("alt"      .compareTo(key) == 0) { attributeAlt       = value; return true; }
        if ("tabindex" .compareTo(key) == 0) { attributeTabindex  = AttributeConverter.convertToInteger(value); return true; }
        if ("accesskey".compareTo(key) == 0) { attributeAccesskey = value; return true; }
        if ("accept"   .compareTo(key) == 0) { attributeAccept    = value; return true; }
        if ("align"    .compareTo(key) == 0) { attributeAlign     = AttributeConverter.convertToAlign  (value); return true; }

        return setBaseAttribute(key, value);
    }

//### Original Method
    /**
     * פ֤ޤ
     *
     * @return TYPEꤵƤʤ <code>null</code>
     */
    public String getType() {
        return attributeType;
    }

    /**
     * ֤̾ޤ
     *
     * @return NAMEꤵƤʤ <code>null</code>
     */
    public String getName() {
        return attributeName;
    }

    /**
     * ֤ͤޤ
     *
     * @return VALUEꤵƤʤ <code>null</code>
     */
    public String getValue() {
        return attributeValue;
    }

    /**
     * åѤߤ֤ޤ
     *
     * @return CHECKEDꤵƤʤ <code>false</code>
     */
    public boolean getChecked() {
        return attributeChecked;
    }

    /**
     * ̵֤ޤ
     *
     * @return DISABLEDꤵƤʤ <code>false</code>
     */
    public boolean getDisabled() {
        return attributeDisabled;
    }

    /**
     * ɤ߹Ѥ֤ޤ
     *
     * @return READONLYꤵƤʤ <code>false</code>
     */
    public boolean getReadonly() {
        return attributeReadonly;
    }

    /**
     * ֤ޤ
     *
     * @return SIZEꤵƤʤ <code>null</code>
     */
    public Integer getSize() {
        return attributeSize;
    }

    /**
     * 祵֤ޤ
     *
     * @return MAXLENGTHꤵƤʤ <code>null</code>
     */
    public Integer getMaxlength() {
        return attributeMaxlength;
    }

    /**
     * ֤ޤ
     *
     * @return SRCꤵƤʤ <code>null</code>
     */
    public String getSrc() {
        return attributeSrc;
    }

    /**
     * ʸ֤ޤ
     *
     * @return ALTꤵƤʤ <code>null</code>
     */
    public String getAlt() {
        return attributeAlt;
    }

    /**
     * ֥ǥå֤ޤ
     *
     * @return TABINDEXꤵƤʤ <code>null</code>
     */
    public Integer getTabindex() {
        return attributeTabindex;
    }

    /**
     * ֤ޤ
     *
     * @return ACCESSKEYꤵƤʤ <code>null</code>
     */
    public String getAccesskey() {
        return attributeAccesskey;
    }

    /**
     * դ MIME פ֤ޤ
     *
     * @return ACCEPTꤵƤʤ <code>null</code>
     */
    public String getAccept() {
        return attributeAccept;
    }

    /**
     * ·֤ޤ
     *
     * @return ALIGNꤵƤʤ <code>null</code>
     */
    public int getAlign() {
        return attributeAlign;
    }
}
