/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token.form;

import net.hizlab.kagetaka.addin.FormManager;
import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.FormItem;
import net.hizlab.kagetaka.rendering.Render;
import net.hizlab.kagetaka.rendering.Reporter;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.EndToken;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.Token;
import net.hizlab.kagetaka.token.TokenTypes;
import net.hizlab.kagetaka.token.Value;

/**
 * եϤΥȡγϤɽ륹ѡ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.5 $
 */
public class FormStartToken extends StartToken {
    /**
     * եϤΥȡγϤޤ
     *
     * @param  content  ƥ
     * @param  line     ֹ (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  column    (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  reporter 顼ݡ
     * @param  type     ȡγϤɽ
     * @param  complete 䴰ƺ줿 <code>true</code>
     *                  ʳξ <code>false</code>
     */
    public FormStartToken(Content content, int line, int column, Reporter reporter, int type, boolean complete) {
        super(content, line, column, reporter, type, complete);
    }

    /** {@inheritDoc} */
    protected boolean setAttributeImple(String key, String value)
            throws IllegalArgumentException {
        if (attribute == null) {
            switch (type) {
            case TokenTypes.FORM_START    : attribute = new FormAttribute    (content, lineNumber, columnNumber, reporter); break;
            case TokenTypes.INPUT         : attribute = new InputAttribute   (content, lineNumber, columnNumber, reporter); break;
            case TokenTypes.SELECT_START  : attribute = new SelectAttribute  (content, lineNumber, columnNumber, reporter); break;
            case TokenTypes.OPTGROUP_START: return true; // ߡ
            case TokenTypes.OPTION_START  : attribute = new OptionAttribute  (content, lineNumber, columnNumber, reporter); break;
            case TokenTypes.TEXTAREA_START: attribute = new TextareaAttribute(content, lineNumber, columnNumber, reporter); break;
            case TokenTypes.BUTTON_START  : return true; // ߡ
            case TokenTypes.FIELDSET_START: return true; // ߡ
            case TokenTypes.LEGEND_START  : return true; // ߡ
            case TokenTypes.LABEL_START   : return true; // ߡ
            default                       : attribute = new Attribute        (content, lineNumber, columnNumber, reporter); break;
            }
        }

        return attribute.setAttribute(key, value);
    }

    /** {@inheritDoc} */
    protected StartToken getDefaultParentTokenImple() {
        int tokenType = TokenTypes.UNKNOWN;

        switch (type) {
        case TokenTypes.FORM_START      : tokenType = TokenTypes.X_BLOCK_START; break;
        case TokenTypes.INPUT           : tokenType = TokenTypes.X_BLOCK_START; break;
        case TokenTypes.SELECT_START    : tokenType = TokenTypes.X_BLOCK_START; break;
        case TokenTypes.OPTGROUP_START  : tokenType = TokenTypes.X_BLOCK_START; break;
        case TokenTypes.OPTION_START    : tokenType = TokenTypes.X_BLOCK_START; break;
        case TokenTypes.TEXTAREA_START  : tokenType = TokenTypes.X_BLOCK_START; break;
        case TokenTypes.BUTTON_START    : tokenType = TokenTypes.X_BLOCK_START; break;
        case TokenTypes.FIELDSET_START  : tokenType = TokenTypes.X_BLOCK_START; break;
        case TokenTypes.LEGEND_START    : tokenType = TokenTypes.X_BLOCK_START; break;
        case TokenTypes.LABEL_START     : tokenType = TokenTypes.X_BLOCK_START; break;
        default:
            return null;
        }

        return new StartToken(content, lineNumber, columnNumber, reporter, tokenType, true);
    }

    /** {@inheritDoc} */
    protected EndToken getEndTokenImpl(Token current) {
        if (current == null) {
            return new FormEndToken(content, 0, 0, reporter, getType() + 1, true);
        }

        return new FormEndToken(content, current.getLineNumber(), current.getColumnNumber(), reporter, getType() + 1, true);
    }

    /** {@inheritDoc} */
    protected boolean isContentsImple(int childToken) {
        switch (type) {
        case TokenTypes.FORM_START  :
        case TokenTypes.LABEL_START :
            return isContentsParent(childToken);
        case TokenTypes.SELECT_START:
            return (childToken == TokenTypes.OPTGROUP_START
                 || childToken == TokenTypes.OPTION_START);
        case TokenTypes.OPTGROUP_START:
            return (childToken == TokenTypes.OPTION_START);
        case TokenTypes.OPTION_START:
            return true;                    // Ǥ⤤̵뤹
        case TokenTypes.FIELDSET_START:
            return (TokenTypes.isBlock (childToken)
                 || TokenTypes.isInline(childToken)
                 || childToken == TokenTypes.LEGEND_START );
        default: // AVOID
        }

        return false;
    }

    /** {@inheritDoc} */
    protected void includeTokenImple(Token token) {
        // ʬեξϡƤΤ
        if (type == TokenTypes.FORM_START) {
            includeTokenParent(token);
        }
    }

    /** {@inheritDoc} */
    protected void renderImple(Render render) {
        FormManager fm   = render.getFormManager();
        FormItem    item = null;

        switch (type) {
        case TokenTypes.FORM_START      :
            fm.beginForm(this);
            break;
        case TokenTypes.INPUT           :
            {
                Status status = render.getStatus();
                InputAttribute attr = (InputAttribute) getAttribute();
                if (attr != null) {
                    String type = attr.getType();
                    if (type != null) {
                        type = type.toLowerCase();
                    }
                    if (/*---*/type == null
                            || type.compareTo("text"    ) == 0
                            || type.compareTo("password") == 0) {
                        status.setFontFamily(new Value[]{new Value(Value.FONT_MONOSPACE)});
                    }
                }

                if ((item = fm.addFormItem(this, status)) != null) {
                    render.drawForm(item);
                }
                break;
            }
        case TokenTypes.SELECT_START    :
            fm.beginSelect(this, render.getStatus());
            break;
        case TokenTypes.OPTGROUP_START  : break;
        case TokenTypes.OPTION_START    :
            fm.addOption(this);
            break;
        case TokenTypes.TEXTAREA_START  :
            {
                Status status = render.getStatus();
                status.setFontFamily(new Value[]{new Value(Value.FONT_MONOSPACE)});
                if ((item = fm.addTextarea(this, status)) != null) {
                    render.drawForm(item);
                }
                break;
            }
        case TokenTypes.BUTTON_START    : break;
        case TokenTypes.FIELDSET_START  : break;
        case TokenTypes.LEGEND_START    : break;
        case TokenTypes.LABEL_START     : break;
        default: // AVOID
        }
    }
}
