/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token;

import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.util.Environment;

import java.awt.Color;
import java.text.DecimalFormat;

/**
 * CSS 礭ɽץѥƥͤǼ륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.7 $
 */
public class Value {
    /** 1in  cm1in  2.54cm  */
    private static final double CM_P_IN = 2.54;
    /** 1in  pt1pt  1/72in  */
    private static final double PT_P_IN = 72;
    /** 1in  pc1pc  12pt  */
    private static final double PC_P_IN = 6;

    /** Υǡ         */ public static final int DATA_HORIZONTAL = 1;
    /** Υǡ         */ public static final int DATA_VERTICAL   = 2;
    /** ˰̣ʤǡ */ public static final int DATA_NONE       = 0;

    /** ñ̤ʤ   */ public static final int UNIT_NONE     =  0;
    /** ñ̡em */ public static final int UNIT_EM       =  1;
    /** ñ̡ex */ public static final int UNIT_EX       =  2;
    /** ñ̡px */ public static final int UNIT_PX       =  3;
    /** ñ̡in */ public static final int UNIT_IN       =  4;
    /** ñ̡cm */ public static final int UNIT_CM       =  5;
    /** ñ̡mm */ public static final int UNIT_MM       =  6;
    /** ñ̡pt */ public static final int UNIT_PT       =  7;
    /** ñ̡pc */ public static final int UNIT_PC       =  8;
    /** ñ̡%  */ public static final int UNIT_PERCENT  =  9;
    /** ñ̡*  */ public static final int UNIT_ASTERISK =  99;

    /**        */ public static final int TYPE_INTEGER    =  -1;
    /** Ĺ       */ public static final int TYPE_LENGTH     =  -2;
    /** ѡ */ public static final int TYPE_PERCENTAGE =  -3;
    /** ʸ     */ public static final int TYPE_STRING     =  -4;
    /**          */ public static final int TYPE_COLOR      =  -5;
    /** URL        */ public static final int TYPE_URL        =  -6;

    /** inherit              */ public static final int TYPE_KEY_INHERIT              =   1;
    /** normal               */ public static final int TYPE_KEY_NORMAL               =   2;
    /** none                 */ public static final int TYPE_KEY_NONE                 =   3;
    /** hidden               */ public static final int TYPE_KEY_HIDDEN               =  11;
    /** dotted               */ public static final int TYPE_KEY_DOTTED               =  12;
    /** dashed               */ public static final int TYPE_KEY_DASHED               =  13;
    /** solid                */ public static final int TYPE_KEY_SOLID                =  14;
    /** double               */ public static final int TYPE_KEY_DOUBLE               =  15;
    /** groove               */ public static final int TYPE_KEY_GROOVE               =  16;
    /** ridge                */ public static final int TYPE_KEY_RIDGE                =  17;
    /** inset                */ public static final int TYPE_KEY_INSET                =  18;
    /** outset               */ public static final int TYPE_KEY_OUTSET               =  19;
    /** thin                 */ public static final int TYPE_KEY_THIN                 =  21;
    /** medium               */ public static final int TYPE_KEY_MEDIUM               =  22;
    /** thick                */ public static final int TYPE_KEY_THICK                =  23;
    /** left                 */ public static final int TYPE_KEY_LEFT                 =  31;
    /** right                */ public static final int TYPE_KEY_RIGHT                =  32;
    /** center               */ public static final int TYPE_KEY_CENTER               =  33;
    /** justify              */ public static final int TYPE_KEY_JUSTIFY              =  34;
    /** both                 */ public static final int TYPE_KEY_BOTH                 =  35;
    /** baseline             */ public static final int TYPE_KEY_BASELINE             =  41;
    /** sub                  */ public static final int TYPE_KEY_SUB                  =  42;
    /** super                */ public static final int TYPE_KEY_SUPER                =  43;
    /** top                  */ public static final int TYPE_KEY_TOP                  =  44;
    /** text-top             */ public static final int TYPE_KEY_TEXT_TOP             =  45;
    /** middle               */ public static final int TYPE_KEY_MIDDLE               =  46;
    /** bottom               */ public static final int TYPE_KEY_BOTTOM               =  47;
    /** text-bottom          */ public static final int TYPE_KEY_TEXT_BOTTOM          =  48;
    /** pre                  */ public static final int TYPE_KEY_PRE                  =  51;
    /** nowrap               */ public static final int TYPE_KEY_NOWRAP               =  52;
    /** xx-small             */ public static final int TYPE_KEY_XX_SMALL             =  61;
    /** x-small              */ public static final int TYPE_KEY_X_SMALL              =  62;
    /** small                */ public static final int TYPE_KEY_SMALL                =  63;
    /** large                */ public static final int TYPE_KEY_LARGE                =  65;
    /** x-large              */ public static final int TYPE_KEY_X_LARGE              =  66;
    /** xx-large             */ public static final int TYPE_KEY_XX_LARGE             =  67;
    /** smaller              */ public static final int TYPE_KEY_SMALLER              =  68;
    /** larger               */ public static final int TYPE_KEY_LARGER               =  69;
    /** serif                */ public static final int TYPE_KEY_SERIF                =  71;
    /** sans-serif           */ public static final int TYPE_KEY_SANS_SERIF           =  72;
    /** cursive              */ public static final int TYPE_KEY_CURSIVE              =  73;
    /** fantasy              */ public static final int TYPE_KEY_FANTASY              =  74;
    /** monospace            */ public static final int TYPE_KEY_MONOSPACE            =  75;
    /** oblique              */ public static final int TYPE_KEY_OBLIQUE              =  81;
    /** italic               */ public static final int TYPE_KEY_ITALIC               =  82;
    /** bold                 */ public static final int TYPE_KEY_BOLD                 =  85;
    /** bolder               */ public static final int TYPE_KEY_BOLDER               =  86;
    /** lighter              */ public static final int TYPE_KEY_LIGHTER              =  87;
    /** disc                 */ public static final int TYPE_KEY_DISC                 =  91;
    /** circle               */ public static final int TYPE_KEY_CIRCLE               =  92;
    /** square               */ public static final int TYPE_KEY_SQUARE               =  93;
    /** decimal              */ public static final int TYPE_KEY_DECIMAL              =  94;
    /** decimal-leading-zero */ public static final int TYPE_KEY_DECIMAL_LEADING_ZERO =  95;
    /** lower-roman          */ public static final int TYPE_KEY_LOWER_ROMAN          =  96;
    /** upper-roman          */ public static final int TYPE_KEY_UPPER_ROMAN          =  97;
    /** hebrew               */ public static final int TYPE_KEY_HEBREW               =  98;
    /** georgian             */ public static final int TYPE_KEY_GEORGIAN             =  99;
    /** armenian             */ public static final int TYPE_KEY_ARMENIAN             = 100;
    /** cjk-ideographic      */ public static final int TYPE_KEY_CJK_IDEOGRAPHIC      = 101;
    /** hiragana             */ public static final int TYPE_KEY_HIRAGANA             = 102;
    /** katakana             */ public static final int TYPE_KEY_KATAKANA             = 103;
    /** hiragana-iroha       */ public static final int TYPE_KEY_HIRAGANA_IROHA       = 104;
    /** katakana-iroha       */ public static final int TYPE_KEY_KATAKANA_IROHA       = 105;
    /** lower-latin          */ public static final int TYPE_KEY_LOWER_LATIN          = 106;
    /** upper-latin          */ public static final int TYPE_KEY_UPPER_LATIN          = 107;
    /** lower-alpha          */ public static final int TYPE_KEY_LOWER_ALPHA          = 108;
    /** upper-alpha          */ public static final int TYPE_KEY_UPPER_ALPHA          = 109;
    /** lower-greek          */ public static final int TYPE_KEY_LOWER_GREEK          = 110;
    /** inside               */ public static final int TYPE_KEY_INSIDE               = 121;
    /** outside              */ public static final int TYPE_KEY_OUTSIDE              = 122;
    /** yes                  */ public static final int TYPE_KEY_YES                  = 131;
    /** auto                 */ public static final int TYPE_KEY_AUTO                 = 132;
    /** no                   */ public static final int TYPE_KEY_NO                   = 133;
    /** inline               */ public static final int TYPE_KEY_INLINE               = 141;
    /** block                */ public static final int TYPE_KEY_BLOCK                = 142;
    /** list-item            */ public static final int TYPE_KEY_LIST_ITEM            = 143;
    /** run-in               */ public static final int TYPE_KEY_RUN_IN               = 144;
    /** compact              */ public static final int TYPE_KEY_COMPACT              = 145;
    /** marker               */ public static final int TYPE_KEY_MARKER               = 146;
    /** table                */ public static final int TYPE_KEY_TABLE                = 147;
    /** inline-table         */ public static final int TYPE_KEY_INLINE_TABLE         = 148;
    /** table-row-group      */ public static final int TYPE_KEY_TABLE_ROW_GROUP      = 149;
    /** table-header-group   */ public static final int TYPE_KEY_TABLE_HEADER_GROUP   = 150;
    /** table-footer-group   */ public static final int TYPE_KEY_TABLE_FOOTER_GROUP   = 151;
    /** table-row            */ public static final int TYPE_KEY_TABLE_ROW            = 152;
    /** table-column-group   */ public static final int TYPE_KEY_TABLE_COLUMN_GROUP   = 153;
    /** table-column         */ public static final int TYPE_KEY_TABLE_COLUMN         = 154;
    /** table-cell           */ public static final int TYPE_KEY_TABLE_CELL           = 155;
    /** table-caption        */ public static final int TYPE_KEY_TABLE_CAPTION        = 156;
    /** repeat               */ public static final int TYPE_KEY_REPEAT               = 161;
    /** repeat-x             */ public static final int TYPE_KEY_REPEAT_X             = 162;
    /** repeat-y             */ public static final int TYPE_KEY_REPEAT_Y             = 163;
    /** no-repeat            */ public static final int TYPE_KEY_NO_REPEAT            = 164;
    /** scroll               */ public static final int TYPE_KEY_SCROLL               = 166;
    /** fixed                */ public static final int TYPE_KEY_FIXED                = 167;
    /** underline            */ public static final int TYPE_KEY_UNDERLINE            =  0x001000;
    /** overline             */ public static final int TYPE_KEY_OVERLINE             =  0x002000;
    /** line-through         */ public static final int TYPE_KEY_LINE_THROUGH         =  0x004000;
    /** blink                */ public static final int TYPE_KEY_BLINK                =  0x008000;
    /** transparent          */ public static final int TYPE_KEY_TRANSPARENT          =  901;

    /** ƤƱ */ public static final int INHERIT = TYPE_KEY_INHERIT;
    /** ̵   */ public static final int NONE    = TYPE_KEY_NONE   ;

    /** ܡ̵             */ public static final int BORDER_NONE        = TYPE_KEY_NONE        ;
    /** ܡɽ           */ public static final int BORDER_HIDDEN      = TYPE_KEY_HIDDEN      ;
    /** ܡ             */ public static final int BORDER_DOTTED      = TYPE_KEY_DOTTED      ;
    /** ܡ             */ public static final int BORDER_DASHED      = TYPE_KEY_DASHED      ;
    /** ܡ             */ public static final int BORDER_SOLID       = TYPE_KEY_SOLID       ;
    /** ܡ           */ public static final int BORDER_DOUBLE      = TYPE_KEY_DOUBLE      ;
    /** ܡХ */ public static final int BORDER_GROOVE      = TYPE_KEY_GROOVE      ;
    /** ܡХδ */ public static final int BORDER_RIDGE       = TYPE_KEY_RIDGE       ;
    /** ܡ¦       */ public static final int BORDER_INSET       = TYPE_KEY_INSET       ;
    /** ܡ¦δ       */ public static final int BORDER_OUTSET      = TYPE_KEY_OUTSET      ;

    /** եȡserif            */ public static final int FONT_SERIF         = TYPE_KEY_SERIF       ;
    /** եȡsansserif        */ public static final int FONT_SANS_SERIF    = TYPE_KEY_SANS_SERIF  ;
    /** եȡcursive          */ public static final int FONT_CURSIVE       = TYPE_KEY_CURSIVE     ;
    /** եȡfantasy          */ public static final int FONT_FANTASY       = TYPE_KEY_FANTASY     ;
    /** եȡmonospace        */ public static final int FONT_MONOSPACE     = TYPE_KEY_MONOSPACE   ;

    /** ʸ             */ public static final int TD_UNDERLINE       = TYPE_KEY_UNDERLINE   ;
    /** ʸ             */ public static final int TD_OVERLINE        = TYPE_KEY_OVERLINE    ;
    /** ʸǤä       */ public static final int TD_STRIKE          = TYPE_KEY_LINE_THROUGH;
    /** ʸǤä       */ public static final int TD_BLINK           = TYPE_KEY_BLINK       ;

    /** ·                 */ public static final int ALIGN_LEFT         = TYPE_KEY_LEFT        ;
    /** ·               */ public static final int ALIGN_CENTER       = TYPE_KEY_CENTER      ;
    /** ·                 */ public static final int ALIGN_RIGHT        = TYPE_KEY_RIGHT       ;
    /** ·ξü·           */ public static final int ALIGN_JUSTIFY      = TYPE_KEY_JUSTIFY     ;
    /** ·CAPTION      */ public static final int ALIGN_TOP          = TYPE_KEY_TOP         ;
    /** ·CAPTION      */ public static final int ALIGN_BOTTOM       = TYPE_KEY_BOTTOM      ;

    /** ·١饤       */ public static final int VALIGN_BASELINE    = TYPE_KEY_BASELINE    ;
    /** ·դʸ         */ public static final int VALIGN_SUB         = TYPE_KEY_SUB         ;
    /** ·դʸ         */ public static final int VALIGN_SUPER       = TYPE_KEY_SUPER       ;
    /** ··           */ public static final int VALIGN_TOP         = TYPE_KEY_TOP         ;
    /** ·եȾ·   */ public static final int VALIGN_TEXT_TOP    = TYPE_KEY_TEXT_TOP    ;
    /** ·               */ public static final int VALIGN_MIDDLE      = TYPE_KEY_MIDDLE      ;
    /** ··           */ public static final int VALIGN_BOTTOM      = TYPE_KEY_BOTTOM      ;
    /** ·եȲ·   */ public static final int VALIGN_TEXT_BOTTOM = TYPE_KEY_TEXT_BOTTOM ;

    /**                  */ public static final int WHITESPACE_NORMAL  = TYPE_KEY_NORMAL      ;
    /** 򡦺ػ             */ public static final int WHITESPACE_PRE     = TYPE_KEY_PRE         ;
    /** 򡦵ͤ뤬̵     */ public static final int WHITESPACE_NOWRAP  = TYPE_KEY_NOWRAP      ;

    /** եȡ̵             */ public static final int FLOAT_NONE         = TYPE_KEY_NONE        ;
    /** եȡ           */ public static final int FLOAT_LEFT         = TYPE_KEY_LEFT        ;
    /** եȡ           */ public static final int FLOAT_RIGHT        = TYPE_KEY_RIGHT       ;

    /** ꥢ̵               */ public static final int CLEAR_NONE         = TYPE_KEY_NONE        ;
    /** ꥢ             */ public static final int CLEAR_LEFT         = TYPE_KEY_LEFT        ;
    /** ꥢ             */ public static final int CLEAR_RIGHT        = TYPE_KEY_RIGHT       ;
    /** ꥢξ¦               */ public static final int CLEAR_BOTH         = TYPE_KEY_BOTH        ;

    /** ꥹȡʤ                                                                    */ public static final int LIST_NONE                 = TYPE_KEY_NONE                ;
    /** ꥹȡ                                                                */ public static final int LIST_CUSTOM               = 911                          ;
    /** ̵ꥹȡǥե                                                      */ public static final int LIST_MIX                  = 912                          ;
    /** ̵ꥹȡ                                                            */ public static final int LIST_DISC                 = TYPE_KEY_DISC                ;
    /** ̵ꥹȡ                                                            */ public static final int LIST_CIRCLE               = TYPE_KEY_CIRCLE              ;
    /** դꥹȡͳ                                                            */ public static final int LIST_SQUARE               = TYPE_KEY_SQUARE              ;
    /** դꥹȡʿ 1  <code>1,2,3,4,5, ...</code>                     */ public static final int LIST_DECIMAL              = TYPE_KEY_DECIMAL             ;
    /** դꥹȡʿǾ̷˥ղ <code>01,02,03,04,05, ..., 99</code> */ public static final int LIST_DECIMAL_LEADING_ZERO = TYPE_KEY_DECIMAL_LEADING_ZERO;
    /** դꥹȡʸΥ޿ <code>i,ii,iii,iv,v, ...</code>              */ public static final int LIST_LOWER_ROMAN          = TYPE_KEY_LOWER_ROMAN         ;
    /** դꥹȡʸΥ޿ <code>I,II,III,IV,V, ...</code>              */ public static final int LIST_UPPER_ROMAN          = TYPE_KEY_UPPER_ROMAN         ;
    /** դꥹȡŪʥإ֥饤̤б                                  */ public static final int LIST_HEBREW               = TYPE_KEY_HEBREW              ;
    /** դꥹȡŪʥ른̤б <code>an,ban,gan, ...</code>     */ public static final int LIST_GEORGIAN             = TYPE_KEY_GEORGIAN            ;
    /** դꥹȡŪʥ˥̤б                                */ public static final int LIST_ARMENIAN             = TYPE_KEY_ARMENIAN            ;
    /** դꥹȡ <code>, , , ...</code>                             */ public static final int LIST_CJK_IDEOGRAPHIC      = TYPE_KEY_CJK_IDEOGRAPHIC     ;
    /** դꥹȡʿ̾ <code>,,,,, ...</code>                         */ public static final int LIST_HIRAGANA             = TYPE_KEY_HIRAGANA            ;
    /** դꥹȡҲ̾ <code>,,,,, ...</code>                         */ public static final int LIST_KATAKANA             = TYPE_KEY_KATAKANA            ;
    /** դꥹȡʿ̾Τ <code>,,,, ...</code>                    */ public static final int LIST_HIRAGANA_IROHA       = TYPE_KEY_HIRAGANA_IROHA      ;
    /** դꥹȡҲ̾Τ <code>,,,, ...</code>                    */ public static final int LIST_KATAKANA_IROHA       = TYPE_KEY_KATAKANA_IROHA      ;
    /** դꥹȡʸΥ <code>a,b,c,d,e, ...</code>                    */ public static final int LIST_LOWER_LATIN          = TYPE_KEY_LOWER_LATIN         ;
    /** դꥹȡʸΥ <code>A,B,C,D,E, ...</code>                    */ public static final int LIST_UPPER_LATIN          = TYPE_KEY_UPPER_LATIN         ;
    /** դꥹȡʸΥ <code>a,b,c,d,e, ...</code>                    */ public static final int LIST_LOWER_ALPHA          = TYPE_KEY_LOWER_ALPHA         ;
    /** դꥹȡʸΥ <code>A,B,C,D,E, ...</code>                    */ public static final int LIST_UPPER_ALPHA          = TYPE_KEY_UPPER_ALPHA         ;
    /** դꥹȡʸθ奮ꥷʸ <code>&#941,&#942,&#943, ...</code>    */ public static final int LIST_LOWER_GREEK          = TYPE_KEY_LOWER_GREEK         ;

    /** Сɽ   */ public static final int SCROLLING_YES  = TYPE_KEY_YES ;
    /** Сư       */ public static final int SCROLLING_AUTO = TYPE_KEY_AUTO;
    /** Сɽ */ public static final int SCROLLING_NO   = TYPE_KEY_NO  ;

    /** ɽ饤               */ public static final int DISPLAY_INLINE             = TYPE_KEY_INLINE            ;
    /** ɽ֥å                 */ public static final int DISPLAY_BLOCK              = TYPE_KEY_BLOCK             ;
    /** ɽꥹȥƥ           */ public static final int DISPLAY_LIST_ITEM          = TYPE_KEY_LIST_ITEM         ;
    /** ɽ󥤥֥å         */ public static final int DISPLAY_RUN_IN             = TYPE_KEY_RUN_IN            ;
    /** ɽѥȥ֥å       */ public static final int DISPLAY_COMPACT            = TYPE_KEY_COMPACT           ;
    /** ɽޡ֥å         */ public static final int DISPLAY_MARKER             = TYPE_KEY_MARKER            ;
    /** ɽơ֥                 */ public static final int DISPLAY_TABLE              = TYPE_KEY_TABLE             ;
    /** ɽ饤ơ֥       */ public static final int DISPLAY_INLINE_TABLE       = TYPE_KEY_INLINE_TABLE      ;
    /** ɽơ֥ԥ롼       */ public static final int DISPLAY_TABLE_ROW_GROUP    = TYPE_KEY_TABLE_ROW_GROUP   ;
    /** ɽơ֥إå롼 */ public static final int DISPLAY_TABLE_HEADER_GROUP = TYPE_KEY_TABLE_HEADER_GROUP;
    /** ɽơ֥եå롼 */ public static final int DISPLAY_TABLE_FOOTER_GROUP = TYPE_KEY_TABLE_FOOTER_GROUP;
    /** ɽơ֥               */ public static final int DISPLAY_TABLE_ROW          = TYPE_KEY_TABLE_ROW         ;
    /** ɽơ֥󥰥롼       */ public static final int DISPLAY_TABLE_COLUMN_GROUP = TYPE_KEY_TABLE_COLUMN_GROUP;
    /** ɽơ֥               */ public static final int DISPLAY_TABLE_COLUMN       = TYPE_KEY_TABLE_COLUMN      ;
    /** ɽơ֥륻             */ public static final int DISPLAY_TABLE_CELL         = TYPE_KEY_TABLE_CELL        ;
    /** ɽơ֥륭ץ     */ public static final int DISPLAY_TABLE_CAPTION      = TYPE_KEY_TABLE_CAPTION     ;

    /** ¾Υǥ */
    public static final int MEDIA_0          = 0x000001;
    /** ԡ󥻥 */
    public static final int MEDIA_AURAL      = 0x000002;
    /** οեɥХåǥХ */
    public static final int MEDIA_BRAILLE    = 0x000004;
    /** ΥڡϤץ */
    public static final int MEDIA_EMBOSSED   = 0x000008;
    /** ݡ֥ǽǥХ */
    public static final int MEDIA_HANDHELD   = 0x000010;
    /** ڡդƩʪؤΰ䡢ץӥ塼⡼ɤβ */
    public static final int MEDIA_PRINT      = 0x000020;
    /** ̵ƩĤؤΰʤɡƤˤɽ */
    public static final int MEDIA_PROJECTION = 0x000040;
    /** ˥顼Υԥ塼 */
    public static final int MEDIA_SCREEN     = 0x000080;
    /** åζΰǼޤ롢ԥåʸѤ */
    public static final int MEDIA_TTY        = 0x000100;
    /** ƥӷΥǥХ */
    public static final int MEDIA_TV         = 0x000200;
    /** ٤ƤΥǥХ */
    public static final int MEDIA_ALL        = 0xFFFFFF;

    /**  */ protected int     type      = 0;
    /** פ */ protected boolean important = false;
    /**    */ protected Number  number    = null;
    /** ʸ */ protected String  string    = null;
    /**      */ protected Color   color     = null;
    /** URL    */ protected String  url       = null;
    /** ñ   */ protected int     unit      = UNIT_NONE;

    /**
     * Υץѥƥͤޤ
     * ɬեɤͤꤷʤФʤޤ
     */
    protected Value() {
    }

    /**
     * ɥפΥץѥƥͤޤ
     * ʸɽꤵʤΤǡ{@link #toString()} ᥽åɤǤϡ
     * פ֤ͤ褦ˤʤޤ
     *
     * @param  type   
     */
    public Value(int type) {
        this.type = type;
    }

    /**
     * ɥפΥץѥƥͤޤ
     *
     * @param  type   
     * @param  string ʸɽ
     */
    public Value(int type, String string) {
        this.type   = type;
        this.string = string;
    }

    /**
     * ͤ¿ͥפΥץѥƥͤޤ
     *
     * @param  value ͡{@link Long}  {@link Double} Υ󥹥󥹤Τߡ
     * @param  unit  ñ
     */
    public Value(Number value, int unit) {
        if (!(value instanceof Long || value instanceof Double)) {
            throw new IllegalArgumentException("invalid value type");
        }

        switch (unit) {
        case UNIT_NONE   : this.type = TYPE_INTEGER   ; break;
        case UNIT_PERCENT: this.type = TYPE_PERCENTAGE; break;
        default          : this.type = TYPE_LENGTH    ; break;
        }
        this.number = value;
        this.unit   = unit;
    }

    /**
     * ͤ¿ͥפΥץѥƥͤޤ
     *
     * @param  value 
     * @param  unit  ñ
     */
    public Value(long value, int unit) {
        switch (unit) {
        case UNIT_NONE   : this.type = TYPE_INTEGER   ; break;
        case UNIT_PERCENT: this.type = TYPE_PERCENTAGE; break;
        default          : this.type = TYPE_LENGTH    ; break;
        }
        this.number = new Long(value);
        this.unit   = unit;
    }

    /**
     * ͤ¿ͥפΥץѥƥͤޤ
     *
     * @param  value 
     * @param  unit  ñ
     */
    public Value(double value, int unit) {
        switch (unit) {
        case UNIT_NONE   : this.type = TYPE_INTEGER   ; break;
        case UNIT_PERCENT: this.type = TYPE_PERCENTAGE; break;
        default          : this.type = TYPE_LENGTH    ; break;
        }
        this.number = new Double(value);
        this.unit   = unit;
    }

    /**
     * ʸ󥿥פΥץѥƥͤޤ
     *
     * @param  value 
     */
    public Value(String value) {
        this.type   = TYPE_STRING;
        this.string = value;
    }

    /**
     * פΥץѥƥͤޤ
     *
     * @param  value 
     */
    public Value(Color value) {
        this.type  = TYPE_COLOR;
        this.color = value;
    }

    /**
     * URL פΥץѥƥͤޤ
     *
     * @param  value 
     * @param  flag  ե饰ͽ
     */
    public Value(String value, int flag) {
        this.type = TYPE_URL;
        this.url  = value;
    }

    /**
     * ɥפɤ֤ޤ
     *
     * @return ɥפξ <code>true</code>
     *         ʳξ <code>false</code>
     */
    public boolean isKeyword() {
        return (type > 0);
    }

    /**
     * ɥפξΥפ֤ޤ
     *
     * @return 
     */
    public int getType() {
        return type;
    }

    /**
     * ͤ¿ͥפξ֤ͤޤ
     * ⤷ǽǤ {@link Long} Υ󥹥󥹡
     * Ǥʤ {@link Double} Υ󥹥󥹤Ǥ
     * ɥפξ <code>null</code> ֤ޤ
     *
     * @return 
     */
    public Number getNumber() {
        return number;
    }

    /**
     * ͤ¿ͥפξǤС<code>int</code> ֤ͤޤ
     * ⤷ΥפǤϤʤϡ<code>0</code> ֤ޤ
     *
     * @return 
     */
    public int intValue() {
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    /**
     * ʸ󥿥פξ֤ͤޤ
     *
     * @return 
     */
    public String getString() {
        return string;
    }

    /**
     * פξ֤ͤޤ
     *
     * @return 
     */
    public Color getColor() {
        return color;
    }

    /**
     * URL פξ֤ͤޤ
     *
     * @return 
     */
    public String getURL() {
        return url;
    }

    /**
     * ͤ¿ͥפξñ̤֤ޤ
     *
     * @return ñ
     */
    public int getUnit() {
        return unit;
    }

    /**
     * ǽ׵§ꤵƤ뤫֤ޤ
     *
     * @return ꤵƤ <code>true</code>
     *         ʳξ <code>false</code>
     */
    public boolean getImportant() {
        return important;
    }

    /**
     * ͡ĹѡȤξˡͤ׻ƥԥ֤ͤޤ
     *
     * @param  basePx ͤΤ߻ꤵ줿˸ˤԥ
     * @param  perPx  % ꤵ줿˸ˤԥ
     * @param  baseFd EM, EX Ǹˤեȥǡ
     * @param  sense  
     *
     * @return ԥ
     */
    public int getValue(int basePx, int perPx, FontData baseFd, int sense) {
        if (number == null) {
            return 0;
        }

        // 1in  px
        int pxPin = Environment.screenResolution;

        switch (unit) {
        case UNIT_NONE   : return (int) Math.round(number.doubleValue() * basePx);
        case UNIT_EM     : return (int) Math.round(number.doubleValue() * (sense == DATA_HORIZONTAL ? baseFd.getFullSize().width : baseFd.getFullSize().height));
        case UNIT_EX     : return (int) Math.round(number.doubleValue() * baseFd.getXHeight());
        case UNIT_PX     : return number.intValue();
        case UNIT_IN     : return (int) Math.round(number.doubleValue() * pxPin               );
        case UNIT_CM     : return (int) Math.round(number.doubleValue() * pxPin / CM_P_IN     );
        case UNIT_MM     : return (int) Math.round(number.doubleValue() * pxPin / CM_P_IN / 10);
        case UNIT_PT     : return (int) Math.round(number.doubleValue() * pxPin / PT_P_IN     );
        case UNIT_PC     : return (int) Math.round(number.doubleValue() * pxPin / PC_P_IN     );
        case UNIT_PERCENT: return (int) Math.round(number.doubleValue() * perPx / 100         );
        default: // AVOID
        }
        return 0;
    }

    /**
     * Υȡʸɽ֤ޤ
     *
     * @return ʸɽ
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (type) {
        case TYPE_INTEGER   :
        case TYPE_LENGTH    :
        case TYPE_PERCENTAGE:
        {
            DecimalFormat df = new DecimalFormat("0.#");
            if (number instanceof Long) {
                sb.append(df.format(number.longValue  ()));
            } else {
                sb.append(df.format(number.doubleValue()));
            }
            switch (unit) {
            case UNIT_EM      : sb.append("em"); break;
            case UNIT_EX      : sb.append("ex"); break;
            case UNIT_PX      : sb.append("px"); break;
            case UNIT_IN      : sb.append("in"); break;
            case UNIT_CM      : sb.append("cm"); break;
            case UNIT_MM      : sb.append("mm"); break;
            case UNIT_PT      : sb.append("pt"); break;
            case UNIT_PC      : sb.append("pc"); break;
            case UNIT_PERCENT : sb.append("%" ); break;
            case UNIT_ASTERISK: sb.append("*" ); break;
            default: // AVOID
            }

            break;
        }
        case TYPE_STRING:
            sb.append(string);
            break;
        case TYPE_COLOR:
            sb.append(color.toString());
            break;
        case TYPE_URL:
            sb.append(url);
            break;
        default:
            if (string == null) {
                string = String.valueOf(type);
            }
            sb.append(string);
            break;
        }

        if (important) {
            sb.append(" !important");
        }

        return sb.toString();
    }
}
