/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Reporter;

/**
 * ȡκԤ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public final class TokenManager {
    private static TokenCreater rubyCreater;
    private static TokenCreater tableCreater;
    private static TokenCreater styleCreater;
    private static TokenCreater formCreater;
    private static TokenCreater frameCreater;
    static {
        Creater creater = new Creater();
        rubyCreater  = creater;
        tableCreater = creater;
        styleCreater = creater;
        formCreater  = creater;
        frameCreater = creater;

        try {
            rubyCreater  = (TokenCreater) Class.forName(Resource.getMessage("tokencreater.ruby" , null)).newInstance();
        } catch (Throwable e) { }
        try {
            tableCreater = (TokenCreater) Class.forName(Resource.getMessage("tokencreater.table", null)).newInstance();
        } catch (Throwable e) { }
        try {
            styleCreater = (TokenCreater) Class.forName(Resource.getMessage("tokencreater.style", null)).newInstance();
        } catch (Throwable e) { }
        try {
            formCreater  = (TokenCreater) Class.forName(Resource.getMessage("tokencreater.form" , null)).newInstance();
        } catch (Throwable e) { }
        try {
            frameCreater = (TokenCreater) Class.forName(Resource.getMessage("tokencreater.frame", null)).newInstance();
        } catch (Throwable e) { }
    }

    /** ߡ */
    private TokenManager() {
    }

    /**
     * ǤդΥȡγϤޤ
     *
     * @param  content  ƥ
     * @param  line     ֹ (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  column    (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  reporter 顼ݡ
     * @param  type     ȡγϤɽ
     * @param  complete 䴰ƺ줿 <code>true</code>
     *                  ʳξ <code>false</code>
     *
     * @return ϥȡ
     **/
    public static StartToken createStartToken(Content content, int line, int column,
                                              Reporter reporter, int type, boolean complete) {
        if (TokenTypes.isRuby (type)) {
            return rubyCreater .createStartToken(content, line, column, reporter, type, complete);
        }
        if (TokenTypes.isTable(type)) {
            return tableCreater.createStartToken(content, line, column, reporter, type, complete);
        }
        if (type == TokenTypes.STYLE_START || type == TokenTypes.STYLE_END) {
            return styleCreater.createStartToken(content, line, column, reporter, type, complete);
        }
        if (TokenTypes.isForm (type)) {
            return formCreater .createStartToken(content, line, column, reporter, type, complete);
        }
        if (TokenTypes.isFrame(type)) {
            return frameCreater.createStartToken(content, line, column, reporter, type, complete);
        }

        return new StartToken(content, line, column, reporter, type, complete);
    }

    /**
     * ǤդΥȡνλޤ
     *
     * @param  content  ƥ
     * @param  line     ֹ (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  column    (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  reporter 顼ݡ
     * @param  type ȡνλɽ
     * @param  complete 䴰ƺ줿 <code>true</code>
     *                  ʳξ <code>false</code>
     *
     * @return λȡ
     */
    public static EndToken createEndToken(Content content, int line, int column,
                                          Reporter reporter, int type, boolean complete) {
        if (TokenTypes.isRuby (type)) {
            return rubyCreater .createEndToken(content, line, column, reporter, type, complete);
        }
        if (TokenTypes.isTable(type)) {
            return tableCreater.createEndToken(content, line, column, reporter, type, complete);
        }
        if (type == TokenTypes.STYLE_END || type == TokenTypes.STYLE_START) {
            return styleCreater.createEndToken(content, line, column, reporter, type, complete);
        }
        if (TokenTypes.isForm (type)) {
            return formCreater .createEndToken(content, line, column, reporter, type, complete);
        }
        if (TokenTypes.isFrame(type)) {
            return frameCreater.createEndToken(content, line, column, reporter, type, complete);
        }

        return new EndToken(content, line, column, reporter, type, complete);
    }

    /**
     * Ӥ򥵥ݡȤƤ뤫ɤ֤ޤ
     *
     * @return Ӥ򥵥ݡȤƤ <code>true</code>
     *         ݡȤƤʤ <code>false</code>
     **/
    public static boolean canUseRuby() {
        return (rubyCreater != null);
    }

    /**
     * ơ֥򥵥ݡȤƤ뤫ɤ֤ޤ
     *
     * @return ơ֥򥵥ݡȤƤ <code>true</code>
     *         ݡȤƤʤ <code>false</code>
     **/
    public static boolean canUseTable() {
        return (tableCreater != null);
    }

    /**
     * 򥵥ݡȤƤ뤫ɤ֤ޤ
     *
     * @return 򥵥ݡȤƤ <code>true</code>
     *         ݡȤƤʤ <code>false</code>
     **/
    public static boolean canUseStyle() {
        return (styleCreater != null);
    }

    /**
     * ե򥵥ݡȤƤ뤫ɤ֤ޤ
     *
     * @return ե򥵥ݡȤƤ <code>true</code>
     *         ݡȤƤʤ <code>false</code>
     **/
    public static boolean canUseForm() {
        return (formCreater != null);
    }

    /**
     * ե졼򥵥ݡȤƤ뤫ɤ֤ޤ
     *
     * @return ե졼򥵥ݡȤƤ <code>true</code>
     *         ݡȤƤʤ <code>false</code>
     **/
    public static boolean canUseFrame() {
        return (frameCreater != null);
    }

//### Creater
    /** ߡꥨ */
    private static final class Creater implements TokenCreater {
        /** 󥹥󥹤 */
        private Creater() {
        }

        /** ϥȡ */
        public StartToken createStartToken(Content content, int line, int column,
                                           Reporter reporter, int type, boolean complete) {
            reportMessage(content, line, column, reporter, type);
            return null;
        }

        /** λȡ */
        public EndToken createEndToken(Content content, int line, int column,
                                       Reporter reporter, int type, boolean complete) {
            reportMessage(content, line, column, reporter, type);
            return null;
        }

        /** å */
        private void reportMessage(Content content, int line, int column, Reporter reporter, int type) {
            reporter.report(Reporter.TOKEN, Reporter.WARNING, Reporter.NONE,
                            content, line, column,
                            "Token", Resource.getMessage("tokenmanager.warning.notsupport",
                                                         new String[]{TokenTypes.getName(type)}));
        }
    }
}
