/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Render;
import net.hizlab.kagetaka.rendering.Reporter;

/**
 * ǡեΥȡɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public abstract class Token {
    /** ƥ */
    protected Content content = null;
    /** ϻ˵åϿݡ */
    protected Reporter reporter = null;
    /** ΥȡγϤֹ */
    protected int lineNumber = 0;
    /** Υȡ󤬳ϤƬΥ */
    protected int columnNumber = 0;
    /** 䴰ƺ줿ɤ */
    protected boolean completeToken = false;

    private StartToken parent = null;         // ƥȡ

    /**
     * ͣΥ󥹥ȥ饯Ǥ
     * ֥饹ǥ󥹥ȥ饯ϡ
     * Υ󥹥ȥ饯ƤӽФɬפޤ
     *
     * @param  content  ƥ
     * @param  line     ֹ (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  column    (<code>1</code> )
     *                  Ǥʤ <code>0</code>
     * @param  reporter 顼ݡ
     */
    protected Token(Content content, int line, int column, Reporter reporter) {
        this.content      = content;
        this.lineNumber   = line;
        this.columnNumber = column;
        this.reporter     = reporter;
    }

    /**
     * ȡ֤̾ޤ
     *
     * @return ȡ̾
     */
    public abstract String getName();

    /**
     * ȡΥפ֤ޤ
     *
     * @return ȡΥ
     *
     * @see    TokenTypes
     */
    public abstract int getType();

    /**
     * ȡγϰ֤ιֹ֤ޤ
     *
     * @return ϰ֤ιֹ
     */
    public int getLineNumber() {
        return lineNumber;
    }

    /**
     * ȡγϰ֤Υ֤֤ޤ
     *
     * @return ϰ֤Υ
     */
    public int getColumnNumber() {
        return columnNumber;
    }

    /**
     * Υȡ󤬽°ƤƤΥȡ֤ޤ
     * <p>
     * ȡγؤϡ{@link net.hizlab.kagetaka.parser.TokenCoordinator}
     * ˤ깽ۤޤ
     *
     * @return ȡ󤬽°ƤƤΥȡ
     */
    public StartToken getParent() {
        return parent;
    }

    /**
     * Υȡ󤬽°ƤƤΥȡꤷޤ
     *
     * @param  parent ƤΥȡ
     */
    void setParent(StartToken parent) {
        this.parent = parent;
    }

    /**
     * ȡ䴰ƺ줿ɤ֤ޤ
     *
     * @return 䴰ƺ줿 <code>true</code>
     *         ʳξ <code>false</code>
     */
    public boolean getCompleteToken() {
        return completeToken;
    }

    /**
     * νλȡΥפ򸵤ˡԤޤ
     * ǥեȤϲ⤷ޤ
     *
     * @param  render 
     * @param  pseudo 饹
     */
    public void render(Render render, int pseudo) {
    }

    /**
     * å𤷤ޤ
     *
     * @param  level åΥ٥
     * @param  key   å꥽Υ
     * @param  args  åɲð
     *               ɬפʤ <code>null</code>
     */
    protected void reportMessage(int level, String key, String[] args) {
        if (reporter == null) {
            return;
        }

        reporter.report(Reporter.TOKEN, level, Reporter.NONE,
                        content, lineNumber, columnNumber,
                        "Token", Resource.getMessage(key, args));
    }
}
