/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Reporter;

import java.util.StringTokenizer;

/**
 * ȡ°ɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public class Attribute {
    /** ƥ */
    protected Content content = null;
    /** ΥȡγϤֹ */
    protected int lineNumber = 0;
    /** Υȡ󤬳ϤƬΥ */
    protected int columnNumber = 0;
    /** ϻ˵åϿݡ */
    protected Reporter reporter = null;

    // °
    private String   attributeId    = null;
    private String[] attributeClass = null;
    private String   attributeTitle = null;
    private Object   attributeStyle = null;

    /**
     * ͣΥ󥹥ȥ饯Ǥ
     * ֥饹ǥ󥹥ȥ饯ϡ
     * Υ󥹥ȥ饯ƤӽФɬפޤ
     *
     * @param  content  ƥ
     * @param  line   ֹ (<code>1</code> )
     *                Ǥʤ <code>0</code>
     * @param  column  (<code>1</code> )
     *                Ǥʤ <code>0</code>
     * @param  reporter 顼ݡ
     */
    public Attribute(Content content, int line, int column, Reporter reporter) {
        this.content      = content;
        this.lineNumber   = line;
        this.columnNumber = column;
        this.reporter     = reporter;
    }

    /**
     * ꤵ줿°̾°ͤǡ°ꤷޤ
     * °̾¸ߤ <code>true</code> 
     * ¸ߤʤ <code>false</code> ֤ޤ
     * Ϥ <code>key</code> ϡɬʸѴƤޤ
     *
     * @param  key °̾
     * @param  value °
     *
     * @return °̾¸ߤ <code>true</code>
     *         ʳξ <code>false</code>
     *
     * @throws IllegalArgumentException °ʤ
     */
    public boolean setAttribute(String key, String value)
            throws IllegalArgumentException {
        return setBaseAttribute(key, value);
    }

    /**
     * ¿Υȡ˶̤°ꤷޤ
     * ꤵ°ϡidclasstitlestyle Ǥ
     *
     * @param  key °̾
     * @param  value °
     *
     * @return °̾¸ߤ <code>true</code>
     *         ʳξ <code>false</code>
     *
     * @throws IllegalArgumentException °ʤ
     */
    protected boolean setBaseAttribute(String key, String value)
            throws IllegalArgumentException {
        if ("id"   .compareTo(key) == 0) { attributeId    = value; return true; }
        if ("class".compareTo(key) == 0) {
            StringTokenizer st = new StringTokenizer(value, " ");
            attributeClass = new String[st.countTokens()];
            for (int i = 0; i < attributeClass.length; i++) {
                attributeClass[i] = st.nextToken();
            }
            return true;
        }
        if ("title".compareTo(key) == 0) { attributeTitle = value; return true; }
        if ("style".compareTo(key) == 0) { attributeStyle = value; return true; }

        return false;
    }

    /**
     * å𤷤ޤ
     *
     * @param  level åΥ٥
     * @param  key   å꥽Υ
     * @param  args  åɲð
     *               ɬפʤ <code>null</code>
     */
    protected void reportMessage(int level, String key, String[] args) {
        if (reporter == null) {
            return;
        }

        reporter.report(Reporter.TOKEN, level, Reporter.NONE,
                        content, lineNumber, columnNumber,
                        "Attribute", Resource.getMessage(key, args));
    }

    /**
     * ID ֤ޤ
     *
     * @return ID
     */
    public String getBaseId() {
        return attributeId;
    }

    /**
     * 饹֤̾ޤ
     *
     * @return 饹̾
     */
    public String[] getBaseClass() {
        return attributeClass;
    }

    /**
     * ȥ֤ޤ
     *
     * @return ȥ
     */
    public String getBaseTitle() {
        return attributeTitle;
    }

    /**
     * ֤ޤ
     *
     * @return 
     */
    public Object getStyle() {
        return attributeStyle;
    }

    /**
     * ꤷޤ
     *
     * @param  style 
     */
    public void setStyle(Object style) {
        attributeStyle = style;
    }
}
