/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering.block;

import net.fclabs.util.Queue;
import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.rendering.Canvas;
import net.hizlab.kagetaka.rendering.Constant;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.FormItem;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.CharBuffer;
import net.hizlab.kagetaka.util.CharList;
import net.hizlab.kagetaka.util.IntBuffer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.FontMetrics;

/**
 * ʣʸפθǤޤɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.8 $
 */
public class Wadge {
    /** ž̵ */
    protected static final char TYPE_NONE  = 0x2460;
    /**  90 ٲž */
    protected static final char TYPE_RIGHT = 0x2461;
    /** 屦ȿž */
    protected static final char TYPE_LTRB  = 0x2462;
    /**  */
    protected static final char TYPE_IMAGE = 0x2463;
    /**  */
    protected static final char TYPE_BR    = 0x2464;
    /** եॢƥ */
    protected static final char TYPE_FORM  = 0x2465;
    /** 饤֥å */
    protected static final char TYPE_BLOCK = 0x2466;
    /** ȥӥ塼 */
    protected static final char TYPE_ATTR  = 0x2467;
    /** ID */
    protected static final char TYPE_ID    = 0x2468;
    /** ե */
    protected static final char TYPE_FLOAT = 0x2469;
    /** ߡʸΥڡä */
    protected static final char TYPE_NULL  = 0x2470;
    // ʸȤƿʤɲä顢RbWadge.commit  switch (types[i]) ʬˤɲä

    /** Բ */
    protected static final char KIN_LOCK   = 0x0001;
    /** ¥ٹ */
    protected static final char SOKUYOU    = Canvas.DRAW_SOKUYOU;

    private static final char KIN_LOCK_CLEAR = 0xFFFE;

    // 󥹥ȥ饯
    /** ɥå */
    protected Drawkit drawkit;
    /** ƥ֥å */
    protected Block   parent;

    // 
    private boolean invalidate;

    // üʸꥹ
    private CharList charsSpinRight;
    private CharList charsSpinLtrb;
    private CharList charsKinsokuHead;
    private CharList charsKinsokuTail;
    private int      tdUnderline;
    private int      tdOverline;

    // ȥӥ塼
    private Attribute topAttribute;
    private Attribute lastAttribute;

    // ⤵ξ
    /** Ǿι⤵ */
    protected int minHeight;
    /** ι⤵ */
    protected int maxHeight;
    private int curHeight;                  // ߹Ԥκι⤵

    // 
    Wadge next;

    // Ȥξ
    /** ʸ */
    protected CharBuffer values  = new CharBuffer();
    /**  */
    protected CharBuffer types   = new CharBuffer();
    /** §ɤ */
    protected CharBuffer options = new CharBuffer();
    /** ʸμºݤ */
    protected IntBuffer  reals   = new IntBuffer ();
    /** ʸ */
    protected IntBuffer  widths  = new IntBuffer ();
    /** ʸι⤵ */
    protected IntBuffer  heights = new IntBuffer ();
    /** ʸХåեΥǥå */
    protected int        valuesIndex = -1;
    /** ºݤʸĹ */
    protected int        valuesLength;
    /** ʸȤξ岼Υǥ */
    protected int        indent;
    /** ʸȤκΥեå */
    protected int        offset;

    //// ʸɲûɬפѿ
    // ơå
    private FontMetrics  fontMetrics;
    private int          fontSizeHeight;
    private int          fontHalfHeight;
    private int          letterSpacing;     // ʸβɬפʷ
    private int          charHeightHalf;    // žȾʸι⤵
    private int          charHeightFull;    // žʸι⤵
    private int          charWidthTate;     // ̾ʸ
    private int          charHeightTate;    // ̾ʸι⤵
    private boolean      whiteSpaceBr;      // ڡǲԲǽ

    // ʸξ
    private boolean lastPending;            // Ǹ夬ڥǥ󥰤
    private boolean lastHankakuEisu;        // ǸʸȾѱѿ
    private int     penHeight;              // ڥǥʸι⤵

    // ¸
    private int saveValuesIndex = -2;       // valuesIndex ¸
    private int saveMinHeight;              // minHeight ¸
    private int saveCurHeight;              // curHeight ¸
    private int savePenHeight;              // penHeight ¸

    // ¾
    private Queue  idQueue;

    /**
     * ʸҤޤ
     *
     * @param  drawkit ɥå
     * @param  status  ơ
     * @param  parent  ƥ֥å
     */
    protected Wadge(Drawkit drawkit, Status status, Block parent) {
        this.drawkit = drawkit;
        this.parent  = parent;

        charsSpinRight   = drawkit.charsSpinRight;
        charsSpinLtrb    = drawkit.charsSpinLtrb;
        charsKinsokuHead = drawkit.charsKinsokuHead;
        charsKinsokuTail = drawkit.charsKinsokuTail;
        if (drawkit.swapDecoration) {
            tdUnderline = Value.TD_OVERLINE;
            tdOverline  = Value.TD_UNDERLINE;
        } else {
            tdUnderline = Value.TD_UNDERLINE;
            tdOverline  = Value.TD_OVERLINE;
        }

        topAttribute = lastAttribute = createAttribute(status);

        idQueue  = drawkit.idQueue;
    }

    /**
     * ʸɲäޤ
     *
     * @param  text  ʸ
     * @param  begin ϰ
     * @param  end   λ
     * @param  save  ʸɲˡߤξ֤¸
     *               <code>true</code>¸ʤ <code>false</code>
     */
    protected void append(String text, int begin, int end, boolean save) {
//Debug.out.println(this + ":Wadge.append: ["+text.substring(begin, end)+"],"+save);
        if (!idQueue.isEmpty()) {
            append();
        }

        // ѿ
        char c, t;

        for (int i = begin; i < end; i++) {
            c = text.charAt(i);

            // Ԥξ
            if (c == 0x0A) {
                append(c, TYPE_BR, 0, charWidthTate, 0, true, true, save);
                // ߹Ԥι⤵ȺԤι⤵
                maxHeight = Math.max(maxHeight, curHeight);
                curHeight = 0;
                continue;
            }

            // ڡʳȾʸ
            if (c <= 0xFF && c != 0x20) {
                append(c, TYPE_RIGHT, (whiteSpaceBr && !lastHankakuEisu), false, save);
                lastHankakuEisu = true;
                continue;
            }

            lastHankakuEisu = false;

            // žη
            if (/*---*/(c <= 0xFF)
                    || (0xFF61 <= c && c <= 0xFF9F)
                    || charsSpinRight.contains(c)) {
                t = TYPE_RIGHT;
            } else if (charsSpinLtrb.contains(c)) {
                t = TYPE_LTRB;
            } else {
                t = TYPE_NONE;
            }

            // Ƭ§ʸξϡ̤Хåե
            if (charsKinsokuHead.contains(c)) {
                append(c, t, false, false, save);
                continue;
            }

            // §ʸξϡߥåȤƳХåե
            if (charsKinsokuTail.contains(c)) {
                append(c, t, whiteSpaceBr, whiteSpaceBr, save);
                continue;
            }

            // ̤ʸξ硢ߥåȤ̤Хåե
            append(c, t, whiteSpaceBr, false, save);
        }
    }

    /**
     * ɲäޤ
     *
     * @param  src    
     * @param  alt    ʸ
     * @param  width  
     * @param  height ⤵
     * @param  border ܡ
     */
    protected void append(String src, String alt, Value width, Value height,
                          int border) {
        if (!idQueue.isEmpty()) {
            append();
        }

        ImageHolder ih = new ImageHolder(drawkit, lastAttribute.status,
                                         src, alt, width, height, border);

        char c;

        // Υǥå
        synchronized (drawkit.images) {
            c = (char) drawkit.images.size();
            drawkit.images.addElement(ih);
        }

        int b = ih.border * 2;

        // ξϡߥåȤƳХåե
        append(c, TYPE_IMAGE,
               ih.size.width  + b,
               ih.size.width  + b,
               ih.size.height + b + letterSpacing,
               whiteSpaceBr, whiteSpaceBr, false);
    }

    /**
     * եॢƥɲäޤ
     *
     * @param  item ƥ
     */
    protected void append(FormItem item) {
        if (!idQueue.isEmpty()) {
            append();
        }

        char c;

        // եॢƥΥǥå
        synchronized (drawkit.formItems) {
            c = (char) drawkit.formItems.size();
            drawkit.formItems.addElement(item);
        }

        Dimension size = item.getSize();

        // եξϡߥåȤƳХåե
        append(c, TYPE_FORM,
               size.width,
               size.width,
               size.height + letterSpacing,
               whiteSpaceBr, whiteSpaceBr, false);
    }

    /**
     * 饤֥åɲäޤ
     *
     * @param  block 饤֥å
     */
    protected void append(Block block) {
        if (!idQueue.isEmpty()) {
            append();
        }

        char c;

        // 饤֥åΥǥå
        synchronized (drawkit.inlineBlocks) {
            c = (char) drawkit.inlineBlocks.size();
            drawkit.inlineBlocks.addElement(block);
        }

        // 饤֥åξϡߥåȤƬʳ̤Хåե
        append(c, TYPE_BLOCK,
               block.width,
               block.width,
               block.height + letterSpacing,
               false, false, false);
        valuesLength--;                     // ʸȤƤϿʤ
    }

    /**
     * եȥ֥åɲäޤ
     *
     * @param  block եȥ֥å
     */
    protected void append(FloatBlock block) {
        if (!idQueue.isEmpty()) {
            append();
        }

        // եȥ֥åϿֹ
        char c = parent.container.registerFloat(block);

        // եξϡߥåȤƬʳ̤Хåե
        append(c, TYPE_FLOAT, 0, 0, 0, false, false, false);
        valuesLength--;                     // ʸȤƤϿʤ
    }

    /** ID ֤ɲ */
    private void append() {
        char   c;
        Object id;

        synchronized (drawkit.ids) {
            while ((id = idQueue.get()) != null) {
                // ID Υǥå
                c = (char) drawkit.ids.size();
                drawkit.ids.addElement(id);

                // ID ξϡߥåȤ̤Хåե
                append(c, TYPE_ID, 0, 0, 0, false, false, false);
                valuesLength--;             // ʸȤƤϿʤ
            }
        }
    }

    /** Хåեɲáʸξ */
    private void append(char c, char t,
                        boolean before, boolean after, boolean save) {
        int r, w, h;
        switch (t) {
        case TYPE_RIGHT:
        case TYPE_LTRB :
            if ((c <= 0xFF) || (0xFF61 <= c && c <= 0xFF9F)) {
                r = fontHalfHeight;
                w = charHeightHalf;
            } else {
                r = fontSizeHeight;
                w = charHeightFull;
            }
            h = fontMetrics.charWidth(c) + letterSpacing;
            break;
        default:
            r = fontMetrics.charWidth(c);
            w = charWidthTate;
            h = charHeightTate;
        }

        append(c, t, r, w, h, before, after, save);
    }

    /**
     * ꤵ줿Хåեɲäޤ
     *
     * @param  c      ʸ䡢ID ʤɤ̤
     * @param  t      <code>c</code> Υ
     * @param  r      
     * @param  w      ɬפ
     * @param  h      ɬפʹ⤵
     * @param  before ʸľǲԤƤפʾ
     *                <code>true</code>ʾ <code>false</code>
     * @param  after  ʸľǲԤƤפʾ
     *                <code>true</code>ʾ <code>false</code>
     * @param  save   ʸɲˡߤξ֤¸
     *                <code>true</code>¸ʤ <code>false</code>
     */
    protected void append(char c, char t, int r, int w, int h,
                          boolean before, boolean after, boolean save) {
        // ľޤǤ
        if (before && lastPending) {
            commitPending();
        }

        // ߤξ֤¸
        if (save) {
            saveValuesIndex = valuesIndex;
            saveMinHeight   = minHeight;
            saveCurHeight   = curHeight;
            savePenHeight   = penHeight;
        }

        char o = (CharList.SOKUYOU.contains(c) ? SOKUYOU : (char) 0);
        if (!after) {
            lastPending =  true;
            penHeight   += h;
            o |= KIN_LOCK;
        } else {
            if (minHeight < h) {
                minHeight = h;
            }
        }
        curHeight += h;

        values .append(c);
        types  .append(t);
        options.append(o);
        reals  .append(r);
        widths .append(w);
        heights.append(h);
        valuesIndex++;
        valuesLength++;
    }

    /** ̤ʬ */
    private void commitPending() {
        // Ǹʸ KIN_LOCK 򥯥ꥢ
        options.replace(valuesIndex, (char) (options.get(valuesIndex) & KIN_LOCK_CLEAR));
        lastPending = false;

        // Ǿι⤵׻
        if (minHeight < penHeight) {
            minHeight = penHeight;
        }
        penHeight = 0;
    }

    /**
     * ӤΥ⡼ɤѹޤ
     *
     * @param  mode ӤΥ⡼
     */
    protected void setRuby(int mode) {
        // ̵
    }

    /**
     * ơѹΤޤ
     *
     * @param  status ơ
     */
    protected void statusChanged(Status status) {
        lastAttribute = lastAttribute.next = createAttribute(status);

        // ȥӥ塼ȤξϡߥåȤ̤Хåե
        append((char) 0, TYPE_ATTR, 0, 0, 0, false, false, false);
        valuesLength--;                     // ʸȤƤϿʤ
    }

    /** ơͤ׻ݻ */
    private Attribute createAttribute(Status status) {
        // եȾ
        FontData fontData       = status.fontData;
        int      fontSizeWidth  = status.fontFullSize.width;

        // å
        fontMetrics    = status.fontMetrics;
        fontSizeHeight = status.fontFullSize.height;
        fontHalfHeight = status.fontHalfHeight;

        // ȥӥ塼Ⱦ׻
        int offsetX = (status.offsetX != null
                       ? status.offsetX.getValue(1,
                                                 fontSizeWidth,
                                                 fontData,
                                                 Value.DATA_HORIZONTAL)
                       : 0);

        // sup, super ξκνФĥ
        int offsetRight = Math.max(offsetX, 0);
        if ((status.decoration & tdOverline ) != 0) {
            offsetRight += Constant.LINE_GAP;
        }
        int offsetLeft  = Math.max(-offsetX, 0);
        if ((status.decoration & tdUnderline) != 0) {
            offsetLeft  += Constant.LINE_GAP;
        }

        // Ԥι⤵;
        int linePitch  = ((status.lineHeight != null
                        && status.lineHeight.getType() != Value.TYPE_KEY_NORMAL)
                          ? status.lineHeight.getValue(fontSizeWidth,
                                                       fontSizeWidth,
                                                       fontData,
                                                       Value.DATA_HORIZONTAL)
                          : (int) Math.round(fontSizeWidth * Constant.LINE_HEIGHT))
                         - fontSizeWidth;
        int half       = linePitch / 2;

        int pitchLeft  = Math.max(offsetLeft , (linePitch - half)); // Υڡ
        int pitchRight = Math.max(offsetRight, half);               // Υڡ

        // ¾
        letterSpacing  = (status.letterSpacing != null
                          ? status.letterSpacing.getValue(1,
                                                          fontSizeWidth,
                                                          fontData, Value.DATA_VERTICAL)
                          : 0);
        charHeightHalf = pitchRight + fontHalfHeight;
        charHeightFull = pitchRight + fontSizeHeight;
        charWidthTate  = pitchRight + fontSizeWidth;
        charHeightTate = fontSizeHeight + letterSpacing;
        whiteSpaceBr   = (status.whiteSpace == Value.WHITESPACE_NORMAL);

        return new Attribute(status, offsetX, Math.max(half - offsetRight, 0), pitchLeft);
    }

    /**
     * Ǹ¸֤ᤷޤ
     */
    protected void restore() {
        if (saveValuesIndex != -2) {
            int index = saveValuesIndex + 1;
            types  .replace(index, TYPE_NULL);
            reals  .replace(index, 0);
            widths .replace(index, 0);
            heights.replace(index, 0);
            minHeight = saveMinHeight;
            curHeight = saveCurHeight;
            penHeight = savePenHeight;
            valuesLength--;

            saveValuesIndex = -2;
        }
    }

    /**
     * ٤Ƴꤷޤ
     */
    protected void commit() {
        if (lastPending) {
            commitPending();
        }
        maxHeight   = Math.max(maxHeight, curHeight);
        fontMetrics = null;
        idQueue     = null;
    }

    /**
     * ߤη׻̵ˤơƷ׻оݤˤޤ
     */
    void invalidate() {
        invalidate = true;
        parent.invalidate();
    }

    /**
     * Ԥޤ
     *
     * @param  lines  Ծ
     * @param  awidth ɲ
     */
    protected void validate(Lines lines, int awidth) {
        if (valuesIndex < 0) { return; }

        // ΨΤˡѿ
        char[] values  = this.values .getChars();
        char[] types   = this.types  .getChars();
        char[] options = this.options.getChars();
        int [] widths  = this.widths .getInts ();
        int [] heights = this.heights.getInts ();
        int    length  = valuesIndex;

        // ȥӥ塼
        Attribute attribute  = topAttribute;
        int       pitchRight = Math.max(awidth - attribute.right, 0);
        int       pitchLeft  = attribute.left;

        // 
        int oddHeight = 0;

        char t;
        int w        , h         , l       ;    // 
        int width = 0, height = 0, left = 0;    // ߥå
        Queue floatQueue = null;
        boolean reserve = true;

        // §Υ롼
        for (int i = 0; i <= length;) {
            w = h = 0;
            l = pitchLeft;

            // §Υ롼
            do {
                switch (t = types[i]) {
                case TYPE_ATTR:
                    // ȥӥ塼Ȥꤷľ
                    attribute  = attribute.next;
                    pitchRight = Math.max(awidth - attribute.right, 0);
                    pitchLeft  = attribute.left;
                    l = Math.max(l, pitchLeft);
                    break;
                case TYPE_FLOAT:
                {
                    FloatBlock block = parent.container.getFloat(values[i]);
                    // Ƭξ¨¤ɲ
                    if (height + h == 0) {
                        lines.append(block, true);
                    } else if (h == 0) {
                        lines.append(block, false);
                    } else {
                        if (floatQueue == null) {
                            floatQueue = new Queue();
                        }
                        floatQueue.put(block);
                    }

                    break;
                }
                default:
                    // 礭򻻽
                    w =  Math.max(w, widths[i]);
                    h += heights[i];
                }
            } while ((options[i++] & KIN_LOCK) != 0); // Ǹʸж§ǤϤʤ

            // §λ硢ꤹ
            if (oddHeight < h) {
                // ܰʹߡheight > 0ˤϹԤɲáϹ⤵
                if (reserve) {
                    oddHeight = lines.reserve(h);
                    reserve   = false;
                } else {
                    oddHeight = lines.append(width + pitchRight, height, left, h);
                }
                width     =  w;
                height    =  h;
                left      =  l;
            } else {
                width     =  Math.max(width, w);
                height    += h;
                left      =  Math.max(left , l);
            }
            // Ԥξ
            if (t == TYPE_BR) {
                if (reserve) {
                    lines.reserve(height);
                } else {
                    reserve = true;
                }
                lines.append(width + pitchRight, height, left, 0);
                oddHeight =  0;
                width     =  0;
                height    =  0;
                left      =  0;
            } else {
                oddHeight -= h;
            }
            // 塼Υեȥ֥åɲ
            if (floatQueue != null) {
                while (!floatQueue.isEmpty()) {
                    lines.append((FloatBlock) floatQueue.get(), false);
                }
            }
        }

        // ǸιԤɲ
        if (height > 0 || width > 0) {
            if (reserve) {
                lines.reserve(height);
            }
            lines.append(width + pitchRight, height, left);
        }
    }

    /**
     * 褷ޤ
     *
     * @param  canvas 襭Х
     * @param  lines  Ծ
     */
    protected void draw(Canvas canvas, Lines lines) {
        if (valuesLength == 0) { return; }

        // ΨΤˡѿ
        Graphics g       = canvas.g;
        char[]   values  = this.values .getChars();
        char[]   types   = this.types  .getChars();
        char[]   options = this.options.getChars();
        int []   reals   = this.reals  .getInts ();
        int []   heights = this.heights.getInts ();
        int      indent  = this.indent;
        int      offset  = this.offset;
        int      length  = valuesIndex;

        // ȥӥ塼
        Attribute attribute      = topAttribute;
        Status    status         = attribute.status;
        int       offsetX        = attribute.offset + offset;
        int       fontSizeWidth  = status.fontFullSize.width;
        boolean   hasInfo        = (status.anchor     != null
                                 || status.tip        != null
                                 || status.decoration != 0);
        g.setColor(status.foreColor);
        g.setFont (status.font     );

        // ־
        int x      = lines.x + offsetX;     // Ѥ x 
        int y      = lines.y;               // Ѥ y 
        int height = lines.getHeight() + y; // Ԥι⤵

        char c, t;                          // ʸʸ
        int  begin;                         // Хåեγϰ
        int  w, h;                          // Ʊʸ⤵
        int  x2, y2;                        // ʸϰ

        // ƤʪΥ롼
        for (int i = 0; i <= length;) {
            t = types[i];

            // 礭¸ߤʤ
            switch (t) {
            case TYPE_ATTR:
                // ȥӥ塼Ȥꤷľ
                attribute      = attribute.next;
                status         = attribute.status;
                offsetX        = attribute.offset + offset;
                fontSizeWidth  = status.fontFullSize.width;
                fontSizeHeight = status.fontFullSize.height;
                hasInfo        = (status.anchor     != null
                               || status.tip        != null
                               || status.decoration != 0);
                g.setColor(status.foreColor);
                g.setFont (status.font     );

                // ֤
                x = lines.x + offsetX;
                i++;
                continue;
            case TYPE_ID:
                // ID 
                drawkit.setIdPosition(values[i],
                                      canvas, canvas.width - (x + lines.getWidth() + Constant.ID_GAP),
                                      0);
                i++;
                continue;
            case TYPE_FLOAT:
            case TYPE_NULL:
                // եȡߡʸ̵
                i++;
                continue;
            default: // AVOID
            }

            // եȰʳϼǲ
            if (y >= height) {
if (y > height) {
Debug.out.println("!!! Wadge.draw.newLine: " + y + " > " + height + " : [" + new String(values, Math.max(i - 10, 0), Math.min(i + 10, length) - Math.max(i - 10, 0)) + "],[" + (i - Math.max(i - 10, 0)) + "]");
}
                height  =  lines.newLine();
                x       =  lines.x + offsetX;
                y       =  lines.y;
                height  += y;
            }

            c = values[i];
//Debug.out.println("[" + c + "],[" + t + "],[" + y + "],[" + height + "]");

            switch (t) {
            case TYPE_NONE :
                // ̾νĽʸ
                begin = i;
                w = fontSizeWidth;
                h = heights[i++];
                while (y + h < height && i <= length && types[i] == t) {
                    h += heights[i++];
                }
                canvas.drawTextTate(values, reals, heights, options,
                                    begin, i, x, y, w, indent, status);
                break;
            case TYPE_RIGHT:
                // žʸ
                begin = i;
                w = reals  [i  ];
                h = heights[i++];
                while (y + h < height && i <= length && types[i] == t) {
                    w =  Math.max(w, reals[i]);
                    h += heights[i++];
                }
                canvas.drawTextWithRight(values, heights,
                                         begin, i, x, y, h, w, indent, status);
                break;
            case TYPE_LTRB :
                // 屦ȿžʸ
                w = reals  [i  ];
                h = heights[i++];
                // draw ⤵ h ǤϤʤletterSpacing ޤޤƤ뤫
                canvas.drawCharWithLtrb(c, x, y + indent,
                                        status.fontMetrics.charWidth(c), w, status);
                break;
            case TYPE_IMAGE:
            {
                // 
                ImageHolder ih = (ImageHolder) drawkit.images.elementAt(c);
                ih.draw(canvas, x, y + indent);
                y += heights[i++];

                continue;
            }
            case TYPE_BR:
                // Ԥξϲ⤷ʤʲ԰֤ y == height ˤʤ뤫
                i++;
                continue;
            case TYPE_FORM:
            {
                // ե
                FormItem item  = (FormItem) drawkit.formItems.elementAt(c);
                Dimension size = item.getSize();

                if (item.isNeedBackImage()) {
                    Image    image = drawkit.createImage(size.width, size.height);
                    Graphics og    = image.getGraphics();
                    try {
                        canvas.drawImageSync(og, canvas.image,
                                             0, 0, size.width    , size.height    ,
                                             x, y, size.width + x, size.height + y);
                    } finally {
                        og.dispose();
                    }
                    item.setBackImage(image);
                }

                // Υߥ󥰤 show ƤޤȡХΥåȥåפ
                // Ƥʤ礬Τǡö塼
                item.setPosition(canvas.width + canvas.x - (x + size.width + 1), y);
                drawkit.formQueue.put(item);
                y += heights[i++];
                continue;
            }
            case TYPE_BLOCK:
                // 饤֥å
                ((Block) drawkit.inlineBlocks.elementAt(c)).draw(canvas, x + reals[i], y);
                y += heights[i++];
                continue;
            default: // AVOID
                throw new RuntimeException("invalid wadge type " + ((int) t));
            }

            // ɲþ󤬲̵
            if (!hasInfo) {
                y += h;
                continue;
            }

            y2 = y + h;
            // 
            if (status.anchor != null) {
                canvas.itemMap.addLink(status.anchor,
                                       canvas.width - (x + w + 1), y,
                                       canvas.width - x          , y2);
            }

            // TIP 
            if (status.tip != null) {
                canvas.itemMap.addTip(status.tip,
                                      canvas.width - (x + w + 1), y,
                                      canvas.width - x          , y2);
            }

            // ʸ
            if (status.decoration != 0) {
                // 
                if ((status.decoration & tdUnderline) != 0) {
                    x2 = x - Constant.LINE_GAP;
                    g.drawLine(x2, y, x2, y2);
                }
                // 
                if ((status.decoration & tdOverline ) != 0) {
                    x2 = x + fontSizeWidth + Constant.LINE_GAP - 1;
                    g.drawLine(x2, y, x2, y2);
                }
                // Ǥä
                if ((status.decoration & Value.TD_STRIKE   ) != 0) {
                    x2 = x + (int) (fontSizeWidth * Constant.STRIKE_GAP);
                    g.drawLine(x2, y, x2, y2);
                }
            }

            y = y2;
        }

        // y ֤¸
        lines.y = y;
    }

    /**
     *  x Υեåͤޤ
     *
     * @param  lines Ծ
     *
     * @return x Υեå
     */
    protected int getDrawOffset(Lines lines) {
        return 0;
    }
}
