/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering.block;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.addin.Ruby;
import net.hizlab.kagetaka.rendering.Canvas;
import net.hizlab.kagetaka.rendering.Constant;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.FormItem;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.TextFormat;

/**
 * ֥åǤľˤʸݻƿ֥̾å
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.7 $
 */
class TextBlock extends Block {
    private static final String BR    = String.valueOf((char) 0x0A);
    private static final String SPACE = String.valueOf(' ');

    private static final int LS_BEGIN = 0;  // ԤƬ
    private static final int LS_TRUE  = 1;  // Ǹ夬ڡ
    private static final int LS_FALSE = 2;  // Ǹ˥ڡϤʤ

    private static final int WADGE_SAME   = 0;  // ѹ̵
    private static final int WADGE_NORMAL = 1;  // ̾
    private static final int WADGE_RUBY   = 2;  // 

    // ơΥå
    private int     indent;
    private boolean whiteSpacePre;
    private boolean reference;

    // ʸ
    private Wadge wadge;
    private Wadge topWadge;
    private Wadge lastWadge;

    // Ծ
    private Lines lines;

    private int lastSpace = LS_BEGIN;   // Ǹ夬ڡɤ

    /**
     * ƿ̾ƥȥ֥åޤ
     *
     * @param  drawkit   ɥå
     * @param  status    ơ
     * @param  container ƥʥ֥å
     *                   եȤαƶʤ <code>null</code>
     * @param  parent    ƥ֥å
     * @param  indent    ǥ
     */
    TextBlock(Drawkit drawkit, Status status,
              ContainerBlock container, Block parent, int indent) {
        super(drawkit, status, container, parent);
        this.indent = indent;

        // ơ
        whiteSpacePre = (status.whiteSpace == Value.WHITESPACE_PRE);
        reference     = status.reference;

        // ƬʸҺ
        wadge = topWadge = lastWadge = new Wadge(drawkit, status, this);
    }

    /** {@inheritDoc} */
    public Block createBlock(Status status, Status markerStatus) {
Debug.out.println("??? textBlock.createBlock");
        return null;
    }

    /** {@inheritDoc} */
    public Block commitBlock() {
        // ʸҤ򥳥ߥå
        if (lastSpace == LS_TRUE) {
            wadge.restore();
        }
        wadge.commit();
        wadge = null;

        /*
         * ƥȥ֥åϡanalyze ǤϤʤߥåȻ礭ꤹ롣
         * ϡߥåȤ줿 maxHeight  0 ȡ
         * Ƥƥȥ֥å˴Ƥޤᡣ
         * Block.commitDefaultBlock() 򻲾
         */
        Wadge wadge = topWadge;
        do {
            minHeight = Math.max(minHeight, wadge.minHeight);
            maxHeight = Math.max(maxHeight, wadge.maxHeight);
        } while ((wadge = wadge.next) != null);
//Debug.out.println(this + ":TextBloxk.commit: " + minHeight + "," + maxHeight);

        // ɤå
        isEmpty = (minHeight == 0
                && topWadge  == lastWadge
                && topWadge.valuesIndex < 0);

        return null;
    }

    /** {@inheritDoc} */
    public void analyze(int minParentHeight, int maxParentHeight) {
        // ̵minHeight  maxHeight  commitBlock ǳꤹ
    }

    /** {@inheritDoc} */
    public void validate(int parentHeight, int prevLeftMargin, int x, int y,
                         int containerX, int containerY) {
//Debug.out.println(this + ":TextBlock.validate: " + parentHeight + "," + x + "," + y);
        this.top   = y;
        this.right = x;

        if (lines == null) {
            lines = new Lines(this, parent.status.align, indent);
        } else {
            lines.clear();
        }

        // եѤ˥ƥʤΰ֤
        lines.setup(parentHeight, containerX + x, containerY + y);

        // Wadge Ĵ
        Wadge wadge = topWadge;
        do {
            wadge.validate(lines, 0);
        } while ((wadge = wadge.next) != null);
        lines.commit();

        int width  = lines.totalWidth;
        int height = lines.totalHeight;

        // ⤵¸
        this.width      = width;
        this.height     = parentHeight;

        // 
        if (width > 0) {
            this.bottom     = top   + height;
            this.left       = right + width;
            this.drawTop    = top;
            this.drawRight  = right;
            this.drawBottom = top + Math.max(height, parentHeight);
            this.drawLeft   = left;
        } else {
            this.bottom     = top;
            this.left       = right;
            this.drawTop    = top;
            this.drawRight  = right;
            this.drawBottom = bottom;
            this.drawLeft   = left;
        }
    }

    /** {@inheritDoc} */
    protected void draw(Canvas canvas, int x, int y) {
//Debug.out.println(this + ":TextBlock.draw: " + x + "," + y);
        if (maxHeight == 0) {
            return;
        }

        lines.setup(x - right, y + top);

        Wadge wadge = topWadge;
        do {
            wadge.draw(canvas, lines);
        } while ((wadge = wadge.next) != null);
    }

//### 
    /** {@inheritDoc} */
    public void appendString(String text) {
//Debug.out.println(this + ":TextBlock.append: ["+text+"]");
        int begin = 0, end = 0;

        text = (whiteSpacePre
                ? TextFormat.convertXhtml(text, false                  , false, false, reference)
                : TextFormat.convertXhtml(text, (lastSpace != LS_FALSE), false, true , reference));

        if ((end = text.length()) == 0) {
            return;
        }

        // ֥åƬβԤ̵뤹PRE ľβԡ
        if (text.charAt(0) == 0x0A && wadge == topWadge && wadge.valuesLength == 0) {
            begin++;
        }

        if (!whiteSpacePre && text.charAt(end - 1) == ' ') {
            if (--end > begin) {
                wadge.append(text, begin, end, false);
            }
            wadge.append(" ", 0, 1, true);
            lastSpace = LS_TRUE;
        } else {
            wadge.append(text, begin, end, false);
            lastSpace = LS_FALSE;
        }
    }

    /** {@inheritDoc} */
    public void appendNewLine() {
        if (lastSpace == LS_TRUE) {
            wadge.restore();
        }
        wadge.append(BR, 0, 1, false);
        lastSpace = LS_BEGIN;
    }

    /** {@inheritDoc} */
    public void appendImage(String src, String alt, Value width, Value height,
                            int border, int floatType) {
        wadge.append(src, alt, width, height, border);
        lastSpace = LS_FALSE;
    }

    /** {@inheritDoc} */
    public void appendForm(FormItem item) {
        wadge.append(item);
        lastSpace = LS_FALSE;
    }

    /** {@inheritDoc} */
    public void appendBlock(Block block) {
        wadge.append(block);
        lastSpace = LS_FALSE;
    }

    /** {@inheritDoc} */
    public void appendFloat(FloatBlock block) {
        wadge.append(block);
    }

    /** {@inheritDoc} */
    public void setRuby(int mode) {
        switch (mode) {
        case Constant.RUBY_START:
            wadge.commit();
            if ((wadge = Ruby.createWadge(drawkit, status, this)) == null) {
                wadge = new Wadge(drawkit, status, this);
            }
            lastWadge = lastWadge.next = wadge;
            break;
        case Constant.RUBY_END:
            wadge.restore();                // ӤκǸΥڡϺ
            wadge.commit ();
            wadge = new Wadge(drawkit, status, this);
            lastWadge = lastWadge.next = wadge;
            lastSpace = LS_FALSE;           // ӤμΥڡͭˤ
            break;
        default:
            wadge.setRuby(mode);
        }
    }

    /** {@inheritDoc} */
    public void statusChanged(Status status) {
        this.status = status;

        wadge.statusChanged(status);
        whiteSpacePre = (status.whiteSpace == Value.WHITESPACE_PRE);
        reference     = status.reference;
    }

//### Utils
    /** {@inheritDoc} */
    protected Line getFirstLine() {
        return (lines != null
                ? lines.getLine(0)
                : null);
    }
}
