/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering.block;

import net.fclabs.util.Queue;
import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.rendering.Canvas;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.Value;

import java.awt.Dimension;
import java.awt.Insets;

/**
 * 롼ȥ֥åBODYˤɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.8 $
 */
public class RootBlock extends ContainerBlock {
//private int xxx;
    private int drawTag;                    // Υ

    private Cabinet topCabinet;             // ǽΥ֥å
    private Cabinet lastCabinet;            // Ǹɲä֥å
    private Cabinet drawCabinet;            // 褵ƤʤǽΥ֥å

    private Queue   floatDrawQueue;         // 褵Ƥʤե
    private Cabinet lastNormalCabinet;      // ǸΥեȤǤϤʤ֥å

    private int rootPreferredWidth;         // 롼Ȥο侩
    private int rootPreferredHeight;        // 롼Ȥο侩⤵
    private int viewportWidth;              // ɽ

    /**
     * 롼ȥ֥åޤ
     *
     * @param  drawkit ɥå
     * @param  status  ơ
     * @param  tag     ѹ̤륿
     */
    public RootBlock(Drawkit drawkit, Status status, int tag) {
        super(drawkit, status, null);
        this.parent  = this;
        this.drawTag = tag;

        calculateSize(true);

        // ʬȤαե졼ɲ
        topCabinet = lastCabinet = drawCabinet = lastNormalCabinet = new Cabinet(
            new SpaceBlock(drawkit, status, container, this, null)
        );
        // ե졼ϡΥ֥åˤäĤƤޤ
        topCabinet.validate();
        topCabinet.isCarryOver = true;
    }

    /** {@inheritDoc} */
    protected void calculatePreferred() {
        // ά AUTOwidth  % ϿƤ FIXED ξΤͭ
        rootPreferredWidth  = (status.width  == null
                               ? SIZE_AUTO
                               : (status.width .getUnit() == Value.UNIT_PERCENT
                                  ? SIZE_PERCENT
                                  : status.width .getValue(1, 0,
                                                           status.fontData,
                                                           Value.DATA_HORIZONTAL)));
        rootPreferredHeight = (status.height == null
                               ? SIZE_AUTO
                               : (status.height.getUnit() == Value.UNIT_PERCENT
                                  ? SIZE_PERCENT
                                  : status.height.getValue(1, 0,
                                                           status.fontData,
                                                           Value.DATA_VERTICAL  )));
    }

    /** ӥͥåȥ֥åɲ */
    private void addCabinet(Cabinet cabinet) {
        cabinet    .prevAll = lastCabinet;
        lastCabinet.nextAll = cabinet;
        lastCabinet = cabinet;

        if (!cabinet.isFloat) {
            cabinet          .prev = lastNormalCabinet;
            lastNormalCabinet.next = cabinet;
            lastNormalCabinet = cabinet;
            if (drawCabinet == null) {
                drawCabinet = cabinet;
            }
        }
    }

    /** 򻻽Ф */
    private void calculateSize(boolean def) {
        Dimension viewSize = drawkit.context.getViewportSize(def);

        calculateFrame(viewSize.height);

        // 
        switch (rootPreferredWidth) {
        case SIZE_AUTO:
            preferredWidth = viewSize.width - frameWidth;
            break;
        case SIZE_PERCENT:
            preferredWidth = (viewSize.width * status.width.getNumber().intValue()) / 100;
            break;
        default: // AVOID
        }

        // ⤵
        switch (rootPreferredHeight) {
        case SIZE_AUTO:
            preferredHeight = viewSize.height - frameHeight;
            break;
        case SIZE_PERCENT:
            preferredHeight = (viewSize.height * status.height.getNumber().intValue()) / 100;
            break;
        default: // AVOID
        }

        this.top    = frame.top;
        this.bottom = preferredHeight + frame.top;
        viewportWidth = viewSize.width + frameWidth;
    }

    /** {@inheritDoc} */
    public Block createBlock(Status status, Status markerStatus) {
        // ֥å
        Block block = super.createBlock(status, markerStatus);

        // ɲ
        if (block instanceof FloatBlock) {
            FloatBlock floatBlock = (FloatBlock) block;
            registerFloat(floatBlock);
            addCabinet(new Cabinet(floatBlock));
        } else {
            addCabinet(new Cabinet(block));
        }

        return block;
    }

    /** {@inheritDoc} */
    public Block commitBlock() {
        // ʬȤκե졼ɲ
        addCabinet(new Cabinet(new SpaceBlock(drawkit, status, container, this, lastCabinet)));

        // ե졼बꤷ̤ʬ٤Ƥ褵
        super.commitBlock();

        return null;
    }

    /** {@inheritDoc} */
    protected Block commitChild() {
        // ǸΥ֥å礭Ĵ
        lastCabinet.validate();

        // եȤڤܤǥߥåȺѤߤΥ֥å褹
        if (!lastCabinet.isFloat && !lastCabinet.isCarryOver) {
            drawCabinet.draw(HawkContext.IMAGE_NEW, drawTag);
            drawCabinet = null;
        }

        return this;
    }

    /** {@inheritDoc} */
    public void analyze(int minParentHeight, int maxParentHeight) {
Debug.out.println("??? rootBlock.analyze");
    }

    /** {@inheritDoc} */
    public void validate(int parentHeight, int prevLeftMargin, int x, int y,
                         int containerX, int containerY) {
Debug.out.println("??? rootBlock.validate");
    }

    /** {@inheritDoc} */
    protected void invalidate() {
Debug.out.println("??+ rootBlock.invalidate");
        //### TODO
        // γˤ minHeight ѤΤǡanalyze() ƤӤʤɬפ
    }

    /** {@inheritDoc} */
    protected void draw(Canvas canvas, int x, int y) {
Debug.out.println("??? rootBlock.draw");
    }

//### ե
    /** {@inheritDoc} */
    protected char registerFloat(FloatBlock block) {
        if (floatBlocks == null) {
            floatManager = new FloatManager(top, bottom);
        }
        return super.registerFloat(block);
    }

    /** {@inheritDoc} */
    protected void deployFloat(FloatBlock block,
                               int right, int top, int bottom) {
        super.deployFloat(block, right, top, bottom);
        if (floatDrawQueue == null) {
            floatDrawQueue = new Queue();
        }
        floatDrawQueue.put(block);
    }

//### Root
    /**
     * ѤߤΥ֥å褷ޤ
     *
     * @param  tag ѹ̤륿
     */
    public void redraw(int tag) {
        calculateSize(false);
//Debug.out.println("> rootBlock.redraw: [" + preferredWidth + "x" + preferredHeight + "]");

        if (floatManager != null) {
            floatManager = new FloatManager(top, bottom);
        }
        if (floatDrawQueue != null) {
            floatDrawQueue.clear();
        }

        Cabinet drawCabinet, lastCabinet;
        drawCabinet = lastCabinet = topCabinet;
        while (lastCabinet != null) {
            // ǸΥ֥å礭Ĵ
            lastCabinet.validate();

            // եȤڤܤǥߥåȺѤߤΥ֥å褹
            if (!lastCabinet.isCarryOver) {
                if (!lastCabinet.isFloat) {
                    drawCabinet.draw(HawkContext.IMAGE_RESIZE, tag);
                }
                lastCabinet = drawCabinet = lastCabinet.nextAll;
            } else {
                lastCabinet = lastCabinet.nextAll;
            }
        }
        this.drawCabinet = drawCabinet;
    }

    /**
     * ꥽ޤ
     */
    public void dispose() {
        Cabinet cabinet = topCabinet;
        Canvas  canvas;
        while (cabinet != null) {
            canvas = cabinet.canvas;
            if (canvas != null) {
                canvas.dispose();
            }
            cabinet = cabinet.nextAll;
        }
    }

//### Cabinet
    /** ١֥åѤղþ */
    private final class Cabinet {
        private Block   block;
        private Canvas  canvas;
        private boolean isFloat;

        private int     drawBottom;         // ºݤ褵벼
        private int     drawLeft;           // ºݤ褵뺸
        private boolean isCarryOver;        // ؤ³Ƥ뤫

        private Cabinet prev;               // ľեȥӥͥå
        private Cabinet next;               // եȤ null
        private Cabinet prevAll;            // ӥͥåȥ
        private Cabinet nextAll;            // ӥͥåȥμ

        /** 󥹥󥹤 */
        private Cabinet(Block block) {
            this.block = block;
        }

        /** եѥ󥹥󥹤 */
        private Cabinet(FloatBlock block) {
            this.block   = block;
            this.isFloat = true;
        }

        /** 礭Ĵ */
        private void validate() {
            if (isFloat) {
                Cabinet cabinet = prevAll;
                int left = (cabinet.isFloat
                            ? cabinet.block.right
                            : cabinet.block.left);
                deployFloat((FloatBlock) block, left, top, bottom);
                isCarryOver = cabinet.isCarryOver;         // Υ֥å˽
                return;
            }

            // 礭Ĵ
            block.analyze(preferredHeight, preferredHeight);

            // 礭
            if (prev == null) {
                block.validate(preferredHeight, 0, 0, frame.top, 0, 0);
                drawLeft = block.drawLeft;
            } else {
                Block prevBlock = prev.block;
                block.validate(preferredHeight,
                               prevBlock.margin.left,
                               prevBlock.left,
                               frame.top,
                               0,
                               0);
                drawLeft = Math.max(block.drawLeft, prev.drawLeft);
            }

            // եȤˤ뽤
            if (floatManager != null) {
                drawLeft = Math.max(drawLeft, floatManager.getLeft());
            }

            drawBottom = block.bottom
                       + Math.max(block.drawBottom - block.bottom, frame.bottom);

            // ؤޤäƤ뤫å
            isCarryOver = (drawLeft > block.left);
            //### BUGS ʹߤΥ֥åΥޡξɤ롦
        }

        /**  */
        private void draw(int reason, int tag) {
            Cabinet cabinet;
            int right  = (prev == null ? 0 : prev.drawLeft);
            int left   = drawLeft;
            int height = this.drawBottom;

            //// Хι⤵
            // ³ƤϺΰ֤
            if (isCarryOver) {
                cabinet = next;
                for (;;) {
                    height = Math.max(height, cabinet.drawBottom);

                    if (!cabinet.isCarryOver) {
                        left = cabinet.drawLeft;
                        break;
                    }
                    cabinet = cabinet.next;
                }
            }

            // Х
            if (canvas == null) {
                canvas = new Canvas(drawkit, status,
                                    (prev != null ? prev.canvas : null),
                                    left - right, height,
                                    viewportWidth);
            } else {
                canvas.resize(left - right, height, viewportWidth);
            }
/*
if (canvas.g != null) {
if (++xxx % 2 == 0)
canvas.g.setColor(java.awt. Color.magenta);
else
canvas.g.setColor(java.awt. Color.pink);
canvas.g.drawRect(0, 0, canvas.width - 1, height - 1);
}
*/

            //// 
            int x = left;                   // Root а֤ Canvas ΰ֤㤦
            int y = 0;
//### BUGS Υޡ褦ˤʤС if Ϥʤ
if (canvas.g != null) {
            block.draw(canvas, x, y);
}
            // ³Ƥ³褷ΥХݤƤ
            if (isCarryOver) {
                Canvas lastCanvas = canvas;
                cabinet = next;
                for (;;) {
if (canvas.g != null) {
                    cabinet.block.draw(canvas, x, y);
}
                    if (cabinet.canvas == null) {
                        cabinet.canvas = lastCanvas = new Canvas(drawkit, status, lastCanvas, 0, 0, viewportWidth);
                    } else {
                        (lastCanvas = cabinet.canvas).resize(0, 0, viewportWidth);
                    }

                    if (!cabinet.isCarryOver) {
                        break;
                    }
                    cabinet = cabinet.next;
                }
            }

            //// եȤ
            if (floatDrawQueue != null) {
                while (!floatDrawQueue.isEmpty()) {
                    ((FloatBlock) floatDrawQueue.get()).draw(canvas, left, 0);
                }
            }

            //// Х򥳥ߥå
            canvas.commit(reason, tag);
            if (isCarryOver) {
                cabinet = next;
                for (;;) {
                    cabinet.canvas.commit(reason, tag);

                    if (!cabinet.isCarryOver) {
                        break;
                    }
                    cabinet = cabinet.next;
                }
            }
        }
    }

//### SpaceBlock
    /** 롼ȥ֥åκΥե졼ΤΥ֥å */
    private final class SpaceBlock extends Block {
        private Cabinet prevCabinet;

        /** 󥹥󥹤 */
        private SpaceBlock(Drawkit drawkit, Status status,
                           ContainerBlock container, Block parent,
                           Cabinet prevCabinet) {
            super(drawkit, status, container, parent);
            this.prevCabinet = prevCabinet;

            // ե졼ॵɬ 0
            this.frame       = new Insets(0, 0, 0, 0);
            this.frameWidth  = 0;
            this.frameHeight = 0;
        }

        /** {@inheritDoc} */
        public void analyze(int minParentHeight, int maxParentHeight) {
            maxHeight = minHeight = 1;
        }

        /** {@inheritDoc} */
        protected void calculateFrame(int parentHeight) {
            // ̵ʥե졼ॵ 0 
        }

        /** {@inheritDoc} */
        protected void layoutBlock(int newHeight, int containerX, int containerY) {
            // ǸΥ֥åꡢ˲ͤФƤ
            width      = (prevCabinet == null
                          ? RootBlock.this.frame.right
                          : Math.max(RootBlock.this.frame.left,
                                     prevCabinet.drawLeft - right));
            bottom     = top + newHeight;
            left       = right + width;
            drawTop    = top;
            drawRight  = right;
            drawBottom = bottom;
            drawLeft   = left;
        }

        /** {@inheritDoc} */
        protected void draw(Canvas canvas, int x, int y) {
            //### TODO BODY Υե졼
        }

        /** {@inheritDoc} */
        protected int getFrameHeight(int parentHeight) {
            // ̵ʥե졼ॵ 0 
            return 0;
        }
    }
}
