/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering.block;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.addin.StyleManager;
import net.hizlab.kagetaka.rendering.Canvas;
import net.hizlab.kagetaka.rendering.Constant;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.Value;

/**
 * ޡ֥åɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class MarkerBlock extends BasicBlock {
    private static final int UL_DISC_SIZE   = 6;           // UL ε礭
    private static final int UL_CIRCLE_SIZE = 6;           // UL ε礭
    private static final int UL_SQUARE_SIZE = 5;           // UL ε礭
    private static String listTerminate;

    static {
        listTerminate = Resource.getMessage("chars.value.list.1", null);
    }

    private int drawOffsetX;                // եå

    /**
     * ޡ֥åޤ
     *
     * @param  drawkit   ɥå
     * @param  status    ơ
     * @param  parent    ƥ֥å
     */
    protected MarkerBlock(Drawkit drawkit, Status status, Block parent) {
        super(drawkit, status, null, parent);
    }

    /** {@inheritDoc} */
    public Block commitBlock() {
        int type = status.getList();

        switch (type) {
        case Value.NONE: // ̵
        case Value.LIST_DISC: // 
        case Value.LIST_CIRCLE: // 
        case Value.LIST_SQUARE: // ͳ
            break;
        default:
            StringBuffer buffer = new StringBuffer();
            int no = status.counterStatus.counterNo;

            switch (type) {
            case Value.LIST_DECIMAL_LEADING_ZERO: // 0 դʿ
                if (no < 10) {
                    buffer.append('0');
                }
                buffer.append(no);
                buffer.append(listTerminate);
                break;
            case Value.LIST_LOWER_ROMAN: // ʸΥ޿ i,ii,iii,iv,v, ...
            case Value.LIST_UPPER_ROMAN: // ʸΥ޿ I,II,III,IV,V, ...
                if (no >= 5000) {
                    buffer.append(no);
                } else {
                    int column = 0;
                    char[] list = null;
                    if (type == Value.LIST_LOWER_ROMAN) {
                        list = new char[]{'i', 'v', 'x', 'l', 'c', 'd', 'm', '?', '?'};
                    } else {
                        list = new char[]{'I', 'V', 'X', 'L', 'C', 'D', 'M', '?', '?'};
                    }
                    char c1, c5, c10;

                    if (no <= 0) {
                        no = 1;
                    }
                    while (no > 0 && column < 7) {
                        c1  = list[column];
                        c5  = list[column + 1];
                        c10 = list[column + 2];
                        switch (no % 10) {
                        case 1: buffer.append( c1); break;
                        case 2: buffer.append( c1);
                                buffer.append( c1); break;
                        case 3: buffer.append( c1);
                                buffer.append( c1);
                                buffer.append( c1); break;
                        case 4: buffer.append( c5);
                                buffer.append( c1); break;
                        case 5: buffer.append( c5); break;
                        case 6: buffer.append( c1);
                                buffer.append( c5); break;
                        case 7: buffer.append( c1);
                                buffer.append( c1);
                                buffer.append( c5); break;
                        case 8: buffer.append( c1);
                                buffer.append( c1);
                                buffer.append( c1);
                                buffer.append( c5); break;
                        case 9: buffer.append(c10);
                                buffer.append( c1); break;
                        default: // AVOID
                        }
                        no = no / 10;
                        column += 2;
                    }
                    buffer.reverse();
                }
                buffer.append(listTerminate);
                break;
            case Value.LIST_LOWER_LATIN:
            case Value.LIST_UPPER_LATIN:
            case Value.LIST_LOWER_ALPHA:
            case Value.LIST_UPPER_ALPHA:
            {
                if (no <= 0) {
                    no = 1;
                }
                boolean lower = (type == Value.LIST_LOWER_LATIN
                              || type == Value.LIST_LOWER_ALPHA);
                while (no > 0) {
                    buffer.append((char) (((no % 26) - 1) + (lower ? 'a' : 'A')));
                    no = no / 26;
                }
                buffer.reverse();
                buffer.append(listTerminate);

                break;
            }
            case Value.LIST_DECIMAL: // ʿ
                buffer.append(no);
                break;
            default: // ʳ
                String s = StyleManager.getListCounter(type, no);
                if (s != null) {
                    buffer.append(s);
                } else {
                    buffer.append(no);
                    buffer.append(listTerminate);
                }
            }

            appendString(buffer.toString());
            status.counterStatus.counterNo++;
        }

        return super.commitBlock();
    }

    /** {@inheritDoc} */
    protected void layoutBlock(int newHeight, int containerX, int containerY) {
        super.layoutBlock(newHeight, containerX, containerY);

        int w = ((status.lineHeight != null
               && status.lineHeight.getType() != Value.TYPE_KEY_NORMAL)
                 ? status.lineHeight.getValue(status.fontFullSize.width,
                                              status.fontFullSize.width,
                                              status.fontData,
                                              Value.DATA_HORIZONTAL)
                 : (int) Math.round(status.fontFullSize.width * Constant.LINE_HEIGHT));

        switch (status.getList()) {
        case Value.LIST_DISC: // 
        case Value.LIST_CIRCLE: // 
        case Value.LIST_SQUARE: // ͳ
            this.contentHeight = status.fontFullSize.height;
            break;
        default:
            this.drawOffsetX = (w - this.width) / 2;
        }

        this.width      = w;
        this.bottom     = this.top + this.height;
        this.left       = this.right + this.width;
        this.drawTop    = this.top;
        this.drawRight  = this.right;
        this.drawBottom = this.bottom;
        this.drawLeft   = this.left;
    }

    /** {@inheritDoc} */
    protected void draw(Canvas canvas, int x, int y) {
        super.draw(canvas, x - drawOffsetX, y);
    }

    /** {@inheritDoc} */
    protected void drawContent(Canvas canvas, int x, int y) {
        Status status = this.status;

        // ξ algin θ
        y += height - contentHeight;

        canvas.g.setColor(status.foreColor);

        switch (status.getList()) {
        case Value.NONE: // ̵
            break;
        case Value.LIST_DISC: // 
            canvas.g.fillOval(x - ((status.fontFullSize.width  + UL_DISC_SIZE) / 2),
                              y + ((status.fontFullSize.height - UL_DISC_SIZE) / 2),
                              UL_DISC_SIZE, UL_DISC_SIZE);
            break;
        case Value.LIST_CIRCLE: // 
            canvas.g.drawOval(x - ((status.fontFullSize.width  + UL_CIRCLE_SIZE) / 2),
                              y + ((status.fontFullSize.height - UL_CIRCLE_SIZE) / 2),
                              UL_CIRCLE_SIZE, UL_CIRCLE_SIZE);
            break;
        case Value.LIST_SQUARE: // ͳ
            canvas.g.fillRect(x - ((status.fontFullSize.width  + UL_SQUARE_SIZE) / 2),
                              y + ((status.fontFullSize.height - UL_SQUARE_SIZE) / 2),
                              UL_SQUARE_SIZE, UL_SQUARE_SIZE);
            break;
        default:
            super.drawContent(canvas, x, y);
        }
    }
}
