/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering.block;

import net.hizlab.kagetaka.rendering.Canvas;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.Value;

import java.awt.Insets;

/**
 * ޡ֥å֥̾å֥ͭåɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public class MarkedBlock extends Block {
    private MarkerBlock markerBlock;

    /**
     * ޡ֥å֥̾å֥ͭåޤ
     *
     * @param  drawkit      ɥå
     * @param  status       ơ
     * @param  container    ƥʥ֥å
     *                      եȤαƶʤ <code>null</code>
     * @param  parent       ƥ֥å
     * @param  markerStatus ޡơ
     */
    protected MarkedBlock(Drawkit drawkit, Status status,
                          ContainerBlock container, Block parent,
                          Status markerStatus) {
        super(drawkit, status, container, parent);


        // ᥤ֥å
        defaultBlock = createBlockInternal(status, null);
        defaultBlock.isAdoptee = true;
        contents.addElement(defaultBlock);

        // ޡ֥å
        boolean isInline;
        //### TODO  Style ꤹ٤
        //  white-space: nowrap + width: 3em ǤϤʤ min-width: 3em ˤ٤
        markerStatus.align      = Value.ALIGN_RIGHT;
        markerStatus.whiteSpace = Value.WHITESPACE_NOWRAP;
        markerStatus.lineHeight = null;
        if ((isInline = (markerStatus.getListLevel() == 0))) {
            markerStatus.setList(Value.LIST_DISC);
            markerStatus.height = new Value(1, Value.UNIT_EM);
        } else {
            markerStatus.height = new Value(3, Value.UNIT_EM);
            markerStatus.setMargin(Status.TARGET_BOTTOM, new Value(5, Value.UNIT_PX));
        }
//markerStatus.setBorderWidth(Status.TARGET_ALL, new Value(1, Value.UNIT_PX));
//markerStatus.setBorderColor(Status.TARGET_ALL, java.awt. Color.cyan);

        // ޡ
        markerBlock = new MarkerBlock(drawkit, markerStatus, this);
        markerBlock.commitBlock();
        markerBlock.analyze(Integer.MAX_VALUE, Integer.MAX_VALUE);

        // 饤ξ
        if (isInline) {
            markerBlock.validate(markerBlock.minHeight, 0, 0, 0, 0, 0);
            appendBlock(markerBlock);
            markerBlock = null;
        }
    }

    /** {@inheritDoc} */
    protected void calculatePreferred() {
        preferredWidth  = SIZE_AUTO;
        preferredHeight = SIZE_AUTO;
    }

    /** {@inheritDoc} */
    public Block createBlock(Status status, Status markerStatus) {
        return defaultBlock.createBlock(status, markerStatus);
    }

    /** {@inheritDoc} */
    public Block commitBlock() {
        defaultBlock.commitBlock();

        return super.commitBlock();
    }

    /** {@inheritDoc} */
    public void analyze(int minParentHeight, int maxParentHeight) {
        defaultBlock.analyze(minParentHeight, maxParentHeight);
        this.minHeight = defaultBlock.minHeight;
        this.maxHeight = defaultBlock.maxHeight;
    }

    /** {@inheritDoc} */
    protected void calculateFrame(int parentHeight) {
        // ե졼̵
        if (frame == null) {
            frame = new Insets(0, 0, 0, 0);
        }
    }

    /** {@inheritDoc} */
    protected void layoutBlock(int newHeight, int containerX, int containerY) {
//Debug.out.println(this + ":MarkedBlock.layoutBlock: " + newHeight + "," + minHeight + "," + maxHeight);

        Block block;

        defaultBlock.validate(newHeight, 0, 0, 0, containerX, containerY);
        Line line = defaultBlock.getFirstLine();

        // ޡ
        if (markerBlock != null) {
            block =  markerBlock;
            int h =  block.maxHeight;
            h     += block.getFrameHeight(h);
            block.validate(h, 0,
                           (line != null ? line.right : 0),
                           defaultBlock.top + defaultBlock.margin.top - h,
                           containerX, containerY);
        }

        // ֥åΤ礭
        block = defaultBlock;
        this.width      = block.width;
        this.bottom     = this.top + block.bottom;
        this.left       = this.right + block.left;
        this.drawTop    = this.top;
        this.drawRight  = this.right;
        this.drawBottom = this.bottom;
        this.drawLeft   = this.left;
    }

    /** {@inheritDoc} */
    protected void drawBackground(Canvas canvas, int x, int y) {
        // ̵
    }

    /** {@inheritDoc} */
    protected void drawBorder(Canvas canvas, int x, int y) {
        // ̵
    }

    /** {@inheritDoc} */
    protected void drawContent(Canvas canvas, int x, int y) {
        super.drawContent(canvas, x, y);

        // ޡ
        if (markerBlock != null) {
            markerBlock.draw(canvas, x, y);
        }
    }

//### 
    /** {@inheritDoc} */
    protected void ensureDefaultBlock() {
        // ̵
    }

    /** {@inheritDoc} */
    protected void commitDefaultBlock() {
        // ̵
    }

//### Utils
    /** {@inheritDoc} */
    protected int getFrameHeight(int parentHeight) {
        return 0;
    }

    /** {@inheritDoc} */
    public int getMargin(int parentHeight, int sense) {
        return defaultBlock.getMargin(parentHeight, sense);
    }
}
