/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering.block;

import net.fclabs.util.Queue;
import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.IntBuffer;

/**
 * ιԾݻ륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public class Lines {
    private Block parent;                   // ƥ֥å
    private int   blockAlign;               // ʸ·
    private int   blockIndent;              // ǽιԤΥǥ
    private int   blockHeight;              // ޥ֥åι⤵

    // ׾
    int totalWidth;
    int totalHeight;

    // Ծ
    private int       length;                              // Կ
    private IntBuffer widthList  = new IntBuffer();        // 
    private IntBuffer heightList = new IntBuffer();        // ⤵
    private IntBuffer moveList   = new IntBuffer();        // ˰ư
    private IntBuffer topList    = new IntBuffer();        // Ԥγϰ

    // ߹ԤξʥߥåȻ˽
    private int width;                      // Ԥȡ¦Υڡޤ᤿
    private int height;
    private int left;                       // ¦ͤȴ
    // ߹ԤξmoveNext ǽ
    private int move;                       // Ԥ鸽߹Ԥؤκؤΰư
    private int top;                        // եȤͽ󤵤Ƥ¦ι⤵
    private int odd;                        // ߹ԤλĤ

    private int   indent;                   // ߹ԤΥǥ
    private Queue floatQueue;               // եȥ塼

    // եȾ
    private FloatManager floatManager;
    private boolean      hasFloat;
    private int          containerRight;
    private int          containerTop;
    private int          containerBottom;

    // 
    private int drawIndex;
    private int drawY;

    // ¸
    private int saveDrawIndex;
    private int saveX;
    private int saveY;

    // ־
    /**  X  */
    public int x;
    /**  Y  */
    public int y;

    /**
     * Ծʪޤ
     *
     * @param parent ƥ֥å
     * @param align  ʸ·
     * @param indent ǽιԤΥǥ
     */
    public Lines(Block parent, int align, int indent) {
        this.parent = parent;
        blockAlign  = align;
        blockIndent = indent;
    }

    /**
     * Ծ򥯥ꥢޤ
     */
    public void clear() {
        totalWidth  = 0;
        totalHeight = 0;
        if (floatQueue != null) {
            floatQueue.clear();
        }

        length = 0;
        widthList .clear();
        heightList.clear();
        moveList  .clear();
        topList   .clear();

        width  = 0;
        height = 0;
        left   = 0;

        move   = 0;
        top    = 0;
        odd    = 0;
    }

//### Ծɲû
    /**
     * ԾɲäǤ褦˥åȥåפޤ
     *
     * @param  blockHeight Ԥޥ֥åι⤵
     * @param  containerX  ƥʥ֥å鼫֥åФ X
     * @param  containerY  ƥʥ֥å鼫֥åФ Y
     */
    public void setup(int blockHeight, int containerX, int containerY) {
        this.blockHeight     = blockHeight;
        this.floatManager    = (parent.container != null ? parent.container.floatManager : null);
        this.hasFloat        = (floatManager != null);
        this.containerRight  = containerX;
        this.containerTop    = containerY;
        this.containerBottom = containerY + blockHeight;

        // ǥȤ
        indent = blockIndent;
    }

    /**
     * ԤɲäǤ褦˽ޤ
     * Υ᥽åɤƤӽФ硢ɬ
     * {@link #append(int, int, int, int)} ƤӽФʤȤޤ
     *
     * @param  nextHeight Ԥκι⤵
     *
     * @return ԤλĤι⤵
     */
    int reserve(int nextHeight) {
        if (odd >= nextHeight) {
            return odd;
        }

        // ɲäǤʤϥߥåȤɲäǤ֤ذư
        if (height > 0 || width > 0) {
            // ߤιԾ򥳥ߥå
            commitLine();

            // ιԤΰ֤ذư
            moveNext(nextHeight, this.left);

            // ߤιԾ򥯥ꥢ
            this.width  = 0;
            this.height = 0;
            this.left   = 0;
        } else {
            // ιԤΰ֤ذư
            moveNext(nextHeight + indent, 0);

            // ǥʬĴ
            if (indent > 0) {
                top    += indent;
                odd    -= indent;
                indent =  0;
            }
        }

        return odd;
    }

    /**
     * Ծɲäꤷޤ
     *
     * @param  width      
     * @param  height     ⤵
     * @param  left       ͤФ
     * @param  nextHeight Ԥκι⤵
     *
     * @return ԤλĤι⤵
     */
    int append(int width, int height, int left, int nextHeight) {
        // top 
        int top;
        switch (blockAlign) {
        case Value.ALIGN_CENTER: top = this.top + (this.odd - height) / 2; break;
        case Value.ALIGN_RIGHT : top = this.top + (this.odd - height)    ; break;
        default                : top = this.top;
        }

        // ͤ˽
        width  =  Math.max(this.width, width);
        height += this.height;
        left   =  Math.max(this.left , left );

        // ߤιԾ򥳥ߥå
        widthList .append(width       );
        heightList.append(height      );
        moveList  .append(move + width);
        topList   .append(top         );
        length++;

        totalWidth  += move + width;
        totalHeight =  Math.max(totalHeight, height);

        // եȤ
        commitFloat();

        // ιԤΰ֤ذư
        moveNext(nextHeight, left);

        // ߤιԾ򥯥ꥢ
        this.width  = 0;
        this.height = 0;
        this.left   = 0;

        return odd;
    }

    /**
     * ԾɲäޤϤޤ
     *
     * @param  width      
     * @param  height     ⤵
     * @param  left       ͤФ
     */
    void append(int width, int height, int left) {
        this.width  =  Math.max(this.width, width);
        this.height += height;
        this.left   =  Math.max(this.left , left );
        odd -= height;
    }

    /**
     * եȥ֥åɲäޤ
     *
     * @param  block   ֥å
     * @param  current ¤긽߹Ԥɲä <code>true</code>
     *                 ιԤɲä <code>false</code>
     */
    void append(FloatBlock block, boolean current) {
        if (current && height == 0 && width == 0) {
            parent.container.deployFloat(block,
                                         containerRight + totalWidth,
                                         containerTop,
                                         containerBottom);
            // ߤιԤ odd 
            moveNext(0, 0);
        } else {
            if (floatQueue == null) {
                floatQueue = new Queue();
            }
            floatQueue.put(block);
        }
    }

    /** ߤιԤ */
    private void commitLine() {
        // top 
        int top;
        switch (blockAlign) {
        case Value.ALIGN_CENTER: top = this.top + odd / 2; break;
        case Value.ALIGN_RIGHT : top = this.top + odd    ; break;
        default                : top = this.top;
        }

        // ߤιԾ򥳥ߥå
        widthList .append(width       );
        heightList.append(height      );
        moveList  .append(move + width);
        topList   .append(top         );
        length++;

        totalWidth  += move + width;
        totalHeight =  Math.max(totalHeight, height);

        // եȤ
        commitFloat();
    }

    /** եȤ */
    private void commitFloat() {
        if (floatQueue != null) {
            while (!floatQueue.isEmpty()) {
                parent.container.deployFloat((FloatBlock) floatQueue.get(),
                                             containerRight + totalWidth,
                                             containerTop,
                                             containerBottom);
            }
        }
    }

    /** ιԤΰ֤ذưmove, odd, top  */
    private void moveNext(int nextHeight, int left) {
        int right;

        move = left;
        if (hasFloat
                && floatManager.move(nextHeight,
                                     (right = containerRight + totalWidth),
                                     containerTop,
                                     containerBottom)) {
            FloatManager.Trench t = floatManager.current;
            move += (t.right > right ? t.right - right : 0);
            top  =  Math.max(t.top - containerTop, 0);
            odd  =  Math.min(containerBottom, t.bottom) - Math.max(containerTop, t.top);
//Debug.out.println("> line="+right+","+move+","+top+","+odd+","+t.top+","+t.bottom+","+containerTop+","+containerBottom+","+blockHeight+","+containerRight);
        } else {
            top = 0;
            odd = blockHeight;
        }
    }

    /**
     * Ծꤷޤ
     */
    void commit() {
        if (height > 0 || width > 0) {
            commitLine();
        } else if (floatQueue != null && !floatQueue.isEmpty()) {
            commitFloat();
        }
        totalWidth += left;
    }

//### 
    /**
     * ԤǤ褦˥åȥåפޤ
     *
     * @param  x 夫 X
     * @param  y 夫 Y
     */
    void setup(int x, int y) {
        drawIndex = 0;
        drawY     = y;
        this.x = x - moveList.get(0);
        this.y = y + topList .get(0);
    }

    /**
     * θ߹Ԥޤ
     * <!-- Τˤ moveList  width + move ʤΤʤ
     *      ID ΰַѤƤΤʤ -->
     *
     * @return ߹Ԥʾ
     */
    int getWidth() {
        return moveList.get(drawIndex);
    }

    /**
     * θ߹Ԥι⤵ޤ
     *
     * @return ߹Ԥι⤵
     */
    int getHeight() {
        return heightList.get(drawIndex) - y + drawY + topList.get(drawIndex);
    }

    /**
     * ˲ԤԤ{@link #x}{@link #y} ưޤ
     *
     * @return Ԥι⤵
     */
    int newLine() {
if (drawIndex >= length) {
Debug.out.println("## Postion.newLine: what ?? [" + drawIndex + "," + length + "]");
}
        int index;
        if ((index = ++drawIndex) >= length) {
            return Integer.MAX_VALUE - y;
        }

        // ֤
        x -= moveList.get(index);
        y =  drawY + topList.get(index);

        return heightList.get(index);
    }

    /**
     * ΰ֤¸ޤ
     */
    public void saveDrawPosition() {
        saveDrawIndex = drawIndex;
        saveX         = x;
        saveY         = y;
    }

    /**
     * ΰ֤¸֤ᤷޤ
     */
    public void rollbackDrawPosition() {
        drawIndex = saveDrawIndex;
        x         = saveX;
        y         = saveY;
    }

//### ¾
    /**
     * Ծ֤ޤ
     *
     * @param  num ֹ
     *
     * @return Ծ
     *         ꤵ줿ֹ椬¸ߤʤ <code>null</code>
     */
    public Line getLine(int num) {
        try {
            int w = widthList.get(num);
            return new Line(w, moveList.get(num) - w);
        } catch (IndexOutOfBoundsException e) {
            return null;
        }
    }
}
