/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering.block;

import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.Value;

/**
 * Ūʥ֥åǤɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public class HrBlock extends Block {
    /**
     * Ūʥ֥åޤ
     *
     * @param  drawkit   ɥå
     * @param  status    ơ
     * @param  container ƥʥ֥å
     *                   եȤαƶʤ <code>null</code>
     * @param  parent    ƥ֥å
     */
    protected HrBlock(Drawkit drawkit, Status status,
                      ContainerBlock container, Block parent) {
        super(drawkit, status, container, parent);
    }

    /** {@inheritDoc} */
    public void analyze(int minParentHeight, int maxParentHeight) {
        minHeight = maxHeight = 1;
    }

    /** {@inheritDoc} */
    public void validate(int parentHeight, int prevLeftMargin, int x, int y,
                         int containerX, int containerY) {
//Debug.out.println(this + ":HrBlock.validate: " + parentHeight + "," + prevLeftMargin + "," + offsetX + "," + y + "," + minHeight + "," + maxHeight);

        /*
         * HR ι⤵<hr width="n%" />ˤϡޥ֥åФ륵
         * ̾Υ֥åȤϰ㤤ܡޤޤ줿 % λˤʤ롣
         */

        // ե졼򻻽
        calculateFrame(parentHeight);
        // ޡǤä
        this.right = (prevLeftMargin != 0
                      ? x + getMarginOffset(prevLeftMargin, margin.right)
                      : x);
        this.top   = y;

        // եȤ򤱤
        FloatManager floatManager = container.floatManager;
        int allX = containerX + this.right;
        int allY = containerY + this.top;
        if (floatManager != null
                && floatManager.move((preferredHeight >= 0 ? preferredHeight : 1),
                                     allX,
                                     allY,
                                     allY + parentHeight)) {
            FloatManager.Trench t = floatManager.current;
            parentHeight = t.bottom - t.top;
            this.right += (t.right > allX ? t.right - allX : 0);
        }

        // ι⤵׻
        int newHeight;
        int oddHeight;
        switch (preferredHeight) {
        case SIZE_AUTO:
            newHeight = parentHeight - frameHeight;
            oddHeight = 0;
            break;
        case SIZE_PERCENT:
            newHeight = parentHeight - frameHeight;
            int per = (newHeight * status.height.getNumber().intValue()) / 100;
            oddHeight = newHeight - per;
            newHeight = per;
            break;
        default:
            newHeight = preferredHeight;
            oddHeight = parentHeight - newHeight;
        }

        /*
         * HR  align  HR ʪ̵ˤǤϤʤʬȤ֤
         * ꤹΤǤ롣align="right" ξ硢"ʬ" 򲼤
         * 󤻤ʤȤʤΥȥϡtop Ĵ᤹뤳Ȥ
         * Ԥʱξˡ
         */

        if (oddHeight > 0) {
            switch (status.align) {
            case Value.ALIGN_CENTER: top += (oddHeight) / 2; break;
            case Value.ALIGN_RIGHT : top += (oddHeight)    ; break;
            default: // AVOID
            }
        }

        // ⤵¸
        this.width      = preferredWidth;
        this.height     = newHeight;
        this.bottom     = top   + height + frameHeight;
        this.left       = right + width  + frameWidth;
        this.drawTop    = top;
        this.drawRight  = right;
        this.drawBottom = bottom;
        this.drawLeft   = left;
//Debug.out.println(this + ":HrBlock.validate2: " + width + "x" + height + ", " + top + "," + right + "," + bottom + "," + left);
    }
}
