/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering.block;

import net.hizlab.kagetaka.token.Value;

/**
 * եȾݻޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.5 $
 */
public class FloatManager {
    /** ֤߰Υե */
    Trench current;

    private Trench top;
    private Trench last;

    /**
     * 󥹥󥹤ޤ
     *
     * @param  top    եȤ֤Ǥդξ夫εΥ
     * @param  bottom եȤ֤Ǥ벼դξ夫εΥ
     */
    public FloatManager(int top, int bottom) {
        this.current = this.top = this.last = new Trench(true, 0, top, bottom);
    }

    /**
     * եȥ˿եȤɲäޤ
     *
     * @param  block  եȥ֥å
     * @param  right  ֤Ǥ뱦դαεΥ
     * @param  top    ֤Ǥդξ夫εΥ
     * @param  bottom ֤Ǥ벼դξ夫εΥ
     */
    void add(FloatBlock block, int right, int top, int bottom) {
        int height = bottom - top;
        // 
        block.analyze(0, height);
        height = Math.min(block.maxHeight, height);

        boolean isTop = (block.status.floatType == Value.FLOAT_LEFT);
        Trench  t = last;
//Debug.out.println("> add="+right+","+isTop+","+height+","+top+","+bottom);

        if (bottom - top > height) {
            // ƬФ򤹤
            for (;;) {
//Debug.out.println("> check="+Math.min(t.bottom, bottom)+"-"+Math.max(t.top, top)+"<"+height);
                if (Math.min(t.bottom, bottom) - Math.max(t.top, top) < height) {
                    if (t.next != null) {
                        t = t.next;
                    }
                    break;
                }

                // ǸΥեȤγϰ֤걦¦ƤϤʤ
                if (t.right <= right || t.isStart) {
                    break;
                }

                t = t.prev;
            }
        }

        right = Math.max(right, t.right);
//Debug.out.println("> add2="+right+","+t.right+","+t.top+","+t.bottom);

        int y1, y2;
        if (isTop) {
            y1 = Math.max(top, t.top);
            y2 = y1 + height;
        } else {
            y1 = y2 = Math.min(bottom, t.bottom) - height;
        }

        block.validate(height, 0, right, y1, 0, 0);

        // ֤ɲ
        t.append(isTop, right, y2, block.left);

        // ֤߰ư
        // ɬ t  current Ϥǡcurrent 
        // Ǹɲä줿ȤǤäƤϤʤ
        current = t;
    }

    /**
     * 礭õ{@link #current} ꤷޤ
     * եȤ¸ߤʤ <code>false</code> ֤ޤ
     *
     * @param  height ֤⤵
     * @param  right  ֤Ǥ뱦դαεΥ
     * @param  top    ֤Ǥդξ夫εΥ
     * @param  bottom ֤Ǥ벼դξ夫εΥ
     *
     * @return եȤ¸ߤ <code>true</code>
     *         ¸ߤʤ <code>false</code>
     */
    boolean move(int height, int right, int top, int bottom) {
        Trench t = current;

        if (t == last) {
            return false;
        }

        // ƬФ
        while (t.next.right <= right) {
            t = t.next;
            if (t.next == null) {
                current = last;
                return false;
            }
        }

        // 礭ޤǰư
        while (Math.min(t.bottom, bottom) - Math.max(t.top, top) < height) {
            if ((t = t.next) == null) {
                // ޤǰưƥեȤ¸ߤʤ
                current = last;
                return true;
            }
        }

        current = t;
        return true;
    }

    /**
     * ֤ΥեȤ礭֤ޤ
     *
     * @param  right  Ĵ٤뱦դαεΥ
     *
     * @return եȤ礭
     */
    Trench get(int right) {
        Trench t = last;

        while (t.right > right) {
            t = t.prev;
        }

        return t;
    }

    /**
     * ǸΥեȤλ֤֤ޤ
     *
     * @return ǸΥեȤλ
     */
    int getLeft() {
/*
Trench t = top;
do {
Debug.out.println("float> " + t.right + "," + t.top + "," + t.bottom);
} while ((t = t.next) != null);
*/
        return last.right;
    }

//### Trench
    /**
     * եȥ
     */
    public final class Trench {
        private boolean isStart;

        /** ƥʤααդΰ */
        int right;
        /** ƥʤξ夫ξդΰ */
        public int top;
        /** ƥʤξ夫βդΰ */
        public int bottom;

        private Trench next;
        private Trench prev;

        /** 󥹥󥹤 */
        private Trench(boolean isStart, int right, int top, int bottom) {
            this.isStart = isStart;
            this.right   = right;
            this.top     = top;
            this.bottom  = bottom;
        }

        /** ΥμˡեȾɲä */
        private void append(boolean isTop, int right, int y, int left) {
            Trench t;
            int top    = this.top;
            int bottom = this.bottom;
//Debug.out.println("> append ["+isTop+","+right+","+(isTop?y:top)+","+(isTop?bottom:y)+"]..>"+left);

            if (right == this.right) {
                // Ʊ֤ɲä줿
                if (isTop) {
                    this.top    = y;
                } else {
                    this.bottom = y;
                }
                t = this;
                this.isStart = true;
            } else {
                if (isTop) {
                    t = appendTrench(true, right, y  , bottom);
                } else {
                    t = appendTrench(true, right, top, y     );
                }
            }

            // ϰ֤䡢֤˲̵
            if (t.next == null || t.next.right > left) {
                t.appendTrench(false, left, top, bottom);
                return;
            }

            // top, bottom 򸽺ߤΰ֤ꤹ
            if (isTop) {
                top    = t.top;
            } else {
                bottom = t.bottom;
            }

            // λ֤򸡺
            do {
                t = t.next;
//Debug.out.println("# "+left+","+t.right+","+t.top+","+t.bottom);
                if (t.right == left) {
                    return;
                }
                // λ֤ޤǤ Trench ʤ餹
                if (t.right < left) {
                    if (t.next == null) {
                        if (isTop) {
                            if (bottom  != t.bottom) {
                                bottom   = t.bottom;
                                int n = t.top;
                                t.top    = top;
                                top      = n;
                                break;
                            }
                        } else {
                            if (top     != t.top   ) {
                                top      = t.top;
                                int n = t.bottom;
                                t.bottom = bottom;
                                bottom   = n;
                                break;
                            }
                        }
                        t.right = left;
                        return;
                    }
                    if (isTop) {
                        if (bottom  != t.bottom) {
                            bottom   = t.bottom;
                            t.top    = top;
                            continue;
                        }
                    } else {
                        if (top     != t.top   ) {
                            top      = t.top;
                            t.bottom = bottom;
                            continue;
                        }
                    }
                    top    = t.top;
                    bottom = t.bottom;
                    // t 
                    t.prev.next = t.next;
                    t.next.prev = t.prev;
                    t.next = t.prev = null;
                } else {
                    t = t.prev;
                    break;
                }
            } while (t.next != null);

            // λ֤ɲ
            t.appendTrench(false, left, top, bottom);
        }

        /** Υμˡɲä */
        private Trench appendTrench(boolean isStart, int right, int top, int bottom) {
            Trench t = new Trench(isStart, right, top, bottom);

            if (next != null) {
                next.prev = t;
                t.next    = next;
            }
            t.prev = this;
            next   = t;

            if (last == this) {
                last = t;
            }

            return t;
        }
    }
}
