/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering.block;

import net.hizlab.kagetaka.rendering.Canvas;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.Value;

import java.awt.Insets;

/**
 * եȥ֥åɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.7 $
 */
public class FloatBlock extends ContainerBlock {
    /** ֥åΤեȤ򤱤ɬפ뤫ɤ */
    public boolean avertFloat;

    private Value statusHeight;

    /**
     * եȥ֥å֥ͭåޤ
     *
     * @param  drawkit      ɥå
     * @param  status       ơ
     * @param  parent       ƥ֥å
     * @param  markerStatus ޡơ
     */
    protected FloatBlock(Drawkit drawkit, Status status,
                         Block parent, Status markerStatus) {
        super(drawkit, status, parent);

        statusHeight  = status.height;
        status.height = null;

        defaultBlock = createBlockInternal(status, markerStatus);
        defaultBlock.isAdoptee = true;

        avertFloat = (status.display == Value.DISPLAY_TABLE);
    }

    /** {@inheritDoc} */
    protected void calculatePreferred() {
        preferredWidth  = SIZE_AUTO;
        preferredHeight = SIZE_AUTO;
    }

    /** {@inheritDoc} */
    public Block createBlock(Status status, Status markerStatus) {
        return defaultBlock.createBlock(status, markerStatus);
    }

    /** {@inheritDoc} */
    public Block commitBlock() {
        defaultBlock.commitBlock();

        return super.commitBlock();
    }

    /** {@inheritDoc} */
    public void analyze(int minParentHeight, int maxParentHeight) {
        defaultBlock.analyze(minParentHeight, maxParentHeight);
        this.minHeight = defaultBlock.minHeight;
        this.maxHeight = defaultBlock.maxHeight;

        Value height = statusHeight;
        if (height != null) {
            if (height.getUnit() == Value.UNIT_PERCENT) {
                maxHeight = Math.max(minHeight,
                                     (maxParentHeight * height.getNumber().intValue()) / 100);
            } else {
                maxHeight = Math.max(minHeight,
                                     height.getValue(1, 0,
                                                     status.fontData,
                                                     Value.DATA_VERTICAL));
            }
            defaultBlock.maxHeight = maxHeight;
        }
    }

    /** {@inheritDoc} */
    protected void calculateFrame(int parentHeight) {
        // ե졼̵
        if (frame == null) {
            frame = new Insets(0, 0, 0, 0);
        }
    }

    /** {@inheritDoc} */
    public void validate(int parentHeight, int prevLeftMargin, int x, int y,
                         int containerX, int containerY) {
//Debug.out.println(this + ":FloatBlock.validate: " + parentHeight + "," + prevLeftMargin + "," + x + "," + y + "," + minHeight + "," + maxHeight);

        // եȥޥ͡
        if (floatBlocks != null) {
            floatManager = new FloatManager(0, parentHeight);
        }

        // ե졼򻻽
        calculateFrame(parentHeight);

        // ΰַ
        this.top   = y;
        this.right = x;

        Block block = defaultBlock;

        // եȤľ˥եȤϤꤨʤ
        block.validate(parentHeight, 0, 0, 0, 0, 0);

        // ֥åΤ礭
        this.width      = block.width;
        this.bottom     = this.top + block.bottom;
        this.left       = this.right + block.left;
        this.drawTop    = this.top;
        this.drawRight  = this.right;
        this.drawBottom = this.bottom;
        this.drawLeft   = this.left;

        // եȤäƤ硢եȤ꤭褦礭Ĵ
        adjustInnerFloat();
    }

    /** {@inheritDoc} */
    protected void drawBackground(Canvas canvas, int x, int y) {
        // ̵
    }

    /** {@inheritDoc} */
    protected void drawBorder(Canvas canvas, int x, int y) {
        // ̵
    }

    /** {@inheritDoc} */
    protected void drawContent(Canvas canvas, int x, int y) {
        defaultBlock.draw(canvas, x, y);
    }

//### 
    /** {@inheritDoc} */
    protected void ensureDefaultBlock() {
        // ̵
    }

    /** {@inheritDoc} */
    protected void commitDefaultBlock() {
        // ̵
    }

//### Utils
    /** {@inheritDoc} */
    protected int getFrameHeight(int parentHeight) {
        return 0;
    }

    /** {@inheritDoc} */
    public int getMargin(int parentHeight, int sense) {
        // եƱΤϥޡǤä򤷤ʤ
        return 0;
    }
}
