/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering.block;

import net.hizlab.kagetaka.rendering.Canvas;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.Status;

import java.util.Vector;

/**
 * ƥʥ֥åʥ롼ȡTDեȡˤɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public abstract class ContainerBlock extends BasicBlock {
    /** եȥ֥å */
    protected Vector       floatBlocks;
    /** եȥޥ͡ */
    protected FloatManager floatManager;

    /**
     * ƥʥ֥åޤ
     *
v     * @param  drawkit   ɥå
     * @param  status    ơ
     * @param  parent    ƥ֥å
     */
    protected ContainerBlock(Drawkit drawkit, Status status,
                             Block parent) {
        super(drawkit, status, null, parent);
        this.container = this;
    }

    /**
     * եȤäƤ硢եȤ꤭褦ˡ
     * {@link #width}{@link #left}{@link #drawLeft} Ĵޤ
     */
    protected final void adjustInnerFloat() {
        if (floatManager != null) {
            int diff = Math.max((floatManager.getLeft() - frame.right) - width, 0);
            this.width    += diff;
            this.left     += diff;
            this.drawLeft += diff;
        }
    }

    /** {@inheritDoc} */
    protected void drawContent(Canvas canvas, int x, int y) {
        // եȤ
        if (floatBlocks != null) {
            int floatsSize = floatBlocks.size();

            for (int i = 0; i < floatsSize; i++) {
                ((Block) floatBlocks.elementAt(i)).draw(canvas, x, y);
            }
        }

        super.drawContent(canvas, x, y);
    }

//### ե
    /**
     * եȥ֥åϿֹ֤ޤ
     *
     * @param  block եȥ֥å
     *
     * @return ֹ
     */
    protected char registerFloat(FloatBlock block) {
        if (floatBlocks == null) {
            floatBlocks = new Vector();
        }
        floatBlocks.addElement(block);
        return (char) (floatBlocks.size() - 1);
    }

    /**
     * եȥ֥åϿֹ֤ޤ
     *
     * @param  index ֹ
     *
     * @return եȥ֥å
     */
    protected FloatBlock getFloat(char index) {
        return (FloatBlock) floatBlocks.elementAt(index);
    }

    /**
     * եȥ֥å֤ޤ
     *
     * @param  block  եȥ֥å
     * @param  right  ֤Ǥ뱦դαεΥ
     * @param  top    ֤Ǥդξ夫εΥ
     * @param  bottom ֤Ǥ벼դξ夫εΥ
     */
    protected void deployFloat(FloatBlock block,
                               int right, int top, int bottom) {
        floatManager.add(block, right, top, bottom);
    }

    /**
     * ֤ΥեȤ礭֤ޤ
     *
     * @param  right  Ĵ٤뱦դαεΥ
     *
     * @return եȤ礭
     */
    public FloatManager.Trench getFloatTrench(int right) {
        if (floatManager == null) {
            return null;
        }
        return floatManager.get(right);
    }
}
