/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering.block;

import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.Status;

/**
 * Ūʥ֥åǤɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public class BasicBlock extends Block {
    /**
     * Ūʥ֥åޤ
     *
     * @param  drawkit   ɥå
     * @param  status    ơ
     * @param  container ƥʥ֥å
     *                   եȤαƶʤ <code>null</code>
     * @param  parent    ƥ֥å
     */
    protected BasicBlock(Drawkit drawkit, Status status,
                         ContainerBlock container, Block parent) {
        super(drawkit, status, container, parent);
    }

    /** {@inheritDoc} */
    public void analyze(int minParentHeight, int maxParentHeight) {
//Debug.out.println(this + ":BasicBlock.analyze1: " + minParentHeight + "," + maxParentHeight);
        analyze(minParentHeight, maxParentHeight, preferredHeight);
//Debug.out.println(this + ":BasicBlock.analyze2: " + minHeight + "," + maxHeight);
    }

    /**
     * ̥ܥå򽸷פơǾȺι⤵򻻽Фޤ
     * Ф̤ϡ {@link #minHeight}{@link #maxHeight}
     * ꤷޤ
     *
     * @param  minParentHeight ƥե졼κǾ
     *                         ʿޥ֥åκǾ <code>height</code>
     * @param  maxParentHeight ƥե졼κ
     *                         ʿޥ֥åκ <code>height</code>
     * @param  lowerHeight     ι⤵
     */
    protected void analyze(int minParentHeight, int maxParentHeight,
                           int lowerHeight) {
        Block block;
        int   contentsSize = contents.size();

        // ե졼ι⤵
        int minFrameHeight = getFrameHeight(minParentHeight);
        int maxFrameHeight = getFrameHeight(maxParentHeight);

        // Ҥ analyaze Τˡ礭
        minParentHeight -= minFrameHeight;
        maxParentHeight -= maxFrameHeight;

        // ®Τ٥ѿ
        int min = lowerHeight;
        int max = lowerHeight;

        for (int i = 0; i < contentsSize; i++) {
            block = (Block) contents.elementAt(i);
            block.analyze(minParentHeight, maxParentHeight);

            min = Math.max(min, block.minHeight);
            max = Math.max(max, block.maxHeight);
        }

        minHeight = min + minFrameHeight;
        maxHeight = max + maxFrameHeight;
    }

    /** {@inheritDoc} */
    protected void layoutBlock(int newHeight, int containerX, int containerY) {
//Debug.out.println(this + ":BasicBlock.layoutBlock: " + newHeight);
        Block block;
        int   width;                        // ʪ
        int   drawTop    = 0;               // ʪɬפʾ
        int   drawRight  = 0;               // ʪɬפʱ
        int   drawBottom = 0;               // ʪɬפʲ
        int   drawLeft   = 0;               // ʪɬפʺ
        int   contentsSize = contents.size();

        // ⤵ιפ򻻽
        if (contentsSize > 0) {
            Block lastBlock = null;

            // ΨΤˡ§Ū for ʸˤʤäƤ롦
            block = (Block) contents.elementAt(0);
            // ֥åƷ׻
            block.validate(newHeight, 0, 0, 0, containerX, containerY);

            for (int i = 0;;) {
                // 
                drawTop    = Math.min(drawTop   , block.drawTop   );
                drawRight  = Math.min(drawRight , block.drawRight );
                drawBottom = Math.max(drawBottom, block.drawBottom);
                drawLeft   = Math.max(drawLeft  , block.drawLeft  );

                // λ
                if (++i >= contentsSize) {
                    break;
                }

                lastBlock = block;
                block = (Block) contents.elementAt(i);
                // ֥åƷ׻
                block.validate(newHeight,
                               lastBlock.margin.left,
                               lastBlock.left,
                               0,
                               containerX,
                               containerY);
            }
        } else {
            block = null;
        }

        // 򻻽
        switch (preferredWidth) {
        case SIZE_AUTO:
            width = (block != null
                     ? Math.max(block.left, 0)
                     : 0);
            break;
        case SIZE_PERCENT:
            width = (parent.preferredWidth * status.width.getNumber().intValue()) / 100;
            break;
        case SIZE_NONE:
            width = 0;
            break;
        default:
            width = (block != null
                     ? Math.max(block.left, preferredWidth)
                     : preferredWidth);
        }

        // ֥åΤ礭
        this.width      = width;
        this.bottom     = top   + newHeight + frameHeight;
        this.left       = right + width     + frameWidth;
        this.drawTop    = top   + Math.min(frame.top   + drawTop  , 0);
        this.drawRight  = right + Math.min(frame.right + drawRight, 0);
        this.drawBottom = top   + frame.top   + newHeight
                        + Math.max(drawBottom - newHeight, frame.bottom);
        this.drawLeft   = right + frame.right + width
                        + Math.max(drawLeft   - width    , frame.left  );
    }
}
