/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.addin.java2.AWTWrapper;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.image.RotateFilter;
import net.hizlab.kagetaka.awt.image.SyncObserver;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.token.TokenTypes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.io.IOException;
import java.util.Vector;

/**
 * ߤ襹ơݻ륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.10 $
 */
public class Status implements Cloneable {
    private static final char FONT_CHECK_CHAR = '\u4E9C'/*  */;
    private static final String FONT_SERIF      = "serif";
    private static final String FONT_SANS_SERIF = "sans-serif";
    private static final String FONT_CURSIVE    = "cursive";
    private static final String FONT_FANTASY    = "fantasy";
    private static final String FONT_MONOSPACE  = "monospace";

    /** åȡ     */ public static final int TARGET_TOP    = Border.TOP   ;
    /** åȡ     */ public static final int TARGET_RIGHT  = Border.RIGHT ;
    /** åȡ     */ public static final int TARGET_BOTTOM = Border.BOTTOM;
    /** åȡ     */ public static final int TARGET_LEFT   = Border.LEFT  ;
    /** åȡ٤ */ public static final int TARGET_ALL    = Border.ALL   ;

    /** ȡˤ */ public static final int TOKEN = 1;
    /** ˤ */ public static final int STYLE = 2;

    private static AWTWrapper awtWrapper = AWTWrapper.getInstance();

    private HawkContext context;
    private Drawkit     drawkit;

    private double baseFontSize = 12;

    // ǡ
/*
    Status      firstChild     = null;
    Status      link           = null;
    Status      visited        = null;
    Status      hover          = null;
    Status      active         = null;
    Status      focus          = null;
    Status      firstLine      = null;
    Status      firstLetter    = null;
    Status      before         = null;
    Status      after          = null;
*/

    public int         display        = Value.DISPLAY_BLOCK;         // ǥץ쥤
    public Box         margin         = null;        // ޡ
    public Border      border         = null;        // ܡ
    public Box         padding        = null;        // ѥǥ
    public Background  background     = null;        // ط
    public FontData    fontData       = null; // ե
    public Font        font           = null; // ե
    public FontMetrics fontMetrics    = null; // ե
    public Dimension   fontFullSize   = null; // ե
    public int         fontMaxHeight  = 0;    // ե
    public int         fontHalfHeight = 0;    // ե
    public int         fontFullBase   = 0;    // ե
    public int         fontHalfBase   = 0;    // ե
    public int         fontMiniUp     = 0;    // ե
    public int         fontMiniLeft   = 0;    // ե
    public Link        anchor         = null;        // A 
    public String      tip            = null;        // ݥåץåʸ
    int         listLevel      = 0;           // ꥹȥͥȥ٥
    int         listType       = Value.LIST_NONE;   // ꥹȥ
    public Status      counterStatus  = this;        // ꥹȥ
    public boolean     reference      = true;        // ʸλȤ褹뤫

    public boolean   isBlackHole       = false;     // ƥĤ̵뤹뤫
    public boolean   isHorizontalRule  = false;     // ʬ HR ɤ
    public boolean   hasMarkerBlock;        // äƤ뵼
    public Vector    pseudoStyles;

    // ơ֥
    public int       colSpan       = 1;       // COLSPAN
    public int       rowSpan       = 1;       // ROWSPAN
    public Value     borderVerticalSpacing   = null;    // 
    public Value     borderHorizontalSpacing = null;    // 
    public int       captionSide;           // CAPTION 

    /** ΥơΥȡ󥿥 */
    public int       type          = TokenTypes.UNKNOWN;
    /** Υơοƥơ */
    private Status    parent        = null;

    private double  fontScaleBase = 0;        // եȤδΨ
    private boolean fontChanged   = false;    // եȤѹäɤ
    private Value[] fontFamilies  = null;     // ѹԤեȥեߥ̾
    private boolean fontStyle     = false;    // եȥtrue = italic
    private int     fontWeight    = 0;        // եλ
    private double  fontSize      = 0;        // եȥλ
    private double  fontScale     = 0;        // եȤΨ
    private boolean fontSizeStyle = false;    // եȥǥˤ

    /** 侩                  */ public Value width         = null;
    /** 侩⤵                */ public Value height        = null;
    /** Ԥι⤵                    */ public Value textIndent    = null;
    /** Ԥι⤵                    */ public Value lineHeight    = null;
    /** ʸ                    */ public Value letterSpacing = null;
    /** ֥åʸ·        */ public int   align         = Value.NONE;   // HR Ѥ˥ȥåפ NONE ɬפ
    /** ֥åʸ·        */ public int   valign        = Value.VALIGN_BASELINE;
    /** ʿ                      */ public Color foreColor     = null;
    /** 󥯿                    */ public Color linkColor     = null;
    /** ˬѤߥ󥯿            */ public Color vlinkColor    = null;
    /** ƥ֤ʥ󥯿        */ public Color alinkColor    = null;
    /** ʸνTD_* ¡ */ public int   decoration    = Value.INHERIT;
    /** ڡμ갷          */ public int   whiteSpace    = Value.WHITESPACE_NORMAL;
    /** ꥹȤΥ󥿡          */ public int   counterNo     = 1;
    /** ֤Υեå        */ public Value offsetX       = null;
    /** ե                    */ public int   floatType     = Value.FLOAT_NONE;
    /** ꥢ                      */ public int   clearType     = Value.CLEAR_NONE;

    /**
     * 󥹥󥹤ޤ
     *
     * @param  drawkit ɥå
     */
    Status(Drawkit drawkit) {
        this.context = drawkit.context;
        this.drawkit = drawkit;
        this.parent  = this;

        // եȤ
        Option option = context.getOption();
        String style  = option.getFontStyle().toLowerCase();
        int    type;
        if (FONT_SERIF    .compareTo(style) == 0) { type = Value.FONT_SERIF    ; } else
        if (FONT_CURSIVE  .compareTo(style) == 0) { type = Value.FONT_CURSIVE  ; } else
        if (FONT_FANTASY  .compareTo(style) == 0) { type = Value.FONT_FANTASY  ; } else
        if (FONT_MONOSPACE.compareTo(style) == 0) { type = Value.FONT_MONOSPACE; } else
        { type = Value.FONT_SANS_SERIF; }
        fontFamilies  = new Value[]{new Value(type)};
        fontScaleBase = option.getFontScale();
        Font   font   = getStyleFont(fontFamilies[0]);
        fontStyle     = ((font.getStyle() & Font.ITALIC) != 0);
        fontWeight    = ((font.getStyle() & Font.BOLD  ) != 0 ? 700 : 400);
        fontSize      = font.getSize();
        fontScale     = 1;
        fontChanged   = true;
        setupFont();
    }

    /**
     * ΥơѾơޤ
     * Ѿʤեɤϡͤᤵޤ
     *
     * @return Ѿƺ줿ơ
     */
    public Status createChild() {
        try {
            Status s = (Status) super.clone();

            // ʣʤեɤ
            s.background    = null;
            s.display       = Value.DISPLAY_INLINE;
            s.margin        = null;
            s.border        = null;
            s.padding       = null;
            s.type          = TokenTypes.UNKNOWN;
            s.width         = null;
            s.height        = null;
            s.valign        = Value.VALIGN_BASELINE;
            s.counterNo     = 1;
            s.floatType     = Value.FLOAT_NONE;
            s.clearType     = Value.CLEAR_NONE;

            s.hasMarkerBlock = false;
            s.pseudoStyles   = null;

            s.colSpan       = 1;
            s.rowSpan       = 1;

            s.fontSizeStyle = false;

            s.parent = this;
            return s;
        } catch (CloneNotSupportedException e) { }
        return null;
    }

    /**
     * ƥơ֤ޤ
     *
     * @return ƥơ
     */
    public Status getParent() {
        return parent;
    }

    /**
     * inherit Ѥˡɬܥơ null ξ硢Ƥ饳ԡޤ
     */
    void checkStatus() {
        setupFont();

        if (align      == Value.INHERIT) { align      = parent.align;      }
        if (valign     == Value.INHERIT) { valign     = parent.valign;     }
        if (foreColor  == null         ) { foreColor  = parent.foreColor;  }
        if (linkColor  == null         ) { linkColor  = parent.linkColor;  }
        if (vlinkColor == null         ) { vlinkColor = parent.vlinkColor; }
        if (alinkColor == null         ) { alinkColor = parent.alinkColor; }
        if (decoration == Value.INHERIT) { decoration = parent.decoration; }
        if (whiteSpace == Value.INHERIT) { whiteSpace = parent.whiteSpace; }
    }

    /**
     * ޡꤷޤ
     *
     * @param  target å
     * @param  value  
     */
    public void setMargin(int target, Value value) {
        if (!TokenTypes.canSetMargin(type)) { return; }
        if (margin == null) { margin = new Box(); }

        if ((target & TARGET_TOP   ) != 0) { margin.top    = value; }
        if ((target & TARGET_RIGHT ) != 0) { margin.right  = value; }
        if ((target & TARGET_BOTTOM) != 0) { margin.bottom = value; }
        if ((target & TARGET_LEFT  ) != 0) { margin.left   = value; }
    }

    /**
     * ܡΥꤷޤ
     *
     * @param  target å
     * @param  value  
     */
    public void setBorderStyle(int target, Value value) {
        if (border == null) { border = new Border(); }

        border.setStyle(target, value);
    }

    /**
     * ܡꤷޤ
     *
     * @param  target å
     * @param  value  
     */
    public void setBorderWidth(int target, Value value) {
        if (border == null) { border = new Border(); }

        border.setWidth(target, value);
    }

    /**
     * ܡοꤷޤ
     *
     * @param  target å
     * @param  value  
     */
    public void setBorderColor(int target, Color value) {
        if (border == null) { border = new Border(); }

        border.setColor(target, value);
    }

    /**
     * ѥǥ󥰤ꤷޤ
     *
     * @param  target å
     * @param  value  
     */
    public void setPadding(int target, Value value) {
        if (padding == null) { padding = new Box(); }

        if ((target & TARGET_TOP   ) != 0) { padding.top    = value; }
        if ((target & TARGET_RIGHT ) != 0) { padding.right  = value; }
        if ((target & TARGET_BOTTOM) != 0) { padding.bottom = value; }
        if ((target & TARGET_LEFT  ) != 0) { padding.left   = value; }
    }

    /**
     * طʿꤷޤ
     *
     * @param  color طʿ
     */
    public void setBackground(Color color) {
        if (background == null) {
            background = new Background();
        }

        background.set(color);
    }

    /**
     * طʲꤷޤ
     *
     * @param  src       طʲ URL
     * @param  repeat    ԡ
     * @param  positionV ľΰ
     * @param  positionH ʿΰ
     */
    public void setBackground(String src, Value repeat, Value positionH, Value positionV) {
        if (background == null) {
            background = new Background();
        }

        if (src == null) {
            background.set(null, null, null, null, null);
            return;
        }

        Content content = drawkit.getImageContent(drawkit.createURL(src),
                                                  src,
                                                  context.getOption().getLoadImage());
        if (content == null) {
            return;
        }

        Image image;
        try {
            if ((image = (Image) content.getObject(Content.TYPE_IMAGE)) == null) {
                return;
            }
        } catch (IOException e) {
            return;
        }

/*
  //### BUGS ɤƤߤʤƤ⤦ޤԤʡ
        // žطʲ
        if (drawkit.loadImage(image, "wait to load a source of background image") != MediaTracker.COMPLETE) {
            image.flush();
            return;
        }
*/

        // طʲɬž
        if (context.getOption().getSpinImage()) {
            image = drawkit.toolkit.createImage(new FilteredImageSource(image.getSource(),
                                                                        new RotateFilter()));
        }

        // ɼԤξϡطʲ˴
        if (drawkit.loadImage(image, "wait to load a background image") != MediaTracker.COMPLETE) {
            image.flush();
            return;
        }

        SyncObserver so = new SyncObserver();
        background.set(image,
                       new Dimension(image.getWidth (so),
                                     image.getHeight(so)),
                       repeat, positionH, positionV);
    }

    /**
     * ߤΥեȥեߥѹޤ
     *
     * @param  v եȥեߥ
     */
    public void setFontFamily(Value[] v) {
        fontFamilies = (v.length == 1 && v[0].getType() == Value.TYPE_KEY_INHERIT
                        ? parent.fontFamilies
                        : v);

        fontChanged = true;
    }

    /**
     * ߤΥեȥѹޤ
     *
     * @param  v եȥ
     */
    public void setFontStyle(Value v) {
        switch (v.getType()) {
        case Value.TYPE_KEY_INHERIT : fontStyle = parent.fontStyle; break;
        case Value.TYPE_KEY_NORMAL  : fontStyle = false; break;
        case Value.TYPE_KEY_ITALIC  :
        case Value.TYPE_KEY_OBLIQUE : fontStyle = true ; break;
        default: // AVOID
        }

        fontChanged = true;
    }

    /**
     * ߤΥեѹޤ
     *
     * @param  v ե
     */
    public void setFontWeight(Value v) {
        switch (v.getType()) {
        case Value.TYPE_KEY_INHERIT : fontWeight = parent.fontWeight; break;
        case Value.TYPE_KEY_NORMAL  : fontWeight =  400; break;
        case Value.TYPE_KEY_BOLD    : fontWeight =  700; break;
        case Value.TYPE_KEY_BOLDER  : fontWeight += 100; break;
        case Value.TYPE_KEY_LIGHTER : fontWeight -= 100; break;
        case Value.TYPE_INTEGER     : fontWeight = v.intValue(); break;
        case Value.NONE             : fontWeight = -1; break;
        default: // AVOID
        }

        fontChanged = true;
    }

    /**
     * ߤΥեȥѹޤ
     *
     * @param  v եȥ
     * @param  owner ʡ
     */
    public void setFontSize(Value v, int owner) {
        switch (v.getType()) {
        case Value.TYPE_KEY_INHERIT : fontScale = 1; break;
        case Value.TYPE_KEY_XX_SMALL: fontScale = 1 / fontScaleBase / fontScaleBase / fontScaleBase; break;
        case Value.TYPE_KEY_X_SMALL : fontScale = 1 / fontScaleBase / fontScaleBase; break;
        case Value.TYPE_KEY_SMALL   : fontScale = 1 / fontScaleBase; break;
        case Value.TYPE_KEY_MEDIUM  : fontScale = 1; break;
        case Value.TYPE_KEY_LARGE   : fontScale = fontScaleBase; break;
        case Value.TYPE_KEY_X_LARGE : fontScale = fontScaleBase * fontScaleBase; break;
        case Value.TYPE_KEY_XX_LARGE: fontScale = fontScaleBase * fontScaleBase * fontScaleBase; break;
        case Value.TYPE_KEY_LARGER  : fontScale *= fontScaleBase; break;
        case Value.TYPE_KEY_SMALLER : fontScale /= fontScaleBase; break;
        case Value.TYPE_LENGTH      : fontScale = (double) v.getValue(1, 1, fontData, Value.DATA_HORIZONTAL) / fontSize; break;
        case Value.TYPE_PERCENTAGE  : fontScale = v.getNumber().doubleValue() / 100; break;
        default: // AVOID
        }

        fontChanged = true;
    }

    /** եȤ򥻥åȥåפޤ */
    private void setupFont() {
        if (!fontChanged) {
            return;
        }

        Font font  = null;
        int  style = (fontWeight >= 700 ? Font.BOLD : 0) | (fontStyle ? Font.ITALIC : 0);
        int  size  = (int) (fontSize * fontScale);

        if (fontFamilies != null) {
            for (int i = 0; i < fontFamilies.length; i++) {
                // ͽѤߤΥեȤƤߤ
                if ((font = getStyleFont(fontFamilies[i])) != null) {
                    // ȥäϥեȤľ
                    if (font.getStyle() != style || font.getSize() != size) {
                        font = new Font(font.getName(), style, size);
                    }
                    break;
                }

                // åǤǡܸ򥵥ݡȤեȤΤ߼դ
                if (awtWrapper != null) {
                    font = new Font(fontFamilies[i].toString(), style, size);
                    if (awtWrapper.canFontDisplay(font, FONT_CHECK_CHAR)) {
                        break;
                    }
                    font = null;
                }
            }
            fontFamilies = null;
            if (font == null || font.equals(this.font)) {
                return;
            }
        } else {
            font = this.font;
            if (font.getStyle() == style && font.getSize() == size) {
                return;
            }
            font = new Font(font.getName(), style, size);
        }


        this.font           = font;
        this.fontData       = FontData.getInstance(context, font);
        this.fontMetrics    = fontData.getFontMetrics();
        this.fontFullSize   = fontData.getFullSize   ();
        this.fontMaxHeight  = fontData.getMaxHeight  ();
        this.fontHalfHeight = fontData.getHalfHeight ();
        this.fontFullBase   = fontData.getFullBase   ();
        this.fontHalfBase   = fontData.getHalfBase   ();
        this.fontMiniUp     = fontData.getMiniBase   () - fontFullBase;
        this.fontMiniLeft   = fontData.getMiniLeft   ();
        this.fontChanged    = false;
        if (background != null) {
            background.set(fontData);
        }
    }

    /** ͽ󤵤ƤեȤ */
    private Font getStyleFont(Value v) {
        switch (v.getType()) {
        case Value.FONT_SERIF     : return context.getOption().getFontSerif    ();
        case Value.FONT_SANS_SERIF: return context.getOption().getFontSansSerif();
        case Value.FONT_CURSIVE   : return context.getOption().getFontCursive  ();
        case Value.FONT_FANTASY   : return context.getOption().getFontFantasy  ();
        case Value.FONT_MONOSPACE : return context.getOption().getFontMonospace();
        default: return null;
        }
    }

    /**
     * ߤΥեȥǡ֤ޤ
     *
     * @return ꤵƤեȥǡ
     */
    public FontData getFontData() {
        return fontData;
    }

    /**
     * ʸνꤷޤ
     *
     * @param  td ʸν
     */
    public void setTextDecoration(int td) {
        decoration |= td;
    }

    /**
     * ʸνꤷޤ
     *
     * @param  td ʸν
     *
     * @return ꤵƤʸνƤ <code>true</code>
     *         ʳξ <code>false</code>
     */
    public boolean getTextDecoration(int td) {
        return ((decoration & td) != 0);
    }

    /**
     * ꥹȥפ֤ޤ
     *
     * @return ꥹȤΥ
     */
    public int getList() {
        return listType;
    }

    /**
     * ꥹȥ٥֤ޤ
     *
     * @return ꥹȤΥ٥
     */
    public int getListLevel() {
        return listLevel;
    }

    /**
     * ꥹȤꤷޤ
     *
     * @param  type ꥹȤΥ
     */
    public void setList(int type) {
        listLevel++;
        if (type == Value.LIST_MIX) {
            switch (listLevel) {
            case  1: listType = Value.LIST_DISC  ; break;
            case  2: listType = Value.LIST_CIRCLE; break;
            default: listType = Value.LIST_SQUARE; break;
            }
        } else {
            listType = type;
        }
        counterStatus = this;
    }

//### Box
    /**
     * ܥåͤɽޤ
     */
    public final class Box {
        /**  */
        public Value top;
        /**  */
        public Value right;
        /**  */
        public Value bottom;
        /**  */
        public Value left;

        /** 󥹥󥹤 */
        private Box() {
        }

        /**
         * ʸɽ֤ޤ
         *
         * @return ʸɽ
         */
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(getClass().getName());
            sb.append('[');
            if (top    != null) { sb.append(top   .toString()); } sb.append(", ");
            if (right  != null) { sb.append(right .toString()); } sb.append(", ");
            if (bottom != null) { sb.append(bottom.toString()); } sb.append(", ");
            if (left   != null) { sb.append(left  .toString()); } sb.append(']' );
            return sb.toString();
        }
    }
}
