/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

/**
 * ꥯȤΥꥹȤǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public final class RequestList {
    /** ߡ */
    private RequestList() {
    }

    /**
     * ꤵ줿ꥯȤμˡꥯȤɲäޤ
     * ꥯȤϺǸˤʤޤ
     *
     * @param  tail ɲäꥯ
     * @param  add  <code>tail</code> μɲäꥯ
     */
    public static void append(Request tail, Request add) {
        if (tail != null) {
            add .prev = tail;
            tail.next = add;
        }
        add.isChain = true;
    }

    /**
     * ꥯȤؤޤ
     *
     * @param  oldRequest Ťꥯ
     * @param  newRequest ꥯ
     *
     * @return ꥯ
     */
    public static Request replace(Request oldRequest, Request newRequest) {
        if (oldRequest.next != null) {
            newRequest.next = oldRequest.next;
            newRequest.next.prev = newRequest;
            oldRequest.next = null;
        }
        if (oldRequest.prev != null) {
            newRequest.prev = oldRequest.prev;
            newRequest.prev.next = newRequest;
            oldRequest.prev = null;
        }
        newRequest.isChain = oldRequest.isChain;

        return newRequest;
    }
}
