/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

/**
 * ϻ˵顼䡢¹Իξ֤ѹʤɤξ𤹤뤿
 * 󥿡ե
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public interface Reporter {
    /** ΤΥեƥɽޤ */
    int GLOBAL    =  101;
    /** ѡΥեƥɽޤ */
    int PARSER    =  201;
    /** 󥰤Υեƥɽޤ */
    int RENDERING =  301;
    /** ȡΥեƥɽޤ */
    int TOKEN     =  401;
    /** Υեƥɽޤ */
    int STYLE     =  501;
    /** ɤΥեƥɽޤ */
    int LOAD      =  601;
    /** ͥåȥΥեƥɽޤ */
    int NETWORK   =  801;
    /** åΥեƥɽޤ */
    int CACHE     =  901;

    /** 顼Υ٥ɽޤ */
    int ERROR   =  10;
    /** ץեΥ٥ɽޤ */
    int PROF    =   9;
    /** ٹΥ٥ɽޤ */
    int WARNING =   7;
    /** Υ٥ɽޤ */
    int INFO    =   3;
    /** ǥХåΥ٥ɽޤ */
    int DEBUG   =  -1;

    /** ĴΤɽޤ */
    int ALERT =  5;
    /** ͿΤɽޤ */
    int FYI   =  3;
    /** դɬפʤΤɽޤ */
    int NONE  =  0;

    /**
     * åϿޤ
     *
     * @param  facility եƥ
     * @param  level    åΥ٥
     * @param  emphasis 
     * @param  source   
     * @param  line     ֹ
     * @param  column   
     * @param  tag      
     * @param  message  å
     */
    void report(int facility, int level, int emphasis,
                Content source, int line, int column,
                String tag, String message);

    /**
     * 㳰Ͽޤ
     *
     * @param  t 㳰
     * @param  request ꥯ
     */
    void report(Throwable t, Request request);

    /**
     * ꤵ줿ݡȤ𤹤ɬפ뤫ɤ֤ޤ
     * Υ᥽åɤɬƤФ櫓ǤϤʤȤΤݡȤ
     * ϤȤˤΤ߸ƤФޤ
     *
     * @param  facility եƥ
     * @param  level    åΥ٥
     *
     * @return ݡȤɬפ <code>true</code>
     *         ʳξ <code>false</code>
     */
    boolean isReported(int facility, int level);
}
