/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.util.CharList;

import java.awt.Font;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;

/**
 * ץɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.9 $
 */
public class Option implements Serializable {
    /** @serial ץåȥȥ꡼ѡ */
    private String inputStreamParser = Resource.getMessage("parser.default", null);
    /** @serial ե륿ѡ */
    private String[] filterParsers = null;
    {
        String names = null;

        // ꥽꤫Ͽ
        names = Resource.getMessage("parser.default.filters", null);
        if (names != null) {
            StringTokenizer st = new StringTokenizer(names, ",; ");
            int count = st.countTokens();
            if (count > 0) {
                filterParsers = new String[count];
                int index = 0;
                while (st.hasMoreTokens()) {
                    filterParsers[index++] = st.nextToken();
                }
            }
        }
    }
    /** @serial ǥեȥեȥ */
    private String   fontStyle           = Resource.getMessage("rendering.font.style", null);
    /** @serial եե */
    private Font     serifFont           = Font.decode(Resource.getMessage("rendering.font.serif"     , null));
    /** @serial 󥻥եե */
    private Font     sansSerifFont       = Font.decode(Resource.getMessage("rendering.font.sans-serif", null));
    /** @serial ֥ե */
    private Font     cursiveFont         = Font.decode(Resource.getMessage("rendering.font.cursive"   , null));
    /** @serial ե */
    private Font     fantasyFont         = Font.decode(Resource.getMessage("rendering.font.fantasy"   , null));
    /** @serial ե */
    private Font     monospaceFont       = Font.decode(Resource.getMessage("rendering.font.monospace" , null));
    /** @serial եȤΨ */
    private volatile double   fontScale  = 1.2;
    /** @serial ꥢ󥰤ͭ */
    private boolean  antiAliasing        = false;

    /** @serial žʸ */
    private CharList charsSpinRight      = new CharList(Resource.getMessage("chars.spin.right"  , null), false);
    /** @serial ˰ưʸ */
    private CharList charsSpinLtrb       = new CharList(Resource.getMessage("chars.spin.ltrb"   , null), false);
    /** @serial Ƭػʸ */
    private CharList charsKinsokuHead    = new CharList(Resource.getMessage("chars.kinsoku.head", null), false);
    /** @serial ػʸ */
    private CharList charsKinsokuTail    = new CharList(Resource.getMessage("chars.kinsoku.tail", null), false);

    /** @serial ƥȽ饤򴹤뤫 */
    private boolean   swapDecoration      = false;
    /** @serial ɤ뤫ɤ */
    private boolean   loadImage           = true;
    /** @serial ž뤫 */
    private boolean   spinImage           = false;

    /**
     * ž
     *
     * @serial βž
     */
    protected Hashtable spinImageTable = new Hashtable();

    {
        // ž
        spinImageTable.put("gif" , new Spin(true, 1.35, 50));
        spinImageTable.put("jpeg", new Spin(true, 2.00, 50));
        spinImageTable.put("png" , new Spin(true, 1.35, 50));
        spinImageTable.put("*"   , new Spin(true, 1.5 , 50));
    }

    /**
     * ץޤ
     */
    public Option() {
    }

    /**
     * ץåȥȥ꡼ѡ֤ޤ
     *
     * @return ץåȥȥ꡼ѡ
     */
    public String getInputStreamParser() {
        return inputStreamParser;
    }

    /**
     * ץåȥȥ꡼ѡꤷޤ
     *
     * @param  value ץåȥȥ꡼ѡ
     */
    public void setInputStreamParser(String value) {
        inputStreamParser = value;
    }

    /**
     * ե륿ѡ֤ޤ
     *
     * @return ե륿ѡ
     */
    public String[] getFilterParsers() {
        return filterParsers;
    }

    /**
     * ե륿ѡꤷޤ
     *
     * @param  value ե륿ѡ
     */
    public void setFilterParsers(String[] value) {
        filterParsers = value;
    }

    /**
     * Ѥǥեȥեȥ֤ޤ
     *
     * @return Ѥǥեȥե
     */
    public String getFontStyle() {
        return fontStyle;
    }

    /**
     * Ѥǥեȥեȥꤷޤ
     *
     * @param  value Ѥǥեȥեȥ
     */
    public void setFontStyle(String value) {
        fontStyle = value;
    }

    /**
     * Ѥ륻եեȤ֤ޤ
     *
     * @return Ѥ륻եե
     */
    public Font getFontSerif() {
        return serifFont;
    }

    /**
     * Ѥ륻եեȤꤷޤ
     *
     * @param  value Ѥ륻եե
     */
    public void setFontSerif(Font value) {
        serifFont = value;
    }

    /**
     * Ѥ륵󥻥եեȤ֤ޤ
     *
     * @return Ѥ륵󥻥եե
     */
    public Font getFontSansSerif() {
        return sansSerifFont;
    }

    /**
     * Ѥ륵󥻥եեȤꤷޤ
     *
     * @param  value Ѥ륵󥻥եե
     */
    public void setFontSansSerif(Font value) {
        sansSerifFont = value;
    }

    /**
     * Ѥ륫֥եȤ֤ޤ
     *
     * @return Ѥ륫֥ե
     */
    public Font getFontCursive() {
        return cursiveFont;
    }

    /**
     * Ѥ륫֥եȤꤷޤ
     *
     * @param  value Ѥ륫֥ե
     */
    public void setFontCursive(Font value) {
        cursiveFont = value;
    }

    /**
     * ѤեȤ֤ޤ
     *
     * @return Ѥե
     */
    public Font getFontFantasy() {
        return fantasyFont;
    }

    /**
     * ѤեȤꤷޤ
     *
     * @param  value Ѥե
     */
    public void setFontFantasy(Font value) {
        fantasyFont = value;
    }

    /**
     * ѤեȤ֤ޤ
     *
     * @return Ѥե
     */
    public Font getFontMonospace() {
        return monospaceFont;
    }

    /**
     * ѤեȤꤷޤ
     *
     * @param  value Ѥե
     */
    public void setFontMonospace(Font value) {
        monospaceFont = value;
    }

    /**
     * եȤΨ֤ޤ
     *
     * @return եȤΨ
     */
    public double getFontScale() {
        return fontScale;
    }

    /**
     * եȤΨꤷޤ
     *
     * @param  value եȤΨ
     */
    public void setFontScale(double value) {
        fontScale = value;
    }

    /**
     * ꥢ󥰤뤫ɤ֤ޤ
     *
     * @return ꥢ󥰤 <code>true</code>
     *         ʳξ <code>false</code>
     */
    public boolean getAntiAliasing() {
        return antiAliasing;
    }

    /**
     * ꥢ󥰤뤫ɤꤷޤ
     *
     * @param  value ꥢ󥰤 <code>true</code>
     *               ʳξ <code>false</code>
     */
    public void setAntiAliasing(boolean value) {
        antiAliasing = value;
    }

    /**
     * žʸΥϥåơ֥֤ޤ
     *
     * @return žʸΥϥåơ֥
     */
    public CharList getCharsSpinRight() {
        return charsSpinRight;
    }

    /**
     * žʸΥꥹȤꤷޤ
     *
     * @param  value žʸΥꥹ
     */
    public void setCharsSpinRight(CharList value) {
        charsSpinRight = value;
    }

    /**
     * ˰ưʸΥϥåơ֥֤ޤ
     *
     * @return ˰ưʸΥϥåơ֥
     */
    public CharList getCharsSpinLtrb() {
        return charsSpinLtrb;
    }

    /**
     * ˰ưʸΥꥹȤꤷޤ
     *
     * @param  value ˰ưʸΥꥹ
     */
    public void setCharsSpinLtrb(CharList value) {
        charsSpinLtrb = value;
    }

    /**
     * ƬػʸΥϥåơ֥֤ޤ
     *
     * @return ƬػʸΥϥåơ֥
     */
    public CharList getCharsKinsokuHead() {
        return charsKinsokuHead;
    }

    /**
     * ƬػʸΥꥹȤꤷޤ
     *
     * @param  value ƬػʸΥꥹ
     */
    public void setCharsKinsokuHead(CharList value) {
        charsKinsokuHead = value;
    }

    /**
     * ػʸΥϥåơ֥֤ޤ
     *
     * @return ػʸΥϥåơ֥
     */
    public CharList getCharsKinsokuTail() {
        return charsKinsokuTail;
    }

    /**
     * ػʸΥꥹȤꤷޤ
     *
     * @param  value ػʸΥꥹ
     */
    public void setCharsKinsokuTail(CharList value) {
        charsKinsokuTail = value;
    }

    /**
     * ƥȽ饤κؤ뤫ɤ֤ޤ
     *
     * @return ؤ <code>true</code>
     *         ʳξ <code>false</code>
     */
    public boolean getSwapDecoration() {
        return swapDecoration;
    }

    /**
     * ƥȽ饤κؤ뤫ɤꤷޤ
     *
     * @param  value ؤ <code>true</code>
     *               ʳξ <code>false</code>
     */
    public void setSwapDecoration(boolean value) {
        swapDecoration = value;
    }

    /**
     * ɤ뤫ɤ֤ޤ
     *
     * @return ɤ <code>true</code>
     *         ʳξ <code>false</code>
     */
    public boolean getLoadImage() {
        return loadImage;
    }

    /**
     * ɤ뤫ɤꤷޤ
     *
     * @param  value ɤ <code>true</code>
     *               ʳξ <code>false</code>
     */
    public void setLoadImage(boolean value) {
        loadImage = value;
    }

    /**
     * ž뤫ɤ֤ޤ
     *
     * @return ž <code>true</code>
     *         ʳξ <code>false</code>
     */
    public boolean getSpinImage() {
        return spinImage;
    }

    /**
     * ž뤫ɤꤷޤ
     *
     * @param  value ž <code>true</code>
     *               ʳξ <code>false</code>
     */
    public void setSpinImage(boolean value) {
        spinImage = value;
    }

    /**
     * žɽ뤫ɤ֤ޤ
     *
     * @param  type ס¾ξ <code>*</code>
     *
     * @return ž <code>true</code>
     *         ʳξ <code>false</code>
     */
    public boolean getSpinImage(String type) {
        if (!spinImageTable.containsKey(type)) {
            type = "*";
        }
        Spin spin = (Spin) spinImageTable.get(type);
        if (spin == null) {
            return false;
        }
        return spin.spin;
    }

    /**
     * žɽ뤫ɤꤷޤ
     *
     * @param  type  ס¾ξ <code>*</code>
     * @param  value ž <code>true</code>
     *               ʳξ <code>false</code>
     */
    public void setSpinImage(String type, boolean value) {
        synchronized (spinImageTable) {
            Spin spin = (Spin) spinImageTable.get(type);
            if (spin == null) {
                spinImageTable.put(type, spin = new Spin(value, 0, 0));
            } else {
                spin.spin = value;
            }
        }
    }

    /**
     * žĲ֤ޤ
     *
     * @param  type ס¾ξ <code>*</code>
     *
     * @return žνĲ
     */
    public double getSpinAspectRatio(String type) {
        if (!spinImageTable.containsKey(type)) {
            type = "*";
        }
        Spin spin = (Spin) spinImageTable.get(type);
        if (spin == null) {
            return 0;
        }
        return spin.aspectRatio;
    }

    /**
     * žĲꤷޤ
     *
     * @param  type  ס¾ξ <code>*</code>
     * @param  value žνĲ
     */
    public void setSpinAspectRatio(String type, double value) {
        synchronized (spinImageTable) {
            Spin spin = (Spin) spinImageTable.get(type);
            if (spin == null) {
                spinImageTable.put(type, spin = new Spin(false, value, 0));
            } else {
                spin.aspectRatio = value;
            }
        }
    }

    /**
     * ɬž֤ޤ
     *
     * @param  type ס¾ξ <code>*</code>
     *
     * @return žκ
     */
    public int getSpinMinWidth(String type) {
        if (!spinImageTable.containsKey(type)) {
            type = "*";
        }
        Spin spin = (Spin) spinImageTable.get(type);
        if (spin == null) {
            return 0;
        }
        return spin.minWidth;
    }

    /**
     * ɬžꤷޤ
     *
     * @param  type  ס¾ξ <code>*</code>
     * @param  value žκ
     */
    public void setSpinMinWidth(String type, int value) {
        synchronized (spinImageTable) {
            Spin spin = (Spin) spinImageTable.get(type);
            if (spin == null) {
                spinImageTable.put(type, spin = new Spin(false, 0, value));
            } else {
                spin.minWidth = value;
            }
        }
    }

//### Spin
    /**
     * βžǼ륯饹Ǥ
     */
    protected static class Spin {
        /** ž뤫ɤ  @serial ž뤫ɤ */
        protected          boolean spin        = false;
        /** žĲ    @serial žĲ   */
        protected volatile double  aspectRatio = 1.35;
        /** ž  @serial ž */
        protected          int     minWidth    = 50;

        /**
         * žޤ
         *
         * @param  spin        ž뤫ɤ
         * @param  aspectRatio žĲ
         * @param  minWidth    ž
         */
        protected Spin(boolean spin, double aspectRatio, int minWidth) {
            this.spin        = spin;
            this.aspectRatio = aspectRatio;
            this.minWidth    = minWidth;
        }
    }
}
