/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;


import java.net.URL;
import java.util.Vector;

/**
 * ̾Υƥΰ֤ɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public class ItemMap {
    private Vector linkMap;
    private Vector urlMap;
    private Vector tipMap;
    private Vector infoMap;

    /**
     * ޥåפޤ
     */
    ItemMap() {
    }

    /**
     * ɲäޤ (X ɸϲ̱εΥ)
     *
     * @param  link 
     * @param  x1    X
     * @param  y1    Y
     * @param  x2    X
     * @param  y2    Y
     */
    public synchronized void addLink(Link link, int x1, int y1, int x2, int y2) {
        if (linkMap == null) {
            linkMap = new Vector();
        }
        linkMap.addElement(new Item(link, x1, y1, x2, y2));
    }

    /**
     * ꤵ줿֤Υ֤ޤ
     *
     * @param  x X ɸ
     * @param  y Y ɸ
     *
     * @return 衢
     *         褬¸ߤʤ <code>null</code>
     */
    public synchronized Link getLink(int x, int y) {
        if (linkMap == null) { return null; }
        Item ir = null;

        for (int i = 0; i < linkMap.size(); i++) {
            ir = (Item) linkMap.elementAt(i);
            if (ir.isInner(x, y)) {
                return (Link) ir.obj;
            }
        }

        return null;
    }

    /**
     * ֥Ȥΰ֤ɲäޤ (X ɸϲ̱εΥ)
     *
     * @param  url URL
     * @param  x1   X
     * @param  y1   Y
     * @param  x2   X
     * @param  y2   Y
     */
    public synchronized void addURL(URL url, int x1, int y1, int x2, int y2) {
        if (urlMap == null) {
            urlMap = new Vector();
        }
        urlMap.addElement(new Item(url, x1, y1, x2, y2));
    }

    /**
     * ꤵ줿֤Υ֥Ȥ URL ֤ޤ
     *
     * @param  x X ɸ
     * @param  y Y ɸ
     *
     * @return ֥Ȥ URL
     *         ֥Ȥ URL ¸ߤʤ <code>null</code>
     */
    public synchronized URL getURL(int x, int y) {
        if (urlMap == null) { return null; }
        Item ir = null;

        for (int i = 0; i < urlMap.size(); i++) {
            ir = (Item) urlMap.elementAt(i);
            if (ir.isInner(x, y)) {
                return (URL) ir.obj;
            }
        }

        return null;
    }

    /**
     * ɲäޤ (X ɸϲ̱εΥ)
     *
     * @param  tip 
     * @param  x1   X
     * @param  y1   Y
     * @param  x2   X
     * @param  y2   Y
     */
    public synchronized void addTip(String tip, int x1, int y1, int x2, int y2) {
        if (tipMap == null) {
            tipMap = new Vector();
        }
        tipMap.addElement(new Item(tip, x1, y1, x2, y2));
    }

    /**
     * ꤵ줿֤ʸ֤ޤ
     *
     * @param  x X ɸ
     * @param  y Y ɸ
     *
     * @return ʸ
     *         ʸ¸ߤʤ <code>null</code>
     */
    public synchronized String getTip(int x, int y) {
        if (tipMap == null) { return null; }
        Item ir = null;

        for (int i = 0; i < tipMap.size(); i++) {
            ir = (Item) tipMap.elementAt(i);
            if (ir.isInner(x, y)) {
                return (String) ir.obj;
            }
        }

        return null;
    }

    /**
     * ɲäޤ (X ɸϲ̱εΥ)
     *
     * @param  tip 
     * @param  x1   X
     * @param  y1   Y
     * @param  x2   X
     * @param  y2   Y
     */
    public synchronized void addInfo(String tip, int x1, int y1, int x2, int y2) {
        if (infoMap == null) {
            infoMap = new Vector();
        }
        infoMap.addElement(new Item(tip, x1, y1, x2, y2));
    }

    /**
     * ꤵ줿֤ξʸ֤ޤ
     *
     * @param  x X ɸ
     * @param  y Y ɸ
     *
     * @return ʸ
     *         ʸ¸ߤʤ <code>null</code>
     */
    public synchronized String getInfo(int x, int y) {
        if (infoMap == null) { return null; }
        Item ir = null;

        for (int i = 0; i < infoMap.size(); i++) {
            ir = (Item) infoMap.elementAt(i);
            if (ir.isInner(x, y)) {
                return (String) ir.obj;
            }
        }

        return null;
    }

//### Item
    /** 󥯰 */
    private final class Item {
        private Object obj;
        private int    x1;
        private int    y1;
        private int    x2;
        private int    y2;

        /** 󥹥󥹤 */
        private Item(Object obj, int x1, int y1, int x2, int y2) {
            this.obj = obj;
            this.x1  = x1;
            this.y1  = y1;
            this.x2  = x2;
            this.y2  = y2;
        }

        /** ꤵ줿ɸ¦å */
        private boolean isInner(int x, int y) {
            return (x1 <= x
                 && x <= x2
                 && y1 <= y
                 && y <= y2);
        }
    }
}
