/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import java.awt.Point;
import java.util.Hashtable;

/**
 * ̾ ID ΰ֤ɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public class IdMap {
    private Hashtable idMap;

    /**
     * ޥåפޤ
     */
    IdMap() {
    }

    /**
     * ID ΰ֤ɲäޤ (X ɸϲ̱εΥ)
     *
     * @param  id ID
     *
     * @return ɲäǤɲäƥ
     *          ID ¸ߤ <code>null</code>
     */
    synchronized Item addId(String id) {
        if (idMap == null) {
            idMap = new Hashtable();
        }
        if (idMap.containsKey(id)) {
            return null;
        }

        Item item = new Item();
        idMap.put(id, item);
        return item;
    }

    /**
     * ꤵ줿 ID ΰ֤֤ޤ
     * ֤ϱ夫εΥǤ
     *
     * @param  id ID
     *
     * @return ID ΰ֡
     *         ID ¸ߤʤ <code>null</code>
     */
    public synchronized Point getIdPoint(String id) {
        if (idMap == null) { return null; }
        Item ir = (Item) idMap.get(id);
        if (ir == null) {
            return null;
        }

        return new Point(ir.x + ir.canvas.x, ir.y);
    }

//### Item
    /**
     * ID ΰ֤Ǽ륯饹Ǥ
     */
    final class Item {
        private Canvas canvas;
        private int    x;
        private int    y;

        /** 󥹥󥹤 */
        private Item() {
        }

        /**
         * ־ꤷޤ (X ɸϲ̱εΥ)
         *
         * @param  canvas 襭Х
         * @param  x       X
         * @param  y       Y
         */
        synchronized void set(Canvas canvas, int x, int y) {
            this.canvas = canvas;
            this.x      = x;
            this.y      = y;
        }
    }
}
