/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.awt.ImageCreator;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;

/**
 * ԤδĶɽޤ
 * Υ󥿡եͳơĶѹޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public interface HawkContext extends ImageCreator {
    /** ֥å᡼ɲ */
    int IMAGE_NEW    = 0;
    /** Х礭ѤäΥ֥å᡼ѹ */
    int IMAGE_RESIZE = 1;
    /** 礭ꤵ줿Υ֥å᡼ѹ */
    int IMAGE_FIXED  = 2;

    /**
     * ݡ֤ޤ
     * ȯåꤿϡ
     * {@link Reporter} 򥤥ץȤ饹
     * Υ󥹥󥹤֤ɬפޤ
     *
     * @return ݡ
     */
    Reporter getReporter();

    /**
     * ġ륭åȤ֤ޤ
     *
     * @return ġ륭å
     */
    Toolkit getToolkit();

    /**
     * ꤷꥯȤɽޤ
     *
     * @param  request ꥯ
     */
    void openHawk(Request request);

    /**
     * ꤵ줿ꥯȤΥƥĤ֤ޤ
     * ĶˤäˡǥƥĤѰդƤɬפޤ
     *
     * @param  request ꥯ
     *
     * @return ƥ
     *
     * @throws IOException IO 顼ȯ
     * @throws InterruptedException ߤȯ
     */
    Content getContent(Request request)
            throws IOException, InterruptedException;

    /**
     * ꤵ줿ƥĤΥɤԤޤ
     * ĶˤäˡǥɤԤޤ
     * ̤ϡΥ᥽åǥåɤ
     * ΥåɤǥɽԤɬפޤ
     *
     * @param  content ƥ
     */
    void download(Content content);

    /**
     * ᡼Ѥ륤᡼֤ޤ
     *
     * @param  width 
     * @param  height ⤵
     *
     * @return ᡼
     */
    Image createImage(int width, int height);

    /**
     * ǥȥå֤ޤ
     *
     * @return ǥȥå
     */
    MediaTracker getMediaTracker();

    /**
     * ֥å᡼ꤷޤ
     * ɬդΥǥå֤ɬפޤ
     * ѹʤɤˤꡢΥǥåǺꤵ礬ޤ
     *
     * @param  index   ǥåɲäȤ <code>-1</code>
     * @param  reason  ͳ
     * @param  tag     ѹ̤륿
     * @param  image   ֥å᡼
     *                 ֥å <code>0</code> ξ <code>null</code>
     * @param  width   ֥å᡼
     * @param  height  ֥å᡼ι⤵
     * @param  itemMap ƥޥåס
     *                 ֥å <code>0</code> ξ <code>null</code>
     *
     * @return ǥå
     */
    int setImage(int index, int reason, int tag, Image image, int width, int height, ItemMap itemMap);

    /**
     * եॢƥɲäޤ
     *
     * @param  item եॢƥ
     */
    void addFormItem(FormItem item);

    /**
     * ꤵ줿ꥯȤƤɽ뤿ˡѥͥޤ
     *
     * @param  document ɥ
     */
    void setupPanel(Document document);

    /**
     * ꤵ줿ꥯȤΥե졼ɽ뤿ˡѥͥޤ
     *
     * @param  document ɥ
     * @param  rootItem ե졼Υ롼ȥƥ
     */
    void setupPanel(Document document, FrameItem rootItem);

    /**
     * ѥͥꤷޤ
     * ǽ衢ѹˤʤɤθ˸ƤӽФޤ
     * 褬ǥ󥻥뤵줿ʤɤϡƤӽФʤȤ⤢ޤ
     *
     * @param  document ɥ
     * @param  tag      ѹ̤륿
     */
    void commitPanel(Document document, int tag);

    /**
     * ХϰϤꤷƺɽޤ
     * ɸϱ夫εΥǤ
     *
     * @param  x Хα顢ɽ֤αüεΥ
     * @param  y Хξ夫顢ɽ֤ξüεΥ
     * @param  width  ɽϰϤ
     * @param  height ɽϰϤι⤵
     */
    void repaint(int x, int y, int width, int height);

    /**
     * ơåꤷޤ
     *
     * @param  status ơå
     */
    void setStatus(String status);

    /**
     * Ūʥơåꤷޤ
     *
     * @param  status ơå
     */
    void setTemporaryStatus(String status);

    /**
     * ӥ塼ݡȤθߤΥ֤ޤ
     *
     * @param  def ǥեȥ <code>true</code>
     *             ߤΥ <code>false</code>
     *
     * @return ԥñ̤Υӥ塼ݡȤΥ
     */
    Dimension getViewportSize(boolean def);

    /**
     * ץ֤ޤ
     *
     * @return ץ
     */
    Option getOption();

    /**
     * ꤷ URL ˬ䤷Ȥ뤫ɤ֤ޤ
     *
     * @param  url URL
     *
     * @return ˬ줿Ȥ <code>true</code>
     *         ʳξ <code>false</code>
     */
    boolean haveEverVisited(URL url);

    /**
     * åꤷޤ
     *
     * @param  value åɽʸ
     * @param  url   åȯԤ URL
     */
    void setCookie(String value, URL url);
}
