/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.token.Value;

/**
 * ե졼ॢƥɽ󥿡եǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public interface FrameItem {
    /**
     * ҤΥե졼ॢƥ֤ޤ
     * Υե졼ॢƥबüǤ뤫ɤϡ
     * Υ᥽åɤͤˤȽǤ뤳Ȥޤ
     *
     * @return ҤΥե졼ॢƥࡢ
     *         üΥե졼ξ <code>null</code>
     */
    FrameItem[][] getItems();

    /**
     * ե졼ॢƥ֤ޤ
     *
     * @return ե졼ॢƥξ
     */
    Value getWidth();

    /**
     * ե졼ॢƥꤷޤ
     *
     * @param  width 
     */
    void setWidth(Value width);

    /**
     * ե졼ॢƥι⤵֤ޤ
     *
     * @return ե졼ॢƥξϹ⤵
     */
    Value getHeight();

    /**
     * ե졼ॢƥι⤵ꤷޤ
     *
     * @param  height ⤵
     */
    void setHeight(Value height);

    /**
     * ե졼ॢƥ֤̾ޤ
     *
     * @return ե졼ॢƥ̾
     *         üΥե졼ǤϤʤ䡢
     *         ̾ꤵƤʤ <code>null</code>
     */
    String getName();

    /**
     * ե졼ॢƥ SRC ֤ޤ
     *
     * @return ե졼ॢƥ SRC
     *         üΥե졼ǤϤʤ <code>null</code>
     */
    String getSrc();

    /**
     * ե졼बꥵǽ֤ޤ
     *
     * @return ե졼बꥵǽʾ <code>true</code>
     *         Բǽʾ <code>false</code>
     */
    boolean getResize();

    /**
     * ե졼ΥСɽ⡼ɤ֤ޤ
     *
     * @return Сɽ⡼
     *
     * @see    Value#SCROLLING_YES
     * @see    Value#SCROLLING_AUTO
     * @see    Value#SCROLLING_NO
     */
    int getScrolling();

    /**
     * ڤȤɽ뤫֤ޤ
     *
     * @return ڤȤɽ <code>true</code>
     *         ɽʤ <code>false</code>
     */
    boolean getBorder();

    /**
     * ե졼⥳ƥĤκΥޡ֤ޤ
     *
     * @return Υޡ
     */
    int getMargineWidth();

    /**
     * ե졼⥳ƥĤξ岼Υޡ֤ޤ
     *
     * @return 岼Υޡ
     */
    int getMargineHeight();
}
