/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

/**
 * 襨󥸥Υ٥ȥꥹʤǤ
 * <p>
 * ޤǽˡ³³륤٥Ȥɬȯޤ
 * <ol>
 * <li>{@link #connecting(Request)}</li>
 * <li>{@link #connected(Request, boolean)}</li>
 * </ol>
 * <p>
 * ˡɬפȤϼΥ٥Ȥȯ
 * <ol>
 * <li>{@link #renderingStarted(Request)}</li>
 * <li>{@link #renderingStopped(Request, boolean)}</li>
 * </ol>
 * ɬפȤʤϡΥ٥Ȥȯޤ
 * <ol>
 * <li>{@link #renderingSkipped(Request)}</li>
 * </ol>
 * <p>
 * ޤɽλ꤬ڡɽƤϡ
 * {@link #refresh(Request, Request)} ָȯޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public interface EngineListener {
    /**
     * ³Ϥ˸ƤӽФޤ
     *
     * @param  request ꥯ
     */
    void connecting(Request request);

    /**
     * ³λȸƤӽФޤ
     *
     * @param  request ꥯ
     * @param  noerror 顼ʤä <code>true</code>
     *                 ʳξ <code>false</code>
     */
    void connected(Request request, boolean noerror);

    /**
     * 褬Ϥ줺˽λȤ˸ƤӽФޤ
     *
     * @param  request ꥯ
     */
    void renderingSkipped(Request request);

    /**
     * 褬Ϥ˸ƤӽФޤ
     *
     * @param  request ꥯ
     */
    void renderingStarted(Request request);

    /**
     * 褬λȸƤӽФޤ
     *
     * @param  request ꥯ
     * @param  noerror 顼ʤä <code>true</code>
     *                 ʳξ <code>false</code>
     */
    void renderingStopped(Request request, boolean noerror);

    /**
     * ꤷꥯȤɽޤ
     * meta refresh ¸ߤˡ÷в˸ƤӽФޤ
     *
     * @param  baseRequest ɹθˤʤäꥯ
     * @param  newRequest  ɹΥꥯ
     */
    void refresh(Request baseRequest, Request newRequest);
}
