/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.fclabs.util.Queue;
import net.hizlab.kagetaka.addin.java2.AWTWrapper;
import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.util.CharList;
import net.hizlab.kagetaka.util.Environment;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.Vector;

/**
 * 󥰤Ѥ롢ʥɥåȤǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.11 $
 */
public class Drawkit {
    private static final int MT_WAIT = 30000;              // ǥȥåԤ

    public HawkContext context;                    // 륳ƥ
    Request     request;                    // ꥯ
    Document    document;                   // ɥ

    private Reporter     reporter;          // ݡ
    private Option       option;            // ץ
    private MediaTracker mt;                // ǥȥå

    public Toolkit   toolkit;               // ġ륭å
    IdMap      idMap;                       // ID ޥå
    AWTWrapper awtWrapper;                  // AWT åѡ

    // üʸꥹ
    public CharList  charsSpinRight;        // žʸ
    public CharList  charsSpinLtrb;         // ưʸ
    public CharList  charsKinsokuHead;      // Ƭػʸ
    public CharList  charsKinsokuTail;      // ػʸ
    public boolean   antiAliasing;          // ꥢ
    public boolean   swapDecoration;        // ƥȽθ

    // ե饰
    boolean   isSetupPanel;                 // ѥͥ뤬åȥåפƤ뤫

    // ID
    public Queue   idQueue      = new Queue ();    // ID 塼
    public Vector  ids          = new Vector();    // ID 

    // 
    public Counter imageCounter = new Counter(0);  // βο
    public Vector  images       = new Vector();    // 

    // եȽ
    Queue   floatQueue;                     // ե襭塼
    Vector  floats       = new Vector();    // ե

    // ե
    public Vector  formItems    = new Vector();    // եॢƥ
    public Queue   formQueue    = new Queue ();    // ե७塼

    // 饤֥å
    public Vector  inlineBlocks = new Vector();    // 饤֥å


    /**
     * 󥹥󥹤ޤ
     *
     * @param  context ƥ
     * @param  request ꥯ
     */
    Drawkit(HawkContext context, Request request) {
        this.context  = context;
        this.request  = request;
        this.document = request.getDocument();

        this.reporter = context.getReporter    ();
        this.option   = context.getOption      ();
        this.mt       = context.getMediaTracker();

        this.toolkit  = context.getToolkit ();
        this.idMap    = document.idMap;
        if (Environment.javaVersion >= 102) {
            this.awtWrapper = AWTWrapper.getInstance();
        }

        this.charsSpinRight   = option.getCharsSpinRight  ();
        this.charsSpinLtrb    = option.getCharsSpinLtrb   ();
        this.charsKinsokuHead = option.getCharsKinsokuHead();
        this.charsKinsokuTail = option.getCharsKinsokuTail();
        this.antiAliasing     = option.getAntiAliasing    ();
        this.swapDecoration   = option.getSwapDecoration  ();

    }

//### block 
    /**
     * ID ΰ־ꤷޤ (X ɸϲ̱εΥ)
     *
     * @param  index  ID Υǥå
     * @param  canvas 襭Х
     * @param  x       X
     * @param  y       Y
     */
    public void setIdPosition(int index, Canvas canvas, int x, int y) {
        IdMap.Item id = (IdMap.Item) ids.elementAt(index);
        id.set(canvas, x, y);
    }

//### Render 
    /**
     * ɤ߹ߤλΤԤޤ
     */
    void waitImageLoad() {
        try {
            imageCounter.waitFor(0);
        } catch (InterruptedException e) {
            // β
            for (int i = 0; i < images.size(); i++) {
                ImageItem ii = (ImageItem) images.elementAt(i);
                if (ii.isLoading()) {
                    reportMessage(Reporter.INFO, "render.info.image.stop", new String[]{ii.toString()});
                }
                ii.dispose();
            }

            throw new StopException("wait to load all images");
        }
    }

    /**
     * ɤ߹ߤ򥭥󥻥뤷ޤ
     */
    void stopImageLoad() {
        if (imageCounter.current() <= 0) {
            return;
        }

        for (int i = 0; i < images.size(); i++) {
            ((ImageItem) images.elementAt(i)).dispose();
        }
    }

    /**
     * ꥽ޤ
     */
    void dispose() {
        for (int i = 0; i < images.size(); i++) {
            ((ImageItem) images.elementAt(i)).dispose();
        }
        images.removeAllElements();
    }

//### Canvas 
    /**
     * ѥͥ򥻥åȥåפޤ
     */
    synchronized void setupPanel() {
        if (!isSetupPanel) {
            context.setupPanel(document);
            isSetupPanel = true;
        }
        while (!formQueue.isEmpty()) {
            ((FormItem) formQueue.get()).show();
        }
    }

//### 
    /**
     * å𤷤ޤ
     *
     * @param  level ٥
     * @param  key   
     * @param  args  
     */
    public void reportMessage(int level, String key, Object[] args) {
        if (reporter == null) {
            return;
        }

        reporter.report(Reporter.RENDERING, level, Reporter.NONE, document.content, 0, 0, "Draw", Resource.getMessage(key, args));
    }

    /**
     * å𤷤ޤ
     *
     * @param  t 㳰
     */
    public void reportMessage(Throwable t) {
        if (reporter != null) {
            reporter.report(t, request);
        }
    }

    /**
     * ߤΥ١ URL 򸵤ˡURL ޤ
     *
     * @param  href ѥ
     *
     * @return URL
     */
    public URL createURL(String href) {
        try {
            return document.createURL(href);
        } catch (SecurityException e) {
            reportMessage(Reporter.WARNING, "engine.status.connect.error.security", new String[]{href});
        } catch (MalformedURLException e) {
            reportMessage(Reporter.WARNING, "render.warning.href", new String[]{href, e.toString()});
        }

        return null;
    }

    /**
     * ޤ
     *
     * @param  width  
     * @param  height ⤵
     *
     * @return 
     */
    public Image createImage(int width, int height) {
        Image image = context.createImage(width, height);
        if (image == null) {
            throw new StopException("Can not create image(" + width + "x" + height + ")");
        }
        return image;
    }

    /**
     * ƥĤޤ
     *
     * @param  url URL
     * @param  src 
     * @param  loadImage å̵ɤ
     *                   <code>true</code>
     *                   ʳξ <code>false</code>
     *
     * @return ƥ
     */
    public Content getImageContent(URL url, String src, boolean loadImage) {
        if (url == null) {
            return null;
        }

        Content content = request.createRequest(url,
                                                (loadImage
                                                 ? request.getUseCache()
                                                 : Request.CACHE_MUST)).getContent(context, true);
        if (content == null) {
            return null;
        }

        try {
            if (content.getObject(Content.TYPE_IMAGE) instanceof Image) {
                return content;
            }
Debug.out.println("### WARNING ### Drawkit.getImageContent = " + content + "," + (content != null ? content.getObject(Content.TYPE_IMAGE) : ""));
        } catch (IOException e) {
            reportMessage(Reporter.WARNING,
                          "render.warning.image.content",
                          new String[]{src});
Debug.out.println("### WARNING ### Drawkit.getImageContent = " + e);
e.printStackTrace(Debug.out);
        } catch (RuntimeException e) {
            String s = e.getMessage();
            reportMessage(Reporter.WARNING,
                          "engine.status.load.error",
                          new Object[]{url.toExternalForm(), new Integer(s != null ? 1 : 0), s, e.getClass().getName()});
            reportMessage(e);
        }

        return null;
    }

    /**
     * ɤޤ
     *
     * @param  image   
     * @param  message ɤ߹ߤߤȤꤲ㳰Υå
     *
     * @return ɤ߹ߥơ{@link MediaTracker}
     */
    public int loadImage(Image image, String message) {
        int status;

        mt.addImage(image, 0);
        for (;;) {
            try {
                mt.waitForID(0, MT_WAIT);
            } catch (InterruptedException e) {
                throw new StopException(message);
            }
            if ((status = mt.statusID(0, true)) != MediaTracker.LOADING) {
                break;
            }
        }
        mt.removeImage(image, 0);

        return status;
    }
}
