/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.addin.StyleManager;

import java.awt.Dimension;
import java.net.URL;
import java.net.MalformedURLException;

/**
 * ɥΤɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.5 $
 */
public class Document {
    private static final Dimension DEFAULT_CHAR_SCALE = new Dimension(0, 0);

    /** 󥿡ͥåȥ */
    public static final int ZONE_INTERNET = 0;
    /** 륾 */
    public static final int ZONE_LOCAL    = 1;

    private HawkContext  context;
    private ContentCache cache;

    /** ƥ */
    public final Content content;
    /** ID ޥå */
    public final IdMap   idMap;
    /**  */
    public final int     zone;

    private StyleManager styleManager;
    private URL          baseUrl;
    private String       baseTarget;
    private String       title;
    private Background   background;
    private Dimension    charScale = DEFAULT_CHAR_SCALE;

    private int referenceCount = 1;         // ȿ

    /**
     * ɥȤΥ󥹥󥹤ޤ
     *
     * @param  context 륳ƥ
     * @param  content ƥ
     */
    Document(HawkContext context, Content content) {
        this.context = context;
        this.cache   = new ContentCache(content);
        this.content = content;
        this.idMap   = new IdMap();

        this.cache.add(content.url.toString(), content);
        this.baseUrl = content.url;
        if (baseUrl.getProtocol().compareTo("file") == 0) {
            this.zone = ZONE_LOCAL;
        } else {
            this.zone = ZONE_INTERNET;
        }
    }

    /**
     * ꤷƥĤޤǤ뤫֤ޤ
     *
     * @param  content ƥ
     *
     * @return ޤǤ <code>true</code>
     *         ޤǤʤ <code>false</code>
     */
    public boolean contains(Content content) {
        return cache.contains(content);
    }

    /**
     * ޥ͡ꤷޤ
     *
     * @param  sm ޥ͡
     */
    void setStyleManager(StyleManager sm) {
        this.styleManager = sm;
    }

    /**
     * ١ URL ֤ޤ
     *
     * @return ١ URL
     */
    public URL getBaseURL() {
        return baseUrl;
    }

    /**
     * ١ URL ѹޤ
     *
     * @param  url ١ URL
     */
    void setBaseURL(URL url) {
        baseUrl = url;
    }

    /**
     * ١åȤ֤ޤ
     *
     * @return ١å
     */
    public String getBaseTarget() {
        return baseTarget;
    }

    /**
     * ١åȤѹޤ
     *
     * @param  target å
     */
    void setBaseTarget(String target) {
        baseTarget = target;
    }

    /**
     * ȥ֤ޤ
     *
     * @return ȥ
     */
    public String getTitle() {
        return title;
    }

    /**
     * ȥꤷޤ
     *
     * @param  title ȥ
     */
    void setTitle(String title) {
        this.title = title;
    }

    /**
     * طʾ֤ޤ
     *
     * @return طʾ
     */
    public Background getBackground() {
        return background;
    }

    /**
     * طʾꤷޤ
     *
     * @param  background طʾ
     */
    void setBackground(Background background) {
        this.background = background;
    }

    /**
     * ѤιԤȡʸι⤵֤ޤ
     *
     * @return ȹ⤵
     */
    public Dimension getCharScale() {
        return charScale;
    }

    /**
     * ѤιԤȡʸι⤵ꤷޤ
     * {@link java.awt.Dimension#width} Ԥ
     * {@link java.awt.Dimension#height} ʸι⤵ɽޤ
     *
     * @param  scale ȹ⤵
     */
    void setCharScale(Dimension scale) {
        this.charScale = scale;
    }

    /**
     * ɥȤ URL ١ URL ֤ޤ
     *
     * @param  href ѥ
     *
     * @return ɥȤ URL ١ˤ URL
     *
     * @throws MalformedURLException ѥʾ
     * @throws SecurityException ƥȿξ
     */
    public URL createURL(String href)
            throws MalformedURLException, SecurityException {
        URL url = new URL(baseUrl, href);

        if (zone != ZONE_LOCAL && url.getProtocol().compareTo("file") == 0) {
            throw new SecurityException("Can not access to local file");
        }

        return url;
    }

    /**
     * å夫饳ƥĤޤ
     *
     * @param  urlString URL ʸ
     *
     * @return ƥġå̵ <code>null</code>
     */
    Content getContentFromCache(String urlString) {
        return cache.get(urlString);
    }

    /**
     * å˥ƥĤɲäޤ
     *
     * @param  urlString URL ʸ
     * @param  content   ƥ
     */
    void addContentToCache(String urlString, Content content) {
        cache.add(urlString, content);
    }

    /**
     * ȥ󥿡äޤ
     */
    synchronized void increment() {
        referenceCount++;
    }

    /**
     * ȥ󥿡򸺾ޤ
     * Ȥ¸ߤʤʤäϡ꥽ޤ
     *
     * @return Ȥ¸ߤʤʤä <code>true</code>
     *         ޤȤ¸ߤ <code>false</code>
     */
    synchronized boolean decrement() {
        if (--referenceCount > 0) {
            return false;
        }

        cache.clear();

        return true;
    }
}
