/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.Debug;

import java.util.Hashtable;

/**
 * å륯饹Ǥ
 * Υ饹ˤϡURL ФƥĤǼޤ
 * URL ʸˤ륭åʤΤǡ
 * POST ǡξϡǼƤϤޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
final class ContentCache {
    private Hashtable cache = new Hashtable();
    private Entry     top;
    private Entry     last;

    /**
     * ƥĥåޤ
     *
     * @param  content ᥤ󥳥ƥ
     */
    ContentCache(Content content) {
        add(content.url.toString(), content);
    }

    /**
     * åɲäޤ
     *
     * @param  url     URL ʸ
     * @param  content ƥ
     */
    synchronized void add(String url, Content content) {
        Entry entry = new Entry(content);

        if (!cache.containsKey(url)) {
            cache.put(url, entry);
        }

        append(entry);
    }

    /**
     * å奨ȥ꡼ޤ
     *
     * @param  url URL ʸ
     *
     * @return å奨ȥ꡼
     *         ¸ߤʤ <code>null</code>
     */
    synchronized Content get(String url) {
        Entry entry = (Entry) cache.get(url);

        if (entry == null) {
            return null;
        }

        Content content = entry.content;
        if (!content.canReUse()) {
            return null;
        }

        content.increment();

        append(new Entry(entry.content));

        return content;
    }

    /** κǸɲáץå */
    private void append(Entry entry) {
        if (last == null) {
            top = last = entry;
        } else {
            last = last.next = entry;
        }
    }

    /**
     * ٤ƤΥƥĤޤ
     */
    synchronized void clear() {
        Entry entry = top;

        while (entry != null) {
            entry.content.decrement();
            entry = entry.next;
        }

        //### BUGS ǥХå
        entry = top;
        while (entry != null) {
            if (entry.content.getReferenceCount() > 0) {
                Debug.err.println("### ERROR ### ContentCache.clear : ReferanceCount : " + entry.content.getReferenceCount() + ", " + entry.content.url);
            }
            entry = entry.next;
        }

        top = last = null;
        cache.clear();
    }

    /**
     * ꤷƥĤޤǤ뤫֤ޤ
     *
     * @param  content ƥ
     *
     * @return ޤǤ <code>true</code>
     *         ޤǤʤ <code>false</code>
     */
    synchronized boolean contains(Content content) {
        Entry entry = top;

        while (entry != null) {
            if (entry.content == content) {
                return true;
            }
            entry = entry.next;
        }

        return false;
    }

//### Entry
    /** ȥ꡼ */
    private final class Entry {
        private Entry next;

        private Content content;

        /** 󥹥󥹤 */
        private Entry(Content content) {
            this.content = content;
        }
    }
}
