/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.addin.java2.AWTWrapper;
import net.hizlab.kagetaka.awt.Drawer;
import net.hizlab.kagetaka.awt.image.SyncObserver;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

/**
 * ѥͥ褹֥å᡼ݻ륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.8 $
 */
public class Canvas {
    private static final int DRAW_WAIT      = 10000;       // Ԥ

    private static final int SPIN_RIGHT = 0;
    private static final int SPIN_LEFT  = 1;
    private static final int SPIN_LTRB  = 2;

    /** ¥ٹɽץ */
    public static final char DRAW_SOKUYOU = 0x0002;

    private HawkContext context;
    private Drawkit     drawkit;
    private Status      baseStatus;
    private AWTWrapper  awtWrapper;         // ꥢ
    private int         canvasIndex = -1;
    private Canvas      prev;

    public int         width;                      // ᡼
    int         height;                     // ᡼⤵
    public int         x;                          // X
    public Image       image;                      // ᡼
    public Graphics    g;                          // Graphics
    public ItemMap     itemMap;                    // ƥޥå

    private SyncObserver imageDrawer = new SyncObserver(); // Ԥ
    private Drawer       drawer      = new Drawer() {
        /**  */
        public void setColor(Color color) {
            g.setColor(color);
        }

        /** ɤĤ֤ */
        public void fillRect(int x, int y, int width, int height) {
            g.fillRect(x, y, width, height);
        }

        /**  */
        public void drawImage(Image image,
                              int dx1, int dy1, int dx2, int dy2,
                              int sx1, int sy1, int sx2, int sy2) {
            drawImageSync(g, image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
        }
    };

    /**
     * 襭Хޤ
     *
     * @param  drawkit    ɥå
     * @param  status     ơ
     * @param  prev       ľΥХ
     * @param  width      
     * @param  height     ⤵
     * @param  totalWidth 襭Хι
     */
    public Canvas(Drawkit drawkit, Status status,
                  Canvas prev, int width, int height, int totalWidth) {
        this.context    = drawkit.context;
        this.drawkit    = drawkit;
        this.baseStatus = status;
        this.awtWrapper = (drawkit.antiAliasing ? drawkit.awtWrapper : null);
        this.prev       = prev;

        resize(width, height, totalWidth);
    }

    /**
     * ХΥѹޤ
     *
     * @param  width      
     * @param  height     ⤵
     * @param  totalWidth 襭Хι
     */
    public void resize(int width, int height, int totalWidth) {
        this.width   = width;
        this.height  = height;
        this.x       = (prev != null ? prev.x + prev.width : 0);

        // 롼ľΥ֥åȤ Canvas 뤿ᡢ
        // եȤˤ width == 0  Canvas 뤳Ȥ⤢
        if (width > 0 && height > 0) {
            this.image   = drawkit.createImage(width, height);
            this.g       = image.getGraphics();
            this.itemMap = new ItemMap();
            setupGraphics(this.g);

            // طʤ
            drawBackground(0, 0, width, height, totalWidth, x, baseStatus);
        }
    }

    /**
     * եå֥Ȥ򥻥åȥåפޤ
     *
     * @param  g եå
     */
    private void setupGraphics(Graphics g) {
        if (awtWrapper != null) {
            awtWrapper.setAntiAliasing(g, true);
        }
    }

    /**
     * Х򥳥ߥåȤޤ
     *
     * @param  reason ߥåȻͳ
     * @param  tag    
     */
    public void commit(int reason, int tag) {
        if (image != null) {
            g.dispose();
        }

        drawkit.setupPanel();
        canvasIndex = context.setImage(canvasIndex, reason, tag,
                                       image, width, height, itemMap);

        image = null;
        g     = null;
    }

    /**
     * ХΥ꥽˴ޤ
     */
    public void dispose() {
        // commit ƤФƤʤȤΤ image != null
        if (image != null) {
            g.dispose();
            image.flush();

            image = null;
            g     = null;
        }
    }

//### 
    /**
     * طʤ褷ޤ
     *
     * @param  x          X
     * @param  y          Y
     * @param  width      
     * @param  height     ⤵
     * @param  totalWidth طʤ
     * @param  offset     طʲΥեå
     * @param  status     ơ
     */
    public void drawBackground(int x, int y, int width, int height,
                               int totalWidth, int offset, Status status) {
        if (status.background != null) {
            status.background.draw(drawer, x, y, width, height, totalWidth, offset, 0);
        }
    }

    /**
     * ʸĤ褷ޤ
     *
     * @param  values  ʸ
     * @param  widths  ʸ
     * @param  heights ʸι⤵
     * @param  options ץ
     * @param  begin   Хåեγϰ
     * @param  end     Хåեνλ
     * @param  x       X
     * @param  y       Y
     * @param  width   ʸκ
     * @param  indent  ʸΥǥ
     * @param  status  ơ
     */
    public void drawTextTate(char[] values, int[] widths, int[] heights, char[] options,
                             int begin, int end,
                             int x, int y, int width,
                             int indent, Status status) {
        int w;

        // ǥ̤ȡեȤι⤵ʬذư
        y += indent + status.fontFullBase;

        for (int i = begin; i < end; i++) {
            if ((options[i] & DRAW_SOKUYOU) != 0) {
                g.drawChars(values, i, 1,
                            (width > (w = widths[i])
                             ? x + ((width - w) / 2)
                             : x) + status.fontMiniLeft,
                            y + status.fontMiniUp);
            } else {
                g.drawChars(values, i, 1,
                            (width > (w = widths[i])
                             ? x + ((width - w) / 2)
                             : x),
                            y);
            }
            y += heights[i];
        }
    }

    /**
     * ʸž褷ޤ
     *
     * @param  values  ʸ
     * @param  widths  ʸ
     * @param  begin   Хåեγϰ
     * @param  end     Хåեνλ
     * @param  x       X
     * @param  y       Y
     * @param  width   žʤʸκ
     * @param  height  žʤʸκι⤵
     * @param  indent  ʸΥǥ
     * @param  status  ơ
     */
    public void drawTextWithRight(char[] values, int[] widths,
                                  int begin, int end,
                                  int x, int y, int width, int height,
                                  int indent, Status status) {
        // եȤΤʤʸž褦Ȥ
        if (width == 0) {
            return;
        }

        Image scrapImage = null;            // žƤʤ᡼
        Image backImage  = null;            // žطʤȴФ᡼
        try {
            scrapImage = drawkit.createImage(width, height);
            backImage  = drawkit.createImage(height, width);

            // طʤȴФ
            Graphics bg = backImage.getGraphics();
            try {
                drawImageSync(bg, image,
                              0, 0, height    , width,
                              x, y, height + x, width + y);
            } finally {
                bg.dispose();
            }

            // žƤʤåפ
            Graphics sg = scrapImage.getGraphics();
            try {
                setupGraphics(sg);

                // طʤž
                drawImage(backImage, sg, 0, 0, height, width, SPIN_LEFT);

                // ʿ
                sg.setColor(status.foreColor);
                sg.setFont (status.font     );

                // ǥ̤ȡեȤι⤵ʬʱˤذư
                int scrapImageX = indent;

                // 
                char c;
                int fontHalfBase = status.fontHalfBase;
                int fontFullBase = status.fontFullBase;
                for (int i = begin; i < end; i++) {
                    c = values[i];
                    sg.drawChars(values, i, 1,
                                 scrapImageX,
                                 ((c <= 0xFF) || (0xFF61 <= c && c <= 0xFF9F)
                                  ? fontHalfBase
                                  : fontFullBase));
                    scrapImageX += widths[i];
                }
            } finally {
                sg.dispose();
            }

            // ˲ž
            drawImage(scrapImage, g, x, y, width, height, SPIN_RIGHT);
        } catch (Exception e) {
            drawkit.reportMessage(Reporter.ERROR,
                                  "render.error.spin",
                                  new Object[]{
                                      new String (values, begin, end - begin),
                                      new Integer(width ),
                                      new Integer(height)
                                  });
            drawkit.reportMessage(e);
        } finally {
            // ꥽
            if (scrapImage != null) {
                scrapImage.flush();
            }
            if (backImage  != null) {
                backImage .flush();
            }
        }
    }

    /**
     * ʸ򺸾屦ȿž褷ޤ
     *
     * @param  c      ʸ
     * @param  x      X
     * @param  y      Y
     * @param  width  
     * @param  height ⤵
     * @param  status ơ
     */
    public void drawCharWithLtrb(char c, int x, int y, int width, int height,
                                 Status status) {
        // եȤΤʤʸž褦Ȥ
        if (width == 0) {
            return;
        }

        Image scrapImage = null;            // žƤʤ᡼
        Image backImage  = null;            // žطʤȴФ᡼
        try {
            scrapImage = drawkit.createImage(width, height);
            backImage  = drawkit.createImage(height, width);

            // طʤž
            Graphics bg = backImage.getGraphics();
            try {
                drawImageSync(bg, image,
                              0, 0, height    , width,
                              x, y, height + x, width + y);
            } finally {
                bg.dispose();
            }

            // žƤʤåפ
            Graphics sg = scrapImage.getGraphics();
            try {
                setupGraphics(sg);

                // طʤȿž
                drawImage(backImage, sg, 0, 0, height, width, SPIN_LTRB);

                // ʿ
                sg.setColor(status.foreColor);
                sg.setFont (status.font     );

                // ǥ̤ȡեȤι⤵ʬʱˤ
                sg.drawChars(new char[]{c}, 0, 1,
                             0, status.fontFullBase);
            } finally {
                sg.dispose();
            }

            // ȿž
            drawImage(scrapImage, g, x, y, width, height, SPIN_LTRB);
        } catch (Exception e) {
            drawkit.reportMessage(Reporter.ERROR,
                                  "render.error.spin",
                                  new Object[]{
                                      new Character(c     ),
                                      new Integer  (width ),
                                      new Integer  (height)
                                  });
            drawkit.reportMessage(e);
        } finally {
            // ꥽
            if (scrapImage != null) {
                scrapImage.flush();
            }
            if (backImage  != null) {
                backImage .flush();
            }
        }
    }

    /** ž */
    private void drawImage(Image scrapImage, Graphics g,
                           int x, int y, int width, int height, int mode) {
        int   i, j, n;
        int   size    = width * height;
        int[] bitmap1 = new int[size];
        int[] bitmap2 = new int[size];

        //  int Ѵ
        PixelGrabber pg = new PixelGrabber(scrapImage, 0, 0, width, height, bitmap1, 0, width);
        try {
            // ѴǼԤƤ⡢̵뤷Ʒ³ƹʤ
            pg.grabPixels(DRAW_WAIT);
        } catch (InterruptedException e) { }

        // ֤ؤ
        switch (mode) {
        case SPIN_RIGHT:
            // ž
            for (i = 0; i < width; i++) {
                n = i * height;
                for (j = 0; j < height; j++) {
                    bitmap2[n + j] = bitmap1[i + (height - j - 1) * width];
                }
            }
            break;
        case SPIN_LEFT:
            // ž
            for (i = 0; i < width; i++) {
                n = i * height;
                for (j = 0; j < height; j++) {
                    bitmap2[n + j] = bitmap1[(j + 1) * width - 1];
                }
            }
            break;
        case SPIN_LTRB:
            // 屦ȿž
            for (i = 0; i < width; i++) {
                n = i * height;
                for (j = 0; j < height; j++) {
                    bitmap2[n + j] = bitmap1[i + j * width];
                }
            }
            break;
        default: // AVOID
        }

        // ᡼Ǥϡwidth  height ͤϸ򴹤Ƥ
        MemoryImageSource mis = new MemoryImageSource(height, width, bitmap2, 0, height);
        mis.setAnimated(false);
        Image spunImage = drawkit.toolkit.createImage(mis);
        try {
            // 褹褦ˤ
            drawImageSync(g, spunImage, x, y, height, width);
        } finally {
            // ꥽
            spunImage.flush();
        }
    }

    /**
     * Ʊ褷ޤ
     *
     * @param  g      եå
     * @param  image  
     * @param  x      X
     * @param  y      Y
     * @param  width  
     * @param  height ⤵
     */
    public void drawImageSync(Graphics g, Image image,
                              int x, int y, int width, int height) {
        synchronized (imageDrawer) {
            imageDrawer.init(g, x, y, width, height);
            if (!g.drawImage(image, x, y, width, height, imageDrawer)) {
                try {
                    imageDrawer.wait(DRAW_WAIT);
                } catch (InterruptedException e) {
                    throw new StopException("wait to draw a image");
                }
            }
        }
    }

    /**
     * Ʊ褷ޤ
     *
     * @param  g     եå
     * @param  image 
     * @param  dx1   κ X
     * @param  dy1   κ Y
     * @param  dx2   α X
     * @param  dy2   α Y
     * @param  sx1   踵κ X
     * @param  sy1   踵κ Y
     * @param  sx2   踵α X
     * @param  sy2   踵α Y
     */
    public void drawImageSync(Graphics g, Image image,
                              int dx1, int dy1, int dx2, int dy2,
                              int sx1, int sy1, int sx2, int sy2) {
        synchronized (imageDrawer) {
            imageDrawer.init(g, dx1, dy1, dx2 - dx1, dy2 - dy1);
            if (!g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, imageDrawer)) {
                try {
                    imageDrawer.wait(DRAW_WAIT);
                } catch (InterruptedException e) {
                    throw new StopException("wait to draw a image");
                }
            }
        }
    }
}
