/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.awt.Drawer;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.token.Value;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;

/**
 * ɥȤطʾɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.6 $
 */
public class Background implements Cloneable {
    private FontData  fontData;             // եȥǡ
    private Color     backColor;            // طʿ
    private Image     backImage;            // طʲ
    private Dimension backImageSize;        // طʲ
    private boolean   backRepeatH   = true; // ʿԡ
    private boolean   backRepeatV   = true; // ľԡ
    private Value     backPositionH;        // ʿݥ
    private Value     backPositionV;        // ľݥ

    /**
     * طʾΥ󥹥󥹤ޤ
     */
    Background() {
    }

    /**
     * Υ󥹥󥹤ʣʪ֤ޤ
     *
     * @return ʣ󥹥
     */
    public Object clone() {
        try {
            return super.clone();
        } catch (CloneNotSupportedException e) { }
        return this;
    }

    /**
     * եȥǡꤷޤ
     *
     * @param  fontData եȥǡ
     */
    void set(FontData fontData) {
        this.fontData = fontData;
    }

    /**
     * طʿꤷޤ
     *
     * @param  color طʿ
     */
    void set(Color color) {
        this.backColor = color;
    }

    /**
     * طʲꤷޤ
     *
     * @param  image     طʲ
     * @param  size      
     * @param  repeat    ԡ
     * @param  positionV ľΰ
     * @param  positionH ʿΰ
     */
    void set(Image image, Dimension size, Value repeat,
             Value positionH, Value positionV) {
        this.backImage     = image;
        this.backImageSize = size;
        this.backRepeatH   = true;
        this.backRepeatV   = true;
        if (repeat != null) {
            int type = repeat.getType();
            if (type == Value.TYPE_KEY_REPEAT_X) {
                backRepeatH = false;
            }
            if (type == Value.TYPE_KEY_REPEAT_Y) {
                backRepeatV = false;
            }
            if (type == Value.TYPE_KEY_NO_REPEAT) {
                backRepeatH = false;
                backRepeatV = false;
            }
        }
        this.backPositionH = positionH;
        this.backPositionV = positionV;
    }

    /**
     * طʿޤ
     *
     * @return طʿ
     */
    public Color getColor() {
        return backColor;
    }

    /**
     * طʤ褷ޤ
     *
     * @param  drawer     ѥ󥿡ե
     * @param  x          X
     * @param  y          Y
     * @param  width      
     * @param  height     ⤵
     * @param  totalWidth طʤ
     * @param  offsetX    طʲΥեå X
     * @param  offsetY    طʲΥեå Y
     */
    public void draw(Drawer drawer,
                     int x, int y, int width, int height,
                     int totalWidth, int offsetX, int offsetY) {

        // طʿɤ
        if (backColor != null) {
            drawer.setColor(backColor);
            drawer.fillRect(x, y, width, height);
        }

        // طʲߤ
        if (backImage != null) {
            int     imageWidth  = this.backImageSize.width;
            int     imageHeight = this.backImageSize.height;
            boolean backRepeatH = this.backRepeatH;
            boolean backRepeatV = this.backRepeatV;
//Debug.out.println("draw="+x+","+y+","+width+","+height+","+imageWidth+","+imageHeight);

            int dx1, dy1, dx2, dy2;
            int sx1, sy1, sx2, sy2;
            int bottom = y + height;
            int diff;

            // ΤϤ߽ФڤӡեåȤθ X 
            dx2 = x + width;
            sx1 = 0;
            diff = getPositionDiff(backPositionH, totalWidth, imageWidth,
                                   Value.DATA_HORIZONTAL, offsetX, backRepeatH);
            if (diff < 0) {
                return;
            }
            if (diff > 0) {
                dx1 = dx2 - diff;
                if (diff > imageWidth) {
                    dx2 = dx1 + imageWidth;
                    sx2 = imageWidth;
                } else {
                    sx2 = diff;
                }
            } else {
                dx1 = dx2 - imageWidth;
                sx2 = imageWidth;
            }
            // ΤϤ߽Фθ
            diff = getPositionDiff(backPositionV, height, imageHeight,
                                   Value.DATA_VERTICAL, offsetY, backRepeatV);
            if (diff < 0) {
                return;
            }

            for (;;) {
                // Y 
                sy2 = imageHeight;
                if (diff > 0) {
                    dy2 = y + diff;
                    if (diff > imageHeight) {
                        dy1 = dy2 - imageHeight;
                        sy1 = 0;
                    } else {
                        dy1 = y;
                        sy1 = imageHeight - diff;
                    }
                } else {
                    dy1 = y;
                    dy2 = y + imageHeight;
                    sy1 = 0;
                }
                for (;;) {
//Debug.out.println(dx1 + "," + dy1 + "," + dx2 + "," + dy2 + "," + sx1 + "," + sy1 + "," + sx2 + "," + sy2);
                    drawer.drawImage(backImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
                    if (!backRepeatV || dy2 >= bottom) {
                        break;
                    }

                    // Y ư
                    dy1 =  dy2;
                    dy2 += imageHeight;
                    sy1 =  0;
                    if (dy2 > bottom) {
                        sy2 -= dy2 - bottom;
                        dy2 =  bottom;
                    }
                }

                if (!backRepeatH || dx1 <= x) {
                    break;
                }

                // X ư
                dx2 =  dx1;
                dx1 -= imageWidth;
                sx2 =  imageWidth;
                if (dx1 < x) { // ˤϤ߽ФȤʺǸΤߡ
                    sx1 = x - dx1;
                    dx1 = x;
                }
            }
        }
    }

    /** ݥ֤ */
    private int getPositionDiff(Value position, int outer, int inner,
                                int sense, int offset, boolean repeat) {
        int diff;
        if (position == null) {
            if (offset == 0) {
                return 0;
            }
            diff = -offset;
        } else {
            diff = position.getValue(1,
                                     (position.getUnit() == Value.UNIT_PERCENT
                                      ? outer - inner
                                      : outer),
                                     fontData,
                                     sense)
                 - offset;
            if (diff == 0) {
                return 0;
            }
        }

        if (repeat) {
            // ֱ֤
            if ((diff %= inner) < 0
                    && (diff += inner) <= 0) {
                // 褹Τ̵
                return -1;
            }
        } else if ((diff += inner) <= 0) {
            return -1;
        }

        return diff;
    }
}
