/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.protocol.http;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.io.TeeInputStream;
import net.hizlab.kagetaka.protocol.CacheFile;
import net.hizlab.kagetaka.protocol.CacheManager;
import net.hizlab.kagetaka.protocol.CacheSupported;
import net.hizlab.kagetaka.protocol.ProxySupported;
import net.hizlab.kagetaka.protocol.URLConnectionCache;
import net.hizlab.kagetaka.rendering.PostData;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.ProtocolException;

/**
 * å򥵥ݡȤ <code>http</code> ץȥΥͥɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class SunHttpURLConnection
        extends sun.net.www.protocol.http.HttpURLConnection
        implements CacheSupported, ProxySupported {
    private URL                      realUrl;
    private URLConnectionCache.Entry cacheEntry;
    private CacheManager             cacheManager;
    private CacheFile                cacheFile;
    private boolean                  validCacheFile;
    private PostData                 postData;
    private InputStream              inputStream;
    private boolean                  reentrantInputStream;

    /**
     * 󥹥󥹤ޤ
     *
     * @param  url        URL
     * @param  handler    ץȥϥɥ
     * @param  realUrl     URL
     * @param  cacheEntry å奨ȥ
     *
     * @throws IOException IO 顼ȯ
     */
    SunHttpURLConnection(URL url, SunHandler handler,
                         URL realUrl, URLConnectionCache.Entry cacheEntry)
            throws IOException {
        super(url, handler);
        this.realUrl = realUrl;
Debug.out.println("@url=" + realUrl);

        // إå
        cacheEntry.setupURLConnection(this);
        this.cacheEntry = cacheEntry;
    }

//### CacheSupported
    /** {@inheritDoc} */
    public void setupCache(CacheManager cm, PostData pd) {
        this.cacheManager = cm;
        this.postData     = pd;
    }

    /** {@inheritDoc} */
    public void removeCache() {
        cacheEntry.dispose();
        if (validCacheFile && cacheManager != null) {
            cacheManager.removeEntry(this, postData);
        }
    }

    /** {@inheritDoc} */
    public String getCachePath() {
        if (cacheFile != null) {
            return cacheFile.getPath();
        }

        return null;
    }

//### URLConnection
    /**
     * ºݤ³ URL ֤ޤ
     *
     * @return URL
     */
    public URL getURL() {
        return realUrl;
    }

    /**
     * ³Ԥޤ
     *
     * @throws IOException IO 顼ȯ
     */
    public void connect()
            throws IOException {
        if (connected) {
            return;
        }

        // Connector ƤФ줿ȤʳΤߡå夫ɤ߹
        if (/*---*/cacheManager == null
                && (cacheFile = cacheEntry.getCacheFile()) != null) {
            try {
                inputStream     = cacheFile.getInputStream();
Debug.out.println("isHit=" + cacheFile.getName() + "," + realUrl);
                validCacheFile  = true;
                connected       = true;
                responseCode    = HTTP_OK;
                responseMessage = "OK";
                return;
            } catch (IOException e) {
Debug.out.println(e);
            }
        }

        super.connect();
    }

    /**
     * ꥯȤǽϤϥȥ꡼ᤷޤ
     *
     * @return ϥȥ꡼
     *
     * @throws IOException IO 顼ȯ
     */
    public OutputStream getOutputStream()
            throws IOException {
        if (validCacheFile) {
            throw new ProtocolException("Cannot write output by cache.");
        }

        return super.getOutputStream();
    }

    /**
     * ꥯȥץѥƥꤷޤ
     *
     * @param  key   
     * @param  value 
     */
    public void setRequestProperty(String key, String value) {
        super.setRequestProperty(key, value);

        // 󥹥ȥ饯 cacheEntry.setupURLConnection(this);
        // ƤФ줿ϡϿʤ褦ˤ
        if (cacheEntry != null) {
            cacheEntry.setRequestProperty(key, value);
        }
    }

    /**
     * 쥹ݥ󥹤ɤ߹ϥȥ꡼ᤷޤ
     *
     * @return ϥȥ꡼
     *
     * @throws IOException IO 顼ȯ
     */
    public synchronized InputStream getInputStream()
            throws IOException {
        if (!connected) {
            connect();
        }

        if (inputStream != null) {
            return inputStream;
        }

        if (reentrantInputStream) {
            return super.getInputStream();
        }

        reentrantInputStream = true;
        try {
            InputStream is = super.getInputStream();

            if (cacheManager != null && responseCode < 300) {
                if ((cacheFile = cacheManager.getFile(this)) != null) {
                    is = new TeeInputStream(is, new CacheOutputStream(cacheFile), getContentLength());
                }
            }

if (responseCode == HTTP_NOT_MODIFIED) {
Debug.out.println("isNmod=," + realUrl);
} else {
Debug.out.println("isMiss=" + (cacheFile != null ? cacheFile.getName() : "") + "," + realUrl);
}
            return (inputStream = is);
        } finally {
            reentrantInputStream = false;
        }
    }

//### CacheOutputStream
    /** åϥȥ꡼ */
    private final class CacheOutputStream extends FileOutputStream {
        /** 󥹥󥹤 */
        private CacheOutputStream(File file)
                throws IOException {
            super(file);
        }

        /** Ĥ */
        public void close()
                throws IOException {
            synchronized (SunHttpURLConnection.this) {
                if (validCacheFile) {
                    return;
                }
                super.close();

                validCacheFile = true;

                // åɲ
                cacheEntry.setCacheFile(cacheFile);
                if (cacheManager != null) {
                    cacheManager.addEntry(SunHttpURLConnection.this, postData, cacheFile);
                }
            }
        }
    }
}
