/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.protocol.about;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.Resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;

/**
 * <code>about</code> ץȥΥͥɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class AboutURLConnection extends URLConnection {
    private static final String RESOURCE = "net.hizlab.kagetaka.protocol.about.Resources";
    private static final String BUILD_RESOURCE = "net.hizlab.kagetaka.Build";
    private static final byte[] DEFAULT  = "<html><head></head><body></body></html>".getBytes();
    private static final String ENCODING = "SJIS";

    private ByteArrayOutputStream postData;

    /**
     * 󥹥󥹤ޤ
     *
     * @param  url URL
     */
    AboutURLConnection(URL url) {
        super(url);
    }

    /**
     *  URL Ȥ꥽ؤ̿󥯤Ωޤ
     * (̿󥯤ΩƤʤ)
     *
     * @throws IOException ³γΩ I/O 顼ȯ
     */
    public synchronized void connect()
            throws IOException {
        if (connected) {
            return;
        }

        connected = true;
    }

    /**
     * <code>content-type</code> إåեɤ֤ͤޤ
     *
     * @return URL Ȥ꥽ξμࡣ
     *         ξ <code>null</code>
     */
    public String getContentType() {
        // Shift_JIS ̵
        return "text/html; charset=Shift_JIS";
    }

    /**
     * ³˥ǡϥȥ꡼֤ޤ
     *
     * @return ³ϥȥ꡼
     *
     * @throws IOException ϥȥ꡼κ I/O 顼ȯ
     */
    public OutputStream getOutputStream()
            throws IOException {
        if (!connected) {
            connect();
        }

        return (postData = new ByteArrayOutputStream());
    }

    /**
     * ³Ϥϥȥ꡼֤ޤ
     *
     * @return ³Ϥϥȥ꡼
     *
     * @throws IOException ϥȥ꡼κ I/O 顼ȯ
     */
    public InputStream getInputStream()
            throws IOException {
        if (!connected) {
            connect();
        }

        Hashtable hash = null;

        ByteArrayOutputStream postData = this.postData;
        if (postData != null) {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(postData.toByteArray()));
            try {
                hash = (Hashtable) ois.readObject();
            } catch (ClassNotFoundException e) {
                //### ERROR
Debug.out.println(e);
            }
        }

        byte[] data = Resource.getBinaryResource(RESOURCE, url.toString().replace(':', '.'));
        if (data == null) {
            data = DEFAULT;
        } else {
            data = replaceData(data, hash);
        }

        return new ByteArrayInputStream(data);
    }

    /** ǡüʸ֤ޤ */
    private byte[] replaceData(byte[] data, Hashtable hash) {
        try {
            String value  = new String(data, ENCODING);
            int    length = value.length();

            if (length <= 1) {
                return data;
            }

            StringBuffer sb  = new StringBuffer();
            StringBuffer key = null;
            char c;
            for (int i = 0; i < length; i++) {
                c = value.charAt(i);

                switch (c) {
                case '\\':
                    if (++i < length) {
                        sb.append(value.charAt(i));
                    }
                    continue;
                case '$':
                    if (++i < length && value.charAt(i) == '{') {
                        if (key == null) {
                            key = new StringBuffer();
                        } else {
                            key.setLength(0);
                        }

                        while (++i < length) {
                            if ((c = value.charAt(i)) == '}') {
                                sb.append(getKeyValue(key.toString(), hash));
                                break;
                            }
                            key.append(c);
                        }
                    }
                    continue;
                default: // AVOID
                }

                sb.append(c);
            }

            return sb.toString().getBytes(ENCODING);
        } catch (UnsupportedEncodingException e) {
            return data;
        }
    }

    /** ͤ */
    private String getKeyValue(String key, Hashtable hash) {
        String value;

        if (hash != null && (value = (String) hash.get(key)) != null) {
            return value;
        }

        if ((value = Resource.getMessage(RESOURCE, key, null, null)) != null) {
            return value;
        }

        if (key.startsWith("java.")) {
            return System.getProperty(key.substring(5), "");
        }

        if (key.startsWith("build.")) {
            return Resource.getMessage(BUILD_RESOURCE, key, null);
        }

        return Resource.getMessage("kagetaka." + key, null);
    }
}
