/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.protocol;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.net.URLUtils;

import java.net.URL;
import java.net.URLConnection;
import java.net.MalformedURLException;
import java.util.Hashtable;

/**
 * URL ݻƤ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public final class URLConnectionCache {
    private static URLConnectionCache urlCache = new URLConnectionCache();

    /**
     * å奨ȥ꡼ޤ
     *
     * @param  url   URL
     *
     * @return ȥ꡼
     */
    public static Entry getEntry(URL url) {
        return urlCache.findEntry(url);
    }


    private Hashtable cache = new Hashtable();

    /** ߡ */
    private URLConnectionCache() {
    }

    /**
     * å奨ȥ꡼ޤ
     *
     * @param  url   URL
     *
     * @return ȥ꡼
     */
    private synchronized Entry findEntry(URL url) {
        String urlString = URLUtils.getFullPath(url);
        Set   set   = (Set) cache.get(urlString);
        Entry entry = null;

        if (set == null) {
            cache.put(urlString, set = new Set(urlString));
        } else {
            entry = set.find(url);
        }

        //### BUGS ۵ Ťȥ꡼ImageCache οƱפʤϤ
        if (entry == null) {
            set.add(entry = new Entry(url));
        }

        return entry;
    }

//### Set
    /** Ʊ URL Υå */
    private static final class Set {
        private String urlString;
        private Entry  top;
        private Entry  last;

        /** 󥹥󥹤 */
        private Set(String urlString) {
            this.urlString = urlString;
        }

        /** ɲ */
        private void add(Entry entry) {
            if (top == null) {
                top = last = entry;
            } else {
                entry.prev = last;
                last = entry;
            }
        }

        /** ȥ򸡺 */
        private Entry find(URL url) {
            Entry entry = last;

            while (entry != null) {
                if (entry.url == url) {
                    return entry;
                }
                entry = entry.prev;
            }

            return null;
        }
    }

//### Entry
    /**
     * URL Υȥ꡼Ǥ
     */
    public static final class Entry {
        private URL          url;
        private String       proxyHost;
        private int          proxyPort;
        private Map          requestPropertyTop;
        private Map          requestPropertyLast;
        private CacheManager cacheManager;
        private CacheFile    cacheFile;
        private Entry        prev;

        /** 󥹥󥹤 */
        private Entry(URL url) {
            this.url = url;
        }

        /**
         * ץꤷޤ
         *
         * @param  host ۥ
         * @param  port ݡ
         */
        public synchronized void setProxy(String host, int port) {
            this.proxyHost = host;
            this.proxyPort = port;
        }

        /**
         * ץۥȤ֤ޤ
         *
         * @return ץۥ
         */
        public String getProxyHost() {
            return proxyHost;
        }

        /**
         * ץݡȤ֤ޤ
         *
         * @return ץݡ
         */
        public int getProxyPort() {
            return proxyPort;
        }

        /**
         * ץޤ
         *
         * @param  url URL
         *
         * @return ץդ URL
         */
        public synchronized URL setupProxy(URL url) {
            if (proxyHost == null) {
                return url;
            }

            try {
                return new URL(url.getProtocol(), proxyHost, proxyPort, url.toExternalForm());
            } catch (MalformedURLException e) {
                return url;
            }
        }

        /**
         * ꥯȥץѥƥꤷޤ
         *
         * @param  key   
         * @param  value 
         */
        public synchronized void setRequestProperty(String key, String value) {
            if (ignoreHeader(key)) {
                return;
            }

            Map map = requestPropertyTop;
            while (map != null) {
                if (map.key.equalsIgnoreCase(key)) {
                    map.key   = key;
                    map.value = value;
                    return;
                }
                map = map.next;
            }
            addRequestPropertyImpl(key, value);
        }

        /**
         * ꥯȥץѥƥɲäޤ
         *
         * @param  key   
         * @param  value 
         */
        public void addRequestProperty(String key, String value) {
            if (ignoreHeader(key)) {
                return;
            }

            addRequestPropertyImpl(key, value);
        }

        /** ꥯȥץѥƥºݤɲ */
        private synchronized void addRequestPropertyImpl(String key, String value) {
            if (requestPropertyTop == null) {
                requestPropertyTop = requestPropertyLast = new Map(key, value);
            } else {
                requestPropertyLast = requestPropertyLast.next = new Map(key, value);
            }
        }

        /**
         * ͥޤ
         *
         * @param  connection 륳ͥ
         */
        public synchronized void setupURLConnection(URLConnection connection) {
            Map map = requestPropertyTop;
            while (map != null) {
                connection.setRequestProperty(map.key, map.value);
                map = map.next;
            }
        }

        /**
         * åޥ͡ޤ
         *
         * @return åޥ͡
         */
        public CacheManager getCacheManager() {
            return cacheManager;
        }

        /**
         * åޥ͡ꤷޤ
         *
         * @param  cm åޥ͡
         */
        public void setCacheManager(CacheManager cm) {
            this.cacheManager = cm;
        }

        /**
         * åեޤ
         *
         * @return åե
         */
        public CacheFile getCacheFile() {
            return cacheFile;
        }

        /**
         * åեꤷޤ
         * ѤߤΥåޥ͡ؤλȤϲޤ
         *
         * @param  file åե
         */
        public void setCacheFile(CacheFile file) {
            this.cacheFile    = file;
            this.cacheManager = null;
        }

        /**
         * ꥽å夫ޤ
         */
        public void dispose() {
            //### BUGS ۵ å夫鼫ʬȤ
Debug.err.println("### BUGS ### URLConnectionCache.Entry.dispose : Can no delete from cache (" + cacheFile + ")");
(new RuntimeException()).printStackTrace(Debug.err);
        }

        /** ݻʤإåɤ֤ */
        private boolean ignoreHeader(String key) {
            // If- ǻϤޤإåݻʤ
            if (key.toLowerCase().startsWith("if-")) {
                return true;
            }

            return false;
        }
    }

//### Map
    /** ޥå */
    private static final class Map {
        private String key;
        private String value;
        private Map    next;

        /** 󥹥󥹤 */
        private Map(String key, String value) {
            this.key   = key;
            this.value = value;
        }
    }
}
