/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.parser;

import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Reporter;
import net.hizlab.kagetaka.token.Token;

import java.io.IOException;

/**
 * ѡϤ̤򡢤˲Ϥե륿ѡǤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public abstract class FilterParser implements Parser {
    /** ƥ */
    protected Content  content;
    /** ݡ */
    protected Reporter reporter;
    /** ؤΥѡ */
    protected Parser   parser;

    /**
     * ѡϤ̤򤵤˲Ϥե륿ѡޤ
     */
    public FilterParser() {
    }
    /**
     * ե륿оݤΥѡꤷޤ
     *
     * @param  content  ƥ
     * @param  reporter 顼ݡ
     * @param  parser   ͥȤѡ
     */
    public void setParser(Content content, Reporter reporter, Parser parser) {
        this.content  = content;
        this.reporter = reporter;
        this.parser   = parser;
    }

    /**
     * ѡ֤̾ޤǥեȤǤϲؤΥѡ֤̾ޤ
     *
     * @return ѡ̾
     */
    public String getParserName() {
        return parser.getParserName();
    }

    /**
     * ѡʸ֤ޤǥեȤǤϲؤΥѡ֤ޤ
     *
     * @return ѡ
     */
    public String getParserDescription() {
        return parser.getParserDescription();
    }

    /**
     * ǡեϤϰ֤ƬΥȡ֤ޤ
     * Υ᥽åɤϡ<code>null</code> ֤ޤǸƤӽФ³ޤ
     * <p>
     * ̿Ūʥ顼ȯϡ{@link ParseException}
     * 򥹥ޤ㳰ȯȡϤ򤽤Ǥޤ
     * <p>
     * Υ饹Υ֥饹äϡΥ᥽åɤ򥪡С饤ɤ
     * ե륿εǽޤ
     *
     * @return Ϥ̤ƬΥȡ
     *         ȡ¸ߤʤ <code>null</code>
     *
     * @throws ParseException ˥顼ȯ
     * @throws IOException    IO 顼ȯ
     */
    public Token next()
            throws ParseException, IOException {
        return parser.next();
    }

    /**
     * ߤɤ߹ΥǡΥ󥳡ǥ֤̾ޤ
     * ǥեȤǤϲؤΥѡΥ󥳡ǥ֤̾ޤ
     *
     * @return 󥳡ǥ̤̾ξ <code>null</code>
     */
    public String getEncoding() {
        return parser.getEncoding();
    }

    /**
     * ѡλ꥽ޤ
     */
    public void close() {
        parser.close();
    }
}
